/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.api;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invocation
implements SelfDescribing {
    public static final Object[] NO_PARAMETERS = null;
    private final Object invokedObject;
    private final Method invokedMethod;
    private final Object[] parameterValues;
    private static final Map<Class<?>, Class<?>> BOX_TYPES = new HashMap<Class<?>, Class<?>>(){
        {
            this.put(Boolean.TYPE, Boolean.class);
            this.put(Byte.TYPE, Byte.class);
            this.put(Character.TYPE, Character.class);
            this.put(Short.TYPE, Short.class);
            this.put(Integer.TYPE, Integer.class);
            this.put(Long.TYPE, Long.class);
            this.put(Float.TYPE, Float.class);
            this.put(Double.TYPE, Double.class);
        }
    };

    public Invocation(Object invoked, Method method, Object ... parameterValues) {
        this.invokedObject = invoked;
        this.invokedMethod = method;
        this.parameterValues = parameterValues == NO_PARAMETERS ? new Object[]{} : (Object[])parameterValues.clone();
    }

    public String toString() {
        return super.toString() + "[" + StringDescription.toString((SelfDescribing)this) + "]";
    }

    public boolean equals(Object other) {
        return other instanceof Invocation && this.equals((Invocation)other);
    }

    public boolean equals(Invocation other) {
        return other != null && this.invokedObject == other.invokedObject && this.invokedMethod.equals(other.invokedMethod) && Arrays.equals(this.parameterValues, other.parameterValues);
    }

    public int hashCode() {
        return this.invokedObject.hashCode() ^ this.invokedMethod.hashCode() ^ Arrays.hashCode(this.parameterValues);
    }

    public void describeTo(Description description) {
        description.appendText(this.invokedObject.toString());
        description.appendText(".");
        description.appendText(this.invokedMethod.getName());
        description.appendValueList("(", ", ", ")", this.parameterValues);
    }

    public Object getInvokedObject() {
        return this.invokedObject;
    }

    public Method getInvokedMethod() {
        return this.invokedMethod;
    }

    public int getParameterCount() {
        return this.parameterValues.length;
    }

    public Object getParameter(int i) {
        return this.parameterValues[i];
    }

    public Object[] getParametersAsArray() {
        return (Object[])this.parameterValues.clone();
    }

    public Object applyTo(Object target) throws Throwable {
        try {
            return this.invokedMethod.invoke(target, this.getParametersAsArray());
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }

    public void checkReturnTypeCompatibility(Object value) {
        Class<?> returnType = this.invokedMethod.getReturnType();
        if (returnType == Void.TYPE) {
            this.failIfReturnTypeIsNotNull(value);
        } else if (value == null) {
            this.failIfReturnTypeIsPrimitive();
        } else {
            Class<?> valueType = value.getClass();
            if (!this.isCompatible(returnType, valueType)) {
                this.reportTypeError(returnType, valueType);
            }
        }
    }

    private boolean isCompatible(Class<?> returnType, Class<?> valueType) {
        if (returnType.isPrimitive()) {
            return this.isBoxedType(returnType, valueType);
        }
        return returnType.isAssignableFrom(valueType);
    }

    private boolean isBoxedType(Class<?> primitiveType, Class<?> referenceType) {
        return BOX_TYPES.get(primitiveType) == referenceType;
    }

    private void failIfReturnTypeIsNotNull(Object result) {
        if (result != null) {
            throw new IllegalStateException("tried to return a value from a void method: " + result);
        }
    }

    private void failIfReturnTypeIsPrimitive() {
        Class<?> returnType = this.invokedMethod.getReturnType();
        if (returnType.isPrimitive()) {
            throw new IllegalStateException("tried to return null value from method returning " + returnType.getName());
        }
    }

    private void reportTypeError(Class<?> returnType, Class<?> valueType) {
        throw new IllegalStateException("tried to return a " + valueType.getName() + " from a method that can only return a " + returnType.getName());
    }
}

