/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelForwardedTCPIP;
import com.jcraft.jsch.ChannelX11;
import com.jcraft.jsch.Cipher;
import com.jcraft.jsch.Compression;
import com.jcraft.jsch.HASH;
import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchAuthCancelException;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.JSchPartialAuthException;
import com.jcraft.jsch.KeyExchange;
import com.jcraft.jsch.MAC;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.PortWatcher;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.Random;
import com.jcraft.jsch.ServerSocketFactory;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserAuth;
import com.jcraft.jsch.UserAuthKeyboardInteractive;
import com.jcraft.jsch.UserAuthNone;
import com.jcraft.jsch.UserAuthPassword;
import com.jcraft.jsch.UserAuthPublicKey;
import com.jcraft.jsch.UserInfo;
import com.jcraft.jsch.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class Session
implements Runnable {
    private static final String version = "JSCH-0.1.29";
    static final int SSH_MSG_DISCONNECT = 1;
    static final int SSH_MSG_IGNORE = 2;
    static final int SSH_MSG_UNIMPLEMENTED = 3;
    static final int SSH_MSG_DEBUG = 4;
    static final int SSH_MSG_SERVICE_REQUEST = 5;
    static final int SSH_MSG_SERVICE_ACCEPT = 6;
    static final int SSH_MSG_KEXINIT = 20;
    static final int SSH_MSG_NEWKEYS = 21;
    static final int SSH_MSG_KEXDH_INIT = 30;
    static final int SSH_MSG_KEXDH_REPLY = 31;
    static final int SSH_MSG_USERAUTH_REQUEST = 50;
    static final int SSH_MSG_USERAUTH_FAILURE = 51;
    static final int SSH_MSG_USERAUTH_SUCCESS = 52;
    static final int SSH_MSG_USERAUTH_BANNER = 53;
    static final int SSH_MSG_USERAUTH_INFO_REQUEST = 60;
    static final int SSH_MSG_USERAUTH_INFO_RESPONSE = 61;
    static final int SSH_MSG_USERAUTH_PK_OK = 60;
    static final int SSH_MSG_GLOBAL_REQUEST = 80;
    static final int SSH_MSG_REQUEST_SUCCESS = 81;
    static final int SSH_MSG_REQUEST_FAILURE = 82;
    static final int SSH_MSG_CHANNEL_OPEN = 90;
    static final int SSH_MSG_CHANNEL_OPEN_CONFIRMATION = 91;
    static final int SSH_MSG_CHANNEL_OPEN_FAILURE = 92;
    static final int SSH_MSG_CHANNEL_WINDOW_ADJUST = 93;
    static final int SSH_MSG_CHANNEL_DATA = 94;
    static final int SSH_MSG_CHANNEL_EXTENDED_DATA = 95;
    static final int SSH_MSG_CHANNEL_EOF = 96;
    static final int SSH_MSG_CHANNEL_CLOSE = 97;
    static final int SSH_MSG_CHANNEL_REQUEST = 98;
    static final int SSH_MSG_CHANNEL_SUCCESS = 99;
    static final int SSH_MSG_CHANNEL_FAILURE = 100;
    private byte[] V_S;
    private byte[] V_C = "SSH-2.0-JSCH-0.1.29".getBytes();
    private byte[] I_C;
    private byte[] I_S;
    private byte[] K_S;
    private byte[] session_id;
    private byte[] IVc2s;
    private byte[] IVs2c;
    private byte[] Ec2s;
    private byte[] Es2c;
    private byte[] MACc2s;
    private byte[] MACs2c;
    private int seqi = 0;
    private int seqo = 0;
    private Cipher s2ccipher;
    private Cipher c2scipher;
    private MAC s2cmac;
    private MAC c2smac;
    private byte[] s2cmac_result1;
    private byte[] s2cmac_result2;
    private Compression deflater;
    private Compression inflater;
    private IO io;
    private Socket socket;
    private int timeout = 0;
    private boolean isConnected = false;
    private boolean isAuthed = false;
    private Thread connectThread = null;
    boolean x11_forwarding = false;
    InputStream in = null;
    OutputStream out = null;
    static Random random;
    Buffer buf;
    Packet packet;
    SocketFactory socket_factory = null;
    private Hashtable config = null;
    private Proxy proxy = null;
    private UserInfo userinfo;
    private String hostKeyAlias = null;
    private int serverAliveInterval = 0;
    private int serverAliveCountMax = 1;
    String host = "127.0.0.1";
    int port = 22;
    String username = null;
    byte[] password = null;
    JSch jsch;
    private boolean in_kex = false;
    int[] uncompress_len = new int[1];
    private int s2ccipher_size = 8;
    private int c2scipher_size = 8;
    Runnable thread;
    private GlobalRequestReply grr = new GlobalRequestReply();
    private static final byte[] keepalivemsg;
    private HostKey hostkey = null;

    Session(JSch jSch) throws JSchException {
        this.jsch = jSch;
        this.buf = new Buffer();
        this.packet = new Packet(this.buf);
    }

    public void connect() throws JSchException {
        this.connect(this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(int n) throws JSchException {
        if (this.isConnected) {
            throw new JSchException("session is already connected");
        }
        this.io = new IO();
        if (random == null) {
            try {
                Class<?> clazz = Class.forName(this.getConfig("random"));
                random = (Random)clazz.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Packet.setRandom(random);
        try {
            try {
                boolean bl;
                int n2;
                Object object;
                if (this.proxy == null) {
                    this.proxy = this.jsch.getProxy(this.host);
                    if (this.proxy != null) {
                        object = this.proxy;
                        synchronized (object) {
                            this.proxy.close();
                        }
                    }
                }
                if (this.proxy == null) {
                    OutputStream outputStream;
                    if (this.socket_factory == null) {
                        this.socket = Util.createSocket(this.host, this.port, n);
                        object = this.socket.getInputStream();
                        outputStream = this.socket.getOutputStream();
                    } else {
                        this.socket = this.socket_factory.createSocket(this.host, this.port);
                        object = this.socket_factory.getInputStream(this.socket);
                        outputStream = this.socket_factory.getOutputStream(this.socket);
                    }
                    this.socket.setTcpNoDelay(true);
                    this.io.setInputStream((InputStream)object);
                    this.io.setOutputStream(outputStream);
                } else {
                    object = this.proxy;
                    synchronized (object) {
                        this.proxy.connect(this.socket_factory, this.host, this.port, n);
                        this.io.setInputStream(this.proxy.getInputStream());
                        this.io.setOutputStream(this.proxy.getOutputStream());
                        this.socket = this.proxy.getSocket();
                    }
                }
                if (n > 0 && this.socket != null) {
                    this.socket.setSoTimeout(n);
                }
                this.isConnected = true;
                do {
                    int n3 = 0;
                    for (n2 = 0; n2 < this.buf.buffer.length && (n3 = this.io.getByte()) >= 0; ++n2) {
                        this.buf.buffer[n2] = (byte)n3;
                        if (n3 != 10) continue;
                    }
                    if (n3 < 0) {
                        throw new JSchException("connection is closed by foreign host");
                    }
                    if (this.buf.buffer[n2 - 1] != 10 || this.buf.buffer[--n2 - 1] != 13) continue;
                    --n2;
                } while (n2 > 4 && n2 != this.buf.buffer.length && (this.buf.buffer[0] != 83 || this.buf.buffer[1] != 83 || this.buf.buffer[2] != 72 || this.buf.buffer[3] != 45));
                if (n2 == this.buf.buffer.length) throw new JSchException("invalid server's version string");
                if (n2 < 7) throw new JSchException("invalid server's version string");
                if (this.buf.buffer[4] == 49 && this.buf.buffer[6] != 57) {
                    throw new JSchException("invalid server's version string");
                }
                this.V_S = new byte[n2];
                System.arraycopy(this.buf.buffer, 0, this.V_S, 0, n2);
                object = new byte[this.V_C.length + 1];
                System.arraycopy(this.V_C, 0, object, 0, this.V_C.length);
                object[((Object)object).length - 1] = 10;
                this.io.put((byte[])object, 0, ((Object)object).length);
                this.buf = this.read(this.buf);
                if (this.buf.buffer[5] != 20) {
                    throw new JSchException("invalid protocol: " + this.buf.buffer[5]);
                }
                object = this.receive_kexinit(this.buf);
                do {
                    this.buf = this.read(this.buf);
                    if (((KeyExchange)object).getState() != this.buf.buffer[5]) {
                        this.in_kex = false;
                        throw new JSchException("invalid protocol(kex): " + this.buf.buffer[5]);
                    }
                    bl = ((KeyExchange)object).next(this.buf);
                    if (bl) continue;
                    this.in_kex = false;
                    throw new JSchException("verify: " + bl);
                } while (((KeyExchange)object).getState() != 0);
                try {
                    this.checkHost(this.host, (KeyExchange)object);
                }
                catch (JSchException jSchException) {
                    this.in_kex = false;
                    throw jSchException;
                }
                this.send_newkeys();
                this.buf = this.read(this.buf);
                if (this.buf.buffer[5] != 21) {
                    this.in_kex = false;
                    throw new JSchException("invalid protocol(newkyes): " + this.buf.buffer[5]);
                }
                this.receive_newkeys(this.buf, (KeyExchange)object);
                bl = false;
                boolean bl2 = false;
                UserAuthNone userAuthNone = new UserAuthNone(this.userinfo);
                bl = userAuthNone.start(this);
                String string = null;
                if (!bl) {
                    string = userAuthNone.getMethods();
                    string = string != null ? string.toLowerCase() : "publickey,password,keyboard-interactive";
                }
                while (!bl && string != null && string.length() > 0) {
                    UserAuth userAuth = null;
                    if (string.startsWith("publickey")) {
                        Vector vector = this.jsch.identities;
                        synchronized (vector) {
                            if (this.jsch.identities.size() > 0) {
                                userAuth = new UserAuthPublicKey(this.userinfo);
                            }
                        }
                    } else if (string.startsWith("keyboard-interactive")) {
                        if (this.userinfo instanceof UIKeyboardInteractive) {
                            userAuth = new UserAuthKeyboardInteractive(this.userinfo);
                        }
                    } else if (string.startsWith("password")) {
                        userAuth = new UserAuthPassword(this.userinfo);
                    }
                    if (userAuth != null) {
                        try {
                            bl = ((UserAuth)userAuth).start(this);
                            bl2 = false;
                        }
                        catch (JSchAuthCancelException jSchAuthCancelException) {
                            bl2 = true;
                        }
                        catch (JSchPartialAuthException jSchPartialAuthException) {
                            string = jSchPartialAuthException.getMethods();
                            bl2 = false;
                            continue;
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (bl) continue;
                    int n4 = string.indexOf(",");
                    if (n4 == -1) break;
                    string = string.substring(n4 + 1);
                }
                if (n > 0 || this.timeout > 0) {
                    this.socket.setSoTimeout(this.timeout);
                }
                if (!bl) {
                    if (!bl2) throw new JSchException("Auth fail");
                    throw new JSchException("Auth cancel");
                }
                this.isAuthed = true;
                this.connectThread = new Thread(this);
                this.connectThread.setName("Connect thread " + this.host + " session");
                this.connectThread.start();
                Object var15_22 = null;
            }
            catch (Exception exception) {
                this.in_kex = false;
                if (this.isConnected) {
                    try {
                        this.packet.reset();
                        this.buf.putByte((byte)1);
                        this.buf.putInt(3);
                        this.buf.putString(exception.toString().getBytes());
                        this.buf.putString("en".getBytes());
                        this.write(this.packet);
                        this.disconnect();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                this.isConnected = false;
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (!(exception instanceof JSchException)) throw new JSchException("Session.connect: " + exception);
                throw (JSchException)exception;
            }
        }
        catch (Throwable throwable) {
            Object var15_23 = null;
            Util.bzero(this.password);
            this.password = null;
            throw throwable;
        }
        Util.bzero(this.password);
        this.password = null;
    }

    private KeyExchange receive_kexinit(Buffer buffer) throws Exception {
        int n = buffer.getInt();
        if (n != buffer.getLength()) {
            buffer.getByte();
            this.I_S = new byte[buffer.index - 5];
        } else {
            this.I_S = new byte[n - 1 - buffer.getByte()];
        }
        System.arraycopy(buffer.buffer, buffer.s, this.I_S, 0, this.I_S.length);
        this.send_kexinit();
        String[] stringArray = KeyExchange.guess(this.I_S, this.I_C);
        if (stringArray == null) {
            throw new JSchException("Algorithm negotiation fail");
        }
        if (!this.isAuthed && (stringArray[2].equals("none") || stringArray[3].equals("none"))) {
            throw new JSchException("NONE Cipher should not be chosen before authentification is successed.");
        }
        KeyExchange keyExchange = null;
        try {
            Class<?> clazz = Class.forName(this.getConfig(stringArray[0]));
            keyExchange = (KeyExchange)clazz.newInstance();
        }
        catch (Exception exception) {
            System.err.println("kex: " + exception);
        }
        keyExchange.guess = stringArray;
        keyExchange.init(this, this.V_S, this.V_C, this.I_S, this.I_C);
        return keyExchange;
    }

    public void rekey() throws Exception {
        this.send_kexinit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send_kexinit() throws Exception {
        if (this.in_kex) {
            return;
        }
        this.in_kex = true;
        this.packet.reset();
        this.buf.putByte((byte)20);
        Random random = Session.random;
        synchronized (random) {
            Session.random.fill(this.buf.buffer, this.buf.index, 16);
            this.buf.skip(16);
        }
        this.buf.putString(this.getConfig("kex").getBytes());
        this.buf.putString(this.getConfig("server_host_key").getBytes());
        this.buf.putString(this.getConfig("cipher.c2s").getBytes());
        this.buf.putString(this.getConfig("cipher.s2c").getBytes());
        this.buf.putString(this.getConfig("mac.c2s").getBytes());
        this.buf.putString(this.getConfig("mac.s2c").getBytes());
        this.buf.putString(this.getConfig("compression.c2s").getBytes());
        this.buf.putString(this.getConfig("compression.s2c").getBytes());
        this.buf.putString(this.getConfig("lang.c2s").getBytes());
        this.buf.putString(this.getConfig("lang.s2c").getBytes());
        this.buf.putByte((byte)0);
        this.buf.putInt(0);
        this.buf.setOffSet(5);
        this.I_C = new byte[this.buf.getLength()];
        this.buf.getByte(this.I_C);
        this.write(this.packet);
    }

    private void send_newkeys() throws Exception {
        this.packet.reset();
        this.buf.putByte((byte)21);
        this.write(this.packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHost(String string, KeyExchange keyExchange) throws JSchException {
        String string2 = this.getConfig("StrictHostKeyChecking");
        if (this.hostKeyAlias != null) {
            string = this.hostKeyAlias;
        }
        byte[] byArray = keyExchange.getHostKey();
        String string3 = keyExchange.getKeyType();
        String string4 = keyExchange.getFingerPrint();
        this.hostkey = new HostKey(string, byArray);
        HostKeyRepository hostKeyRepository = this.jsch.getHostKeyRepository();
        int n = 0;
        HostKeyRepository hostKeyRepository2 = hostKeyRepository;
        synchronized (hostKeyRepository2) {
            n = hostKeyRepository.check(string, byArray);
        }
        boolean bl = false;
        if ((string2.equals("ask") || string2.equals("yes")) && n == 2) {
            Object object;
            String string5 = null;
            HostKeyRepository hostKeyRepository3 = hostKeyRepository;
            synchronized (hostKeyRepository3) {
                string5 = hostKeyRepository.getKnownHostsRepositoryID();
            }
            if (string5 == null) {
                string5 = "known_hosts";
            }
            boolean bl2 = false;
            if (this.userinfo != null) {
                object = "WARNING: REMOTE HOST IDENTIFICATION HAS CHANGED!\nIT IS POSSIBLE THAT SOMEONE IS DOING SOMETHING NASTY!\nSomeone could be eavesdropping on you right now (man-in-the-middle attack)!\nIt is also possible that the " + string3 + " host key has just been changed.\n" + "The fingerprint for the " + string3 + " key sent by the remote host is\n" + string4 + ".\n" + "Please contact your system administrator.\n" + "Add correct host key in " + string5 + " to get rid of this message.";
                if (string2.equals("ask")) {
                    bl2 = this.userinfo.promptYesNo((String)object + "\nDo you want to delete the old key and insert the new key?");
                } else {
                    this.userinfo.showMessage((String)object);
                }
            }
            if (!bl2) {
                throw new JSchException("HostKey has been changed: " + string);
            }
            object = hostKeyRepository;
            synchronized (object) {
                hostKeyRepository.remove(string, string3.equals("DSA") ? "ssh-dss" : "ssh-rsa", null);
                bl = true;
            }
        }
        if ((string2.equals("ask") || string2.equals("yes")) && n != 0 && !bl) {
            if (string2.equals("yes")) {
                throw new JSchException("reject HostKey: " + string);
            }
            if (this.userinfo != null) {
                boolean bl3 = this.userinfo.promptYesNo("The authenticity of host '" + string + "' can't be established.\n" + string3 + " key fingerprint is " + string4 + ".\n" + "Are you sure you want to continue connecting?");
                if (!bl3) {
                    throw new JSchException("reject HostKey: " + string);
                }
                bl = true;
            } else {
                if (n == 1) {
                    throw new JSchException("UnknownHostKey: " + string + ". " + string3 + " key fingerprint is " + string4);
                }
                throw new JSchException("HostKey has been changed: " + string);
            }
        }
        if (string2.equals("no") && 1 == n) {
            bl = true;
        }
        if (bl) {
            HostKeyRepository hostKeyRepository4 = hostKeyRepository;
            synchronized (hostKeyRepository4) {
                hostKeyRepository.add(string, byArray, this.userinfo);
            }
        }
    }

    public Channel openChannel(String string) throws JSchException {
        if (!this.isConnected) {
            throw new JSchException("session is down");
        }
        try {
            Channel channel = Channel.getChannel(string);
            this.addChannel(channel);
            channel.init();
            return channel;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(Packet packet) throws Exception {
        if (this.deflater != null) {
            packet.buffer.index = this.deflater.compress(packet.buffer.buffer, 5, packet.buffer.index);
        }
        if (this.c2scipher != null) {
            packet.padding(this.c2scipher_size);
            byte by = packet.buffer.buffer[4];
            Random random = Session.random;
            synchronized (random) {
                Session.random.fill(packet.buffer.buffer, packet.buffer.index - by, by);
            }
        } else {
            packet.padding(8);
        }
        if (this.c2smac != null) {
            this.c2smac.update(this.seqo);
            this.c2smac.update(packet.buffer.buffer, 0, packet.buffer.index);
            this.c2smac.doFinal(packet.buffer.buffer, packet.buffer.index);
        }
        if (this.c2scipher != null) {
            byte[] byArray = packet.buffer.buffer;
            this.c2scipher.update(byArray, 0, packet.buffer.index, byArray, 0);
        }
        if (this.c2smac != null) {
            packet.buffer.skip(this.c2smac.getBlockSize());
        }
    }

    public Buffer read(Buffer buffer) throws Exception {
        int n = 0;
        while (true) {
            Object object;
            int n2;
            buffer.reset();
            this.io.getByte(buffer.buffer, buffer.index, this.s2ccipher_size);
            buffer.index += this.s2ccipher_size;
            if (this.s2ccipher != null) {
                this.s2ccipher.update(buffer.buffer, 0, this.s2ccipher_size, buffer.buffer, 0);
            }
            n = buffer.buffer[0] << 24 & 0xFF000000 | buffer.buffer[1] << 16 & 0xFF0000 | buffer.buffer[2] << 8 & 0xFF00 | buffer.buffer[3] & 0xFF;
            if ((n = n - 4 - this.s2ccipher_size + 8) < 0 || buffer.index + n > buffer.buffer.length) {
                throw new IOException("invalid data");
            }
            if (n > 0) {
                this.io.getByte(buffer.buffer, buffer.index, n);
                buffer.index += n;
                if (this.s2ccipher != null) {
                    this.s2ccipher.update(buffer.buffer, this.s2ccipher_size, n, buffer.buffer, this.s2ccipher_size);
                }
            }
            if (this.s2cmac != null) {
                this.s2cmac.update(this.seqi);
                this.s2cmac.update(buffer.buffer, 0, buffer.index);
                this.s2cmac.doFinal(this.s2cmac_result1, 0);
                this.io.getByte(this.s2cmac_result2, 0, this.s2cmac_result2.length);
                if (!Arrays.equals(this.s2cmac_result1, this.s2cmac_result2)) {
                    throw new IOException("MAC Error");
                }
            }
            ++this.seqi;
            if (this.inflater != null) {
                n2 = buffer.buffer[4];
                this.uncompress_len[0] = buffer.index - 5 - n2;
                object = this.inflater.uncompress(buffer.buffer, 5, this.uncompress_len);
                if (object != null) {
                    buffer.buffer = object;
                    buffer.index = 5 + this.uncompress_len[0];
                } else {
                    System.err.println("fail in inflater");
                    break;
                }
            }
            if ((n2 = buffer.buffer[5] & 0xFF) == 1) {
                buffer.rewind();
                buffer.getInt();
                buffer.getShort();
                int n3 = buffer.getInt();
                byte[] byArray = buffer.getString();
                byte[] byArray2 = buffer.getString();
                throw new JSchException("SSH_MSG_DISCONNECT: " + n3 + " " + new String(byArray) + " " + new String(byArray2));
            }
            if (n2 == 2) continue;
            if (n2 == 4) {
                buffer.rewind();
                buffer.getInt();
                buffer.getShort();
                continue;
            }
            if (n2 != 93) break;
            buffer.rewind();
            buffer.getInt();
            buffer.getShort();
            object = Channel.getChannel(buffer.getInt(), this);
            if (object == null) continue;
            object.addRemoteWindowSize(buffer.getInt());
        }
        buffer.rewind();
        return buffer;
    }

    byte[] getSessionId() {
        return this.session_id;
    }

    private void receive_newkeys(Buffer buffer, KeyExchange keyExchange) throws Exception {
        this.updateKeys(keyExchange);
        this.in_kex = false;
    }

    private void updateKeys(KeyExchange keyExchange) throws Exception {
        int n;
        byte[] byArray = keyExchange.getK();
        byte[] byArray2 = keyExchange.getH();
        HASH hASH = keyExchange.getHash();
        String[] stringArray = keyExchange.guess;
        if (this.session_id == null) {
            this.session_id = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.session_id, 0, byArray2.length);
        }
        this.buf.reset();
        this.buf.putMPInt(byArray);
        this.buf.putByte(byArray2);
        this.buf.putByte((byte)65);
        this.buf.putByte(this.session_id);
        hASH.update(this.buf.buffer, 0, this.buf.index);
        this.IVc2s = hASH.digest();
        int n2 = n = this.buf.index - this.session_id.length - 1;
        this.buf.buffer[n2] = (byte)(this.buf.buffer[n2] + 1);
        hASH.update(this.buf.buffer, 0, this.buf.index);
        this.IVs2c = hASH.digest();
        int n3 = n;
        this.buf.buffer[n3] = (byte)(this.buf.buffer[n3] + 1);
        hASH.update(this.buf.buffer, 0, this.buf.index);
        this.Ec2s = hASH.digest();
        int n4 = n;
        this.buf.buffer[n4] = (byte)(this.buf.buffer[n4] + 1);
        hASH.update(this.buf.buffer, 0, this.buf.index);
        this.Es2c = hASH.digest();
        int n5 = n;
        this.buf.buffer[n5] = (byte)(this.buf.buffer[n5] + 1);
        hASH.update(this.buf.buffer, 0, this.buf.index);
        this.MACc2s = hASH.digest();
        int n6 = n;
        this.buf.buffer[n6] = (byte)(this.buf.buffer[n6] + 1);
        hASH.update(this.buf.buffer, 0, this.buf.index);
        this.MACs2c = hASH.digest();
        try {
            byte[] byArray3;
            Object object;
            Class<?> clazz = Class.forName(this.getConfig(stringArray[3]));
            this.s2ccipher = (Cipher)clazz.newInstance();
            while (this.s2ccipher.getBlockSize() > this.Es2c.length) {
                this.buf.reset();
                this.buf.putMPInt(byArray);
                this.buf.putByte(byArray2);
                this.buf.putByte(this.Es2c);
                hASH.update(this.buf.buffer, 0, this.buf.index);
                object = hASH.digest();
                byArray3 = new byte[this.Es2c.length + ((byte[])object).length];
                System.arraycopy(this.Es2c, 0, byArray3, 0, this.Es2c.length);
                System.arraycopy(object, 0, byArray3, this.Es2c.length, ((byte[])object).length);
                this.Es2c = byArray3;
            }
            this.s2ccipher.init(1, this.Es2c, this.IVs2c);
            this.s2ccipher_size = this.s2ccipher.getIVSize();
            clazz = Class.forName(this.getConfig(stringArray[5]));
            this.s2cmac = (MAC)clazz.newInstance();
            this.s2cmac.init(this.MACs2c);
            this.s2cmac_result1 = new byte[this.s2cmac.getBlockSize()];
            this.s2cmac_result2 = new byte[this.s2cmac.getBlockSize()];
            clazz = Class.forName(this.getConfig(stringArray[2]));
            this.c2scipher = (Cipher)clazz.newInstance();
            while (this.c2scipher.getBlockSize() > this.Ec2s.length) {
                this.buf.reset();
                this.buf.putMPInt(byArray);
                this.buf.putByte(byArray2);
                this.buf.putByte(this.Ec2s);
                hASH.update(this.buf.buffer, 0, this.buf.index);
                object = hASH.digest();
                byArray3 = new byte[this.Ec2s.length + ((byte[])object).length];
                System.arraycopy(this.Ec2s, 0, byArray3, 0, this.Ec2s.length);
                System.arraycopy(object, 0, byArray3, this.Ec2s.length, ((byte[])object).length);
                this.Ec2s = byArray3;
            }
            this.c2scipher.init(0, this.Ec2s, this.IVc2s);
            this.c2scipher_size = this.s2ccipher.getIVSize();
            clazz = Class.forName(this.getConfig(stringArray[4]));
            this.c2smac = (MAC)clazz.newInstance();
            this.c2smac.init(this.MACc2s);
            if (!stringArray[6].equals("none")) {
                object = this.getConfig(stringArray[6]);
                if (object != null) {
                    try {
                        clazz = Class.forName((String)object);
                        this.deflater = (Compression)clazz.newInstance();
                        int n7 = 6;
                        try {
                            n7 = Integer.parseInt(this.getConfig("compression_level"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.deflater.init(1, n7);
                    }
                    catch (Exception exception) {
                        System.err.println((String)object + " isn't accessible.");
                    }
                }
            } else if (this.deflater != null) {
                this.deflater = null;
            }
            if (!stringArray[7].equals("none")) {
                object = this.getConfig(stringArray[7]);
                if (object != null) {
                    try {
                        clazz = Class.forName((String)object);
                        this.inflater = (Compression)clazz.newInstance();
                        this.inflater.init(0, 0);
                    }
                    catch (Exception exception) {
                        System.err.println((String)object + " isn't accessible.");
                    }
                }
            } else if (this.inflater != null) {
                this.inflater = null;
            }
        }
        catch (Exception exception) {
            System.err.println("updatekeys: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(Packet packet, Channel channel, int n) throws Exception {
        while (true) {
            if (this.in_kex) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            Channel channel2 = channel;
            synchronized (channel2) {
                if (channel.rwsize >= n) {
                    channel.rwsize -= n;
                    break;
                }
            }
            if (channel.close || !channel.isConnected()) {
                throw new IOException("channel is broken");
            }
            boolean bl = false;
            int n2 = 0;
            byte by = 0;
            int n3 = -1;
            Channel channel3 = channel;
            synchronized (channel3) {
                if (channel.rwsize > 0) {
                    int n4 = channel.rwsize;
                    if (n4 > n) {
                        n4 = n;
                    }
                    if (n4 != n) {
                        n2 = packet.shift(n4, this.c2smac != null ? this.c2smac.getBlockSize() : 0);
                    }
                    by = packet.buffer.buffer[5];
                    n3 = channel.getRecipient();
                    n -= n4;
                    channel.rwsize -= n4;
                    bl = true;
                }
            }
            if (bl) {
                this._write(packet);
                if (n == 0) {
                    return;
                }
                packet.unshift(by, n3, n2, n);
                Channel channel4 = channel;
                synchronized (channel4) {
                    if (channel.rwsize >= n) {
                        channel.rwsize -= n;
                        break;
                    }
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this._write(packet);
    }

    public void write(Packet packet) throws Exception {
        while (this.in_kex) {
            byte by = packet.buffer.buffer[5];
            if (by == 20 || by == 21 || by == 30 || by == 31 || by == 1) break;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._write(packet);
    }

    private synchronized void _write(Packet packet) throws Exception {
        this.encode(packet);
        if (this.io != null) {
            this.io.put(packet);
            ++this.seqo;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.thread = this;
        var2_1 = new Buffer();
        var3_2 = new Packet(var2_1);
        var4_3 = 0;
        var6_4 = new int[1];
        var7_5 = new int[1];
        var8_6 = null;
        var9_7 = 0;
        try lbl-1000:
        // 33 sources

        {
            block28: while (this.isConnected && this.thread != null) {
                try {
                    var2_1 = this.read(var2_1);
                    var9_7 = 0;
                }
                catch (InterruptedIOException var10_10) {
                    if (!this.in_kex && var9_7 < this.serverAliveCountMax) {
                        this.sendKeepAliveMsg();
                        ++var9_7;
                        continue;
                    }
                    throw var10_10;
                }
                var10_11 = var2_1.buffer[5] & 255;
                if (var8_6 != null && var8_6.getState() == var10_11) {
                    var11_14 = var8_6.next(var2_1);
                    if (var11_14 != 0) continue;
                    throw new JSchException("verify: " + (boolean)var11_14);
                }
                switch (var10_11) {
                    case 20: {
                        var8_6 = this.receive_kexinit(var2_1);
                        ** break;
                    }
                    case 21: {
                        this.send_newkeys();
                        this.receive_newkeys(var2_1, var8_6);
                        var8_6 = null;
                        ** break;
                    }
                    case 94: {
                        var2_1.getInt();
                        var2_1.getByte();
                        var2_1.getByte();
                        var4_3 = var2_1.getInt();
                        var5_9 = Channel.getChannel(var4_3, this);
                        var1_8 = var2_1.getString(var6_4, var7_5);
                        if (var5_9 == null) continue block28;
                        try {
                            var5_9.write(var1_8, var6_4[0], var7_5[0]);
                        }
                        catch (Exception var11_15) {
                            try {
                                var5_9.disconnect();
                            }
                            catch (Exception var12_17) {}
                            continue block28;
                        }
                        var11_14 = var7_5[0];
                        var5_9.setLocalWindowSize(var5_9.lwsize - var11_14);
                        if (var5_9.lwsize >= var5_9.lwsize_max / 2) continue block28;
                        var3_2.reset();
                        var2_1.putByte((byte)93);
                        var2_1.putInt(var5_9.getRecipient());
                        var2_1.putInt(var5_9.lwsize_max - var5_9.lwsize);
                        this.write(var3_2);
                        var5_9.setLocalWindowSize(var5_9.lwsize_max);
                        ** break;
                    }
                    case 95: {
                        var2_1.getInt();
                        var2_1.getShort();
                        var4_3 = var2_1.getInt();
                        var5_9 = Channel.getChannel(var4_3, this);
                        var2_1.getInt();
                        var1_8 = var2_1.getString(var6_4, var7_5);
                        if (var5_9 == null) continue block28;
                        var5_9.write_ext(var1_8, var6_4[0], var7_5[0]);
                        var11_14 = var7_5[0];
                        var5_9.setLocalWindowSize(var5_9.lwsize - var11_14);
                        if (var5_9.lwsize >= var5_9.lwsize_max / 2) continue block28;
                        var3_2.reset();
                        var2_1.putByte((byte)93);
                        var2_1.putInt(var5_9.getRecipient());
                        var2_1.putInt(var5_9.lwsize_max - var5_9.lwsize);
                        this.write(var3_2);
                        var5_9.setLocalWindowSize(var5_9.lwsize_max);
                        ** break;
                    }
                    case 93: {
                        var2_1.getInt();
                        var2_1.getShort();
                        var4_3 = var2_1.getInt();
                        var5_9 = Channel.getChannel(var4_3, this);
                        if (var5_9 == null) continue block28;
                        var5_9.addRemoteWindowSize(var2_1.getInt());
                        ** break;
                    }
                    case 96: {
                        var2_1.getInt();
                        var2_1.getShort();
                        var4_3 = var2_1.getInt();
                        var5_9 = Channel.getChannel(var4_3, this);
                        if (var5_9 == null) continue block28;
                        var5_9.eof_remote();
                        ** break;
                    }
                    case 97: {
                        var2_1.getInt();
                        var2_1.getShort();
                        var4_3 = var2_1.getInt();
                        var5_9 = Channel.getChannel(var4_3, this);
                        if (var5_9 == null) continue block28;
                        var5_9.disconnect();
                        ** break;
                    }
                    case 91: {
                        var2_1.getInt();
                        var2_1.getShort();
                        var4_3 = var2_1.getInt();
                        var5_9 = Channel.getChannel(var4_3, this);
                        if (var5_9 == null) {
                            // empty if block
                        }
                        var5_9.setRecipient(var2_1.getInt());
                        var5_9.setRemoteWindowSize(var2_1.getInt());
                        var5_9.setRemotePacketSize(var2_1.getInt());
                        ** break;
                    }
                    case 92: {
                        var2_1.getInt();
                        var2_1.getShort();
                        var4_3 = var2_1.getInt();
                        var5_9 = Channel.getChannel(var4_3, this);
                        if (var5_9 == null) {
                            // empty if block
                        }
                        var5_9.exitstatus = var12_18 = var2_1.getInt();
                        var5_9.close = true;
                        var5_9.eof_remote = true;
                        var5_9.setRecipient(0);
                        ** break;
                    }
                    case 98: {
                        var2_1.getInt();
                        var2_1.getShort();
                        var4_3 = var2_1.getInt();
                        var1_8 = var2_1.getString();
                        v0 = var13_19 = var2_1.getByte() != 0;
                        var5_9 = Channel.getChannel(var4_3, this);
                        if (var5_9 == null) continue block28;
                        var14_20 = 100;
                        if (new String(var1_8).equals("exit-status")) {
                            var4_3 = var2_1.getInt();
                            var5_9.setExitStatus(var4_3);
                            var14_20 = 99;
                        }
                        if (!var13_19) continue block28;
                        var3_2.reset();
                        var2_1.putByte((byte)var14_20);
                        var2_1.putInt(var5_9.getRecipient());
                        this.write(var3_2);
                        ** break;
                    }
                    case 90: {
                        var2_1.getInt();
                        var2_1.getShort();
                        var1_8 = var2_1.getString();
                        var14_21 = new String(var1_8);
                        if (!("forwarded-tcpip".equals(var14_21) || "x11".equals(var14_21) && this.x11_forwarding)) {
                            System.err.println("Session.run: CHANNEL OPEN " + var14_21);
                            throw new IOException("Session.run: CHANNEL OPEN " + var14_21);
                        }
                        var5_9 = Channel.getChannel(var14_21);
                        this.addChannel(var5_9);
                        var5_9.getData(var2_1);
                        var5_9.init();
                        var3_2.reset();
                        var2_1.putByte((byte)91);
                        var2_1.putInt(var5_9.getRecipient());
                        var2_1.putInt(var5_9.id);
                        var2_1.putInt(var5_9.lwsize);
                        var2_1.putInt(var5_9.lmpsize);
                        this.write(var3_2);
                        var15_22 = new Thread(var5_9);
                        var15_22.setName("Channel " + var14_21 + " " + this.host);
                        var15_22.start();
                        ** break;
                    }
                    case 99: {
                        var2_1.getInt();
                        var2_1.getShort();
                        var4_3 = var2_1.getInt();
                        var5_9 = Channel.getChannel(var4_3, this);
                        if (var5_9 == null) continue block28;
                        var5_9.reply = 1;
                        ** break;
                    }
                    case 100: {
                        var2_1.getInt();
                        var2_1.getShort();
                        var4_3 = var2_1.getInt();
                        var5_9 = Channel.getChannel(var4_3, this);
                        if (var5_9 == null) continue block28;
                        var5_9.reply = 0;
                        ** break;
                    }
                    case 80: {
                        var2_1.getInt();
                        var2_1.getShort();
                        var1_8 = var2_1.getString();
                        var13_19 = var2_1.getByte() != 0;
                        if (!var13_19) continue block28;
                        var3_2.reset();
                        var2_1.putByte((byte)82);
                        this.write(var3_2);
                        ** break;
                    }
                    case 81: 
                    case 82: {
                        var15_22 = this.grr.getThread();
                        if (var15_22 == null) continue block28;
                        this.grr.setReply(var10_11 == 81 ? 1 : 0);
                        var15_22.interrupt();
                        ** break;
                    }
                }
                throw new IOException("Unknown SSH message type " + var10_11);
            }
        }
        catch (Exception var10_12) {
            // empty catch block
        }
        try {
            this.disconnect();
        }
        catch (NullPointerException var10_13) {
        }
        catch (Exception var11_16) {
            // empty catch block
        }
        this.isConnected = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        block15: {
            if (!this.isConnected) {
                return;
            }
            Channel.disconnect(this);
            this.isConnected = false;
            PortWatcher.delPort(this);
            ChannelForwardedTCPIP.delPort(this);
            Thread thread = this.connectThread;
            synchronized (thread) {
                Thread.yield();
                this.connectThread.interrupt();
                this.connectThread = null;
            }
            this.thread = null;
            try {
                if (this.io != null) {
                    if (this.io.in != null) {
                        this.io.in.close();
                    }
                    if (this.io.out != null) {
                        this.io.out.close();
                    }
                    if (this.io.out_ext != null) {
                        this.io.out_ext.close();
                    }
                }
                if (this.proxy == null) {
                    if (this.socket != null) {
                        this.socket.close();
                    }
                    break block15;
                }
                Proxy proxy = this.proxy;
                synchronized (proxy) {
                    this.proxy.close();
                }
                this.proxy = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.io = null;
        this.socket = null;
        this.jsch.removeSession(this);
    }

    public void setPortForwardingL(int n, String string, int n2) throws JSchException {
        this.setPortForwardingL("127.0.0.1", n, string, n2);
    }

    public void setPortForwardingL(String string, int n, String string2, int n2) throws JSchException {
        this.setPortForwardingL(string, n, string2, n2, null);
    }

    public void setPortForwardingL(String string, int n, String string2, int n2, ServerSocketFactory serverSocketFactory) throws JSchException {
        PortWatcher portWatcher = PortWatcher.addPort(this, string, n, string2, n2, serverSocketFactory);
        Thread thread = new Thread(portWatcher);
        thread.setName("PortWatcher Thread for " + string2);
        thread.start();
    }

    public void delPortForwardingL(int n) throws JSchException {
        this.delPortForwardingL("127.0.0.1", n);
    }

    public void delPortForwardingL(String string, int n) throws JSchException {
        PortWatcher.delPort(this, string, n);
    }

    public String[] getPortForwardingL() throws JSchException {
        return PortWatcher.getPortForwarding(this);
    }

    public void setPortForwardingR(int n, String string, int n2) throws JSchException {
        this.setPortForwardingR(n, string, n2, null);
    }

    public void setPortForwardingR(int n, String string, int n2, SocketFactory socketFactory) throws JSchException {
        ChannelForwardedTCPIP.addPort(this, n, string, n2, socketFactory);
        this.setPortForwarding(n);
    }

    public void setPortForwardingR(int n, String string) throws JSchException {
        this.setPortForwardingR(n, string, null);
    }

    public void setPortForwardingR(int n, String string, Object[] objectArray) throws JSchException {
        ChannelForwardedTCPIP.addPort(this, n, string, objectArray);
        this.setPortForwarding(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPortForwarding(int n) throws JSchException {
        GlobalRequestReply globalRequestReply = this.grr;
        synchronized (globalRequestReply) {
            Buffer buffer = new Buffer(100);
            Packet packet = new Packet(buffer);
            try {
                packet.reset();
                buffer.putByte((byte)80);
                buffer.putString("tcpip-forward".getBytes());
                buffer.putByte((byte)1);
                buffer.putString("0.0.0.0".getBytes());
                buffer.putInt(n);
                this.write(packet);
            }
            catch (Exception exception) {
                if (exception instanceof Throwable) {
                    throw new JSchException(exception.toString(), exception);
                }
                throw new JSchException(exception.toString());
            }
            this.grr.setThread(Thread.currentThread());
            try {
                Thread.sleep(10000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n2 = this.grr.getReply();
            this.grr.setThread(null);
            if (n2 == 0) {
                throw new JSchException("remote port forwarding failed for listen port " + n);
            }
        }
    }

    public void delPortForwardingR(int n) throws JSchException {
        ChannelForwardedTCPIP.delPort(this, n);
    }

    void addChannel(Channel channel) {
        channel.session = this;
    }

    public String getConfig(String string) {
        String string2 = null;
        if (this.config != null && (string2 = (String)this.config.get(string)) instanceof String) {
            return string2;
        }
        string2 = this.jsch.getConfig(string);
        if (string2 instanceof String) {
            return string2;
        }
        return null;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    void setUserName(String string) {
        this.username = string;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userinfo = userInfo;
    }

    public void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void setX11Host(String string) {
        ChannelX11.setHost(string);
    }

    public void setX11Port(int n) {
        ChannelX11.setPort(n);
    }

    public void setX11Cookie(String string) {
        ChannelX11.setCookie(string);
    }

    public void setPassword(String string) {
        if (string != null) {
            this.password = Util.str2byte(string);
        }
    }

    public void setPassword(byte[] byArray) {
        if (byArray != null) {
            this.password = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.password, 0, byArray.length);
        }
    }

    public void setConfig(Properties properties) {
        this.setConfig((Hashtable)properties);
    }

    public void setConfig(Hashtable hashtable) {
        if (this.config == null) {
            this.config = new Hashtable();
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.config.put(string, (String)hashtable.get(string));
        }
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socket_factory = socketFactory;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n) throws JSchException {
        if (this.socket == null) {
            if (n < 0) {
                throw new JSchException("invalid timeout value");
            }
            this.timeout = n;
            return;
        }
        try {
            this.socket.setSoTimeout(n);
            this.timeout = n;
        }
        catch (Exception exception) {
            if (exception instanceof Throwable) {
                throw new JSchException(exception.toString(), exception);
            }
            throw new JSchException(exception.toString());
        }
    }

    public String getServerVersion() {
        return new String(this.V_S);
    }

    public String getClientVersion() {
        return new String(this.V_C);
    }

    public void setClientVersion(String string) {
        this.V_C = string.getBytes();
    }

    public void sendIgnore() throws Exception {
        Buffer buffer = new Buffer();
        Packet packet = new Packet(buffer);
        packet.reset();
        buffer.putByte((byte)2);
        this.write(packet);
    }

    public void sendKeepAliveMsg() throws Exception {
        Buffer buffer = new Buffer();
        Packet packet = new Packet(buffer);
        packet.reset();
        buffer.putByte((byte)80);
        buffer.putString(keepalivemsg);
        buffer.putByte((byte)1);
        this.write(packet);
    }

    public HostKey getHostKey() {
        return this.hostkey;
    }

    public String getHost() {
        return this.host;
    }

    public String getUserName() {
        return this.username;
    }

    public int getPort() {
        return this.port;
    }

    public void setHostKeyAlias(String string) {
        this.hostKeyAlias = string;
    }

    public String getHostKeyAlias() {
        return this.hostKeyAlias;
    }

    public void setServerAliveInterval(int n) throws JSchException {
        this.setTimeout(n);
        this.serverAliveInterval = n;
    }

    public void setServerAliveCountMax(int n) {
        this.serverAliveCountMax = n;
    }

    static {
        keepalivemsg = "keepalive@jcraft.com".getBytes();
    }

    private class GlobalRequestReply {
        private Thread thread = null;
        private int reply = -1;

        private GlobalRequestReply() {
        }

        void setThread(Thread thread) {
            this.thread = thread;
            this.reply = -1;
        }

        Thread getThread() {
            return this.thread;
        }

        void setReply(int n) {
            this.reply = n;
        }

        int getReply() {
            return this.reply;
        }
    }
}

