/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import mazz.i18n.Logger;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.db.DbUtilsI18NFactory;
import org.rhq.core.db.TypeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseType {
    private static final Logger LOG = DbUtilsI18NFactory.getLogger(DatabaseType.class);

    public abstract String getName();

    public abstract String getVendor();

    public abstract String getVersion();

    public abstract String getHibernateDialect();

    public String toString() {
        return this.getName() + "(" + this.getVendor() + ":" + this.getVersion() + ")";
    }

    public boolean matches(String vendor, String version) {
        if (vendor != null && !vendor.equalsIgnoreCase(this.getVendor())) {
            return false;
        }
        return version == null || version.equalsIgnoreCase(this.getVersion());
    }

    public String getDBTypeFromGenericType(String generic_type) {
        return TypeMap.getMappedType(TypeMap.loadKnownTypeMaps(), generic_type, this);
    }

    public void closeConnection(Connection c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Exception e) {
            LOG.warn((Throwable)e, "DatabaseType.close-conn-error", new Object[]{e});
        }
    }

    public void closeStatement(Statement s) {
        if (s == null) {
            return;
        }
        try {
            s.close();
        }
        catch (Exception e) {
            LOG.warn((Throwable)e, "DatabaseType.close-statement-error", new Object[]{e});
        }
    }

    public void closeResultSet(ResultSet rs) {
        if (rs == null) {
            return;
        }
        try {
            rs.close();
        }
        catch (Exception e) {
            LOG.warn((Throwable)e, "DatabaseType.close-resultset-error", new Object[]{e});
        }
    }

    public void closeJDBCObjects(Connection c, Statement s, ResultSet rs) {
        this.closeResultSet(rs);
        this.closeStatement(s);
        this.closeConnection(c);
    }

    public int countRows(int num_rows_already_read, ResultSet result_set) throws SQLException {
        int row_count = num_rows_already_read;
        int rs_type = result_set.getType();
        switch (rs_type) {
            case 1003: {
                while (result_set.next()) {
                    ++row_count;
                }
                return row_count;
            }
        }
        if (result_set.last()) {
            return result_set.getRow();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkColumnExists(Connection conn, String table, String column) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        String checkColumnSql = "SELECT * FROM " + table + " WHERE 1=0";
        try {
            ps = conn.prepareStatement(checkColumnSql);
            rs = ps.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int numCols = rsmd.getColumnCount();
            for (int i = 0; i < numCols; ++i) {
                if (!rsmd.getColumnName(i + 1).equalsIgnoreCase(column)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeJDBCObjects(null, ps, rs);
        }
    }

    public String getBooleanValue(boolean bool) {
        return bool ? "true" : "false";
    }

    public void setBooleanValue(boolean bool, PreparedStatement ps, int idx) throws SQLException {
        ps.setBoolean(idx, bool);
    }

    public boolean checkTableExists(Connection conn, String table) throws Exception {
        boolean bl;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement("SELECT COUNT(*) FROM " + table);
            rs = ps.executeQuery();
            bl = true;
        }
        catch (SQLException e) {
            block5: {
                boolean bl2;
                try {
                    if (!this.isTableNotFoundException(e)) break block5;
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    DatabaseType db = DatabaseTypeFactory.getDatabaseType(conn);
                    db.closeJDBCObjects(null, ps, rs);
                    throw throwable;
                }
                DatabaseType db = DatabaseTypeFactory.getDatabaseType(conn);
                db.closeJDBCObjects(null, ps, rs);
                return bl2;
            }
            throw e;
        }
        DatabaseType db = DatabaseTypeFactory.getDatabaseType(conn);
        db.closeJDBCObjects(null, ps, rs);
        return bl;
    }

    public void updateColumn(Connection conn, String table, String column, String modify_cmd) throws SQLException {
        String sql = "ALTER TABLE " + table + " MODIFY (" + column + " " + modify_cmd + ")";
        this.executeSql(conn, sql);
    }

    public void dropTable(Connection conn, String table) throws SQLException {
        String sql = "DROP TABLE " + table;
        this.executeSql(conn, sql);
    }

    public void deleteColumn(Connection conn, String table, String column) throws SQLException {
        String sql = "ALTER TABLE " + table + " DROP COLUMN " + column;
        this.executeSql(conn, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object[]> executeSelectSql(Connection conn, String sql) throws SQLException {
        Statement ps = null;
        try {
            LOG.debug("DatabaseType.executing-sql", new Object[]{sql});
            ps = conn.createStatement();
            ResultSet resultSet = ps.executeQuery(sql);
            ResultSetMetaData metadata = resultSet.getMetaData();
            int numberColumns = metadata.getColumnCount();
            ArrayList<Object[]> results = new ArrayList<Object[]>();
            while (resultSet.next()) {
                Object[] nextRow = new Object[numberColumns];
                for (int i = 0; i < numberColumns; ++i) {
                    nextRow[i] = resultSet.getObject(i + 1);
                }
                results.add(nextRow);
            }
            ArrayList<Object[]> arrayList = results;
            this.closeStatement(ps);
            return arrayList;
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSql(Connection conn, String sql) throws SQLException {
        Statement ps = null;
        try {
            LOG.debug("DatabaseType.executing-sql", new Object[]{sql});
            ps = conn.createStatement();
            ps.executeUpdate(sql);
            this.closeStatement(ps);
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
    }

    public void executeSql(Connection conn, List<String> sql_list) throws SQLException {
        for (String sql : sql_list) {
            this.executeSql(conn, sql);
        }
    }

    public void dropSequence(Connection conn, String sequence_name) throws SQLException {
        String sql = "DROP SEQUENCE " + sequence_name;
        this.executeSql(conn, sql);
    }

    public void insert(Connection conn, String table, String insert_cmd) throws SQLException {
        String sql = "INSERT INTO " + table + " " + insert_cmd;
        this.executeSql(conn, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Connection conn, String table, String column, String where, String value, int jdbc_type_int) throws SQLException {
        String sql = "UPDATE " + table + " SET " + column + " = ? ";
        if (where != null) {
            sql = sql + "WHERE " + where;
        }
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
            if (jdbc_type_int == 16) {
                this.setBooleanValue(Boolean.valueOf(value), ps, 1);
            } else if (jdbc_type_int == -5) {
                ps.setLong(1, Long.parseLong(value));
            } else {
                ps.setObject(1, (Object)value, jdbc_type_int);
            }
            ps.executeUpdate();
        }
        finally {
            this.closeStatement(ps);
        }
    }

    public void addColumn(Connection conn, String table, String column, String generic_column, Object precision) throws SQLException {
        String sql = "ALTER TABLE " + table + " ADD " + column + " " + this.getDBTypeFromGenericType(generic_column);
        if (precision != null) {
            sql = sql + "(" + precision + ")";
        }
        this.executeSql(conn, sql);
    }

    public abstract boolean isTableNotFoundException(SQLException var1);

    public abstract int getSequenceValue(Connection var1, String var2, String var3) throws SQLException;

    public abstract int getNextSequenceValue(Connection var1, String var2, String var3) throws SQLException;

    public abstract void createSequence(Connection var1, String var2, String var3, String var4) throws SQLException;

    public abstract void alterColumn(Connection var1, String var2, String var3, String var4, String var5, String var6, Boolean var7, Boolean var8) throws SQLException;

    public abstract void reindexTable(Connection var1, String var2) throws SQLException;

    public String getEscapeCharacter() {
        String result = System.getProperty("rhq.server.database.escape-character");
        return null == result ? "\\" : result;
    }

    public boolean supportsSelfReferringCascade() {
        return true;
    }
}

