/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DbUtilsI18NFactory;

public abstract class PostgresqlDatabaseType
extends DatabaseType {
    public static final String VENDOR_NAME = "postgresql";

    public String getVendor() {
        return VENDOR_NAME;
    }

    public String getHibernateDialect() {
        return "org.hibernate.dialect.PostgreSQLDialect";
    }

    public boolean isTableNotFoundException(SQLException e) {
        return e.getSQLState().toUpperCase().equals("42P01");
    }

    public int getSequenceValue(Connection conn, String table, String key) throws SQLException {
        String query = "SELECT last_value FROM " + table + "_" + key + "_seq";
        PreparedStatement selectPS = null;
        ResultSet rs = null;
        try {
            selectPS = conn.prepareStatement(query);
            rs = selectPS.executeQuery();
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
            throw new RuntimeException(DbUtilsI18NFactory.getMsg().getMsg("DatabaseTypeFactory.not-a-sequence", new Object[]{query}));
        }
        finally {
            this.closeJDBCObjects(null, selectPS, rs);
        }
    }

    public int getNextSequenceValue(Connection conn, String table, String key) throws SQLException {
        String query = "SELECT nextval('" + table + "_" + key + "_seq'::text)";
        PreparedStatement selectPS = null;
        ResultSet rs = null;
        try {
            selectPS = conn.prepareStatement(query);
            rs = selectPS.executeQuery();
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
            throw new RuntimeException(DbUtilsI18NFactory.getMsg().getMsg("DatabaseTypeFactory.not-a-sequence", new Object[]{query}));
        }
        finally {
            this.closeJDBCObjects(null, selectPS, rs);
        }
    }

    public void createSequence(Connection conn, String name, String initial, String increment) throws SQLException {
        String sql = "CREATE SEQUENCE " + name + " START " + initial + " INCREMENT " + increment + " CACHE 10";
        this.executeSql(conn, sql);
    }

    public void alterColumn(Connection conn, String table, String column, String generic_column_type, String default_value, String precision, Boolean nullable, Boolean reindex) throws SQLException {
        String db_column_type = null;
        ArrayList<String> sql_list = new ArrayList<String>();
        if (generic_column_type != null) {
            db_column_type = this.getDBTypeFromGenericType(generic_column_type);
            if (precision != null) {
                db_column_type = db_column_type + " (" + precision + ")";
            }
            sql_list.add("ALTER TABLE " + table + " ALTER COLUMN " + column + " TYPE " + db_column_type);
        }
        if (default_value != null) {
            sql_list.add("ALTER TABLE " + table + " ALTER COLUMN " + column + " SET DEFAULT '" + default_value + "'");
        }
        if (nullable != null) {
            if (nullable.booleanValue()) {
                sql_list.add("ALTER TABLE " + table + " ALTER " + column + " DROP NOT NULL");
            } else {
                sql_list.add("ALTER TABLE " + table + " ALTER " + column + " SET NOT NULL");
            }
        }
        this.executeSql(conn, sql_list);
        if (reindex != null && reindex.booleanValue()) {
            this.reindexTable(conn, table);
        }
    }

    public void reindexTable(Connection conn, String table) throws SQLException {
        this.executeSql(conn, "REINDEX TABLE " + table);
    }

    public String getEscapeCharacter() {
        String result = System.getProperty("rhq.server.database.escape-character");
        return null == result ? "\\\\" : result;
    }
}

