/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.ant.dbsetup;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import mazz.i18n.Msg;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.rhq.core.db.ant.DbAntI18NFactory;
import org.rhq.core.db.ant.dbsetup.SimpleFileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseFileSetTask
extends Task {
    private static final Msg MSG = DbAntI18NFactory.getMsg();
    private List<Object> m_fileSets = new ArrayList<Object>();

    public void addFileset(FileSet set) {
        this.m_fileSets.add(set);
    }

    public void addFilelist(FileList list) {
        this.m_fileSets.add(list);
    }

    protected void validateAttributes() throws BuildException {
        if (this.m_fileSets.size() == 0) {
            throw new BuildException(MSG.getMsg("BaseFileSetTask.need-a-file", new Object[0]));
        }
    }

    protected List<SimpleFileSet> getAllFileSets() {
        ArrayList<SimpleFileSet> sets = new ArrayList<SimpleFileSet>();
        for (Object obj : this.m_fileSets) {
            if (obj instanceof FileSet) {
                sets.add(new SimpleFileSet(this.getProject(), (FileSet)obj));
                continue;
            }
            sets.add(new SimpleFileSet(this.getProject(), (FileList)obj));
        }
        return sets;
    }

    protected List<File> getAllFiles() {
        HashSet<File> files = new HashSet<File>();
        List<SimpleFileSet> all_file_sets = this.getAllFileSets();
        for (SimpleFileSet file_set : all_file_sets) {
            int len = file_set.files.length;
            for (int i = 0; i < len; ++i) {
                File current = new File(file_set.baseDir, file_set.files[i]);
                if (!current.exists()) {
                    this.log(MSG.getMsg("BaseFileSetTask.file-does-not-exist", new Object[]{current}), 1);
                    continue;
                }
                files.add(current);
            }
        }
        ArrayList<File> fileList = new ArrayList<File>();
        fileList.addAll(files);
        return fileList;
    }
}

