/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.ant.dbupgrade;

import java.sql.Connection;
import mazz.i18n.Msg;
import org.apache.tools.ant.BuildException;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.ant.DbAntI18NFactory;
import org.rhq.core.db.ant.dbupgrade.SchemaSpecTask;

public class SST_Update
extends SchemaSpecTask {
    private static final Msg MSG = DbAntI18NFactory.getMsg();
    private String table;
    private String column;
    private String columnType;
    private String value;
    private String where;

    public void setTable(String t) {
        this.table = t;
    }

    public void setColumn(String c) {
        this.column = c;
    }

    public void setColumnType(String ct) {
        this.columnType = ct;
    }

    public void setValue(String v) {
        this.value = v;
    }

    public void setWhere(String w) {
        this.where = w;
    }

    public void execute() throws BuildException {
        if (!this.isDBTargeted()) {
            return;
        }
        this.validateAttributes();
        DatabaseType db_type = this.getDatabaseType();
        Connection conn = this.getConnection();
        int jdbc_type_int = this.translateSqlType(this.columnType);
        try {
            boolean foundColumn = db_type.checkColumnExists(conn, this.table, this.column);
            if (!foundColumn) {
                throw new BuildException(MSG.getMsg("SchemaSpecTask.update.column-does-not-exist", new Object[]{this.column, this.table}));
            }
            this.log(MSG.getMsg("SchemaSpecTask.update.executing", new Object[]{this.columnType, jdbc_type_int, this.table, this.column, this.value, this.where}));
            db_type.update(conn, this.table, this.column, this.where, this.value, jdbc_type_int);
        }
        catch (Exception e) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.update.error", new Object[]{this.table, this.column, e}), (Throwable)e);
        }
    }

    private void validateAttributes() throws BuildException {
        if (this.table == null) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.missing-attrib", new Object[]{"Update", "table"}));
        }
        if (this.column == null) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.missing-attrib", new Object[]{"Update", "column"}));
        }
        if (this.columnType == null) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.missing-attrib", new Object[]{"Update", "columnType"}));
        }
        if (this.value == null) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.missing-attrib", new Object[]{"Update", "value"}));
        }
    }
}

