/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.setup;

import java.util.Collection;
import java.util.List;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.setup.Column;
import org.rhq.core.db.setup.Table;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

class OracleColumn
extends Column {
    protected OracleColumn(Node node, Table table) throws SAXException {
        super(node, table);
    }

    protected String getCreateCommand(List cmds, Collection typemaps, DatabaseType dbtype) {
        String defaultValue = this.getsDefault();
        if (defaultValue != null) {
            if (defaultValue.equalsIgnoreCase("TRUE")) {
                this.m_sDefault = "1";
            } else if (defaultValue.equalsIgnoreCase("FALSE")) {
                this.m_sDefault = "0";
            }
        }
        if ("CLOB".equals(this.getMappedType(typemaps, dbtype))) {
            this.m_iSize = 0;
        }
        return super.getCreateCommand(cmds, typemaps, dbtype);
    }

    protected String getDefaultCommand(List cmds) {
        if (this.hasDefault()) {
            switch (this.getDefault()) {
                case 1: 
                case 3: {
                    String strSeqName = this.m_strTableName.toUpperCase() + '_' + this.getName().toUpperCase() + "_SEQ";
                    cmds.add(0, "CREATE SEQUENCE " + strSeqName + " START WITH " + this.getInitialSequence() + " INCREMENT BY " + this.getIncrementSequence() + " NOMAXVALUE NOCYCLE CACHE 10");
                    break;
                }
            }
        }
        return "";
    }

    protected void getPostCreateCommands(List cmds) {
        if (this.hasDefault()) {
            switch (this.getDefault()) {
                case 1: {
                    String strSeqName = this.m_strTableName.toUpperCase() + '_' + this.getName().toUpperCase() + "_SEQ";
                    cmds.add("CREATE OR REPLACE TRIGGER " + strSeqName + "_T " + "BEFORE INSERT ON " + this.m_strTableName + " " + "FOR EACH ROW " + "BEGIN " + "SELECT " + strSeqName + ".NEXTVAL INTO :NEW." + this.getName().toUpperCase() + " FROM DUAL; " + "END;");
                    break;
                }
            }
        }
    }

    protected void getDropCommands(List cmds) {
        if (this.hasDefault()) {
            switch (this.getDefault()) {
                case 1: 
                case 3: {
                    String strSeqName = this.m_strTableName.toUpperCase() + '_' + this.getName().toUpperCase() + "_SEQ";
                    cmds.add("DROP SEQUENCE " + strSeqName);
                    break;
                }
            }
        }
    }
}

