/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.setup;

import java.util.List;
import org.rhq.core.db.setup.Column;
import org.rhq.core.db.setup.Table;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

class PostgresColumn
extends Column {
    protected PostgresColumn(Node node, Table table) throws SAXException {
        super(node, table);
    }

    protected String getDefaultCommand(List cmds) {
        if (this.m_strType.equalsIgnoreCase("auto") || this.m_iDefault == 3) {
            return "";
        }
        String strSeqName = this.m_strTableName.toUpperCase() + '_' + this.getName().toUpperCase() + "_SEQ";
        return "DEFAULT nextval('" + strSeqName + "')";
    }

    protected void getPreCreateCommands(List cmds) {
        if (this.m_strType.equalsIgnoreCase("auto")) {
            return;
        }
        if (this.hasDefault()) {
            switch (this.getDefault()) {
                case 1: 
                case 3: {
                    String strSeqName = this.m_strTableName.toUpperCase() + '_' + this.getName().toUpperCase() + "_SEQ";
                    cmds.add(0, "CREATE SEQUENCE " + strSeqName + " START " + this.getInitialSequence() + " INCREMENT " + this.getIncrementSequence() + " CACHE 10");
                    break;
                }
            }
        }
    }

    protected void getDropCommands(List cmds) {
        if (this.hasDefault()) {
            switch (this.getDefault()) {
                case 1: 
                case 3: {
                    String strSeqName = this.m_strTableName.toUpperCase() + '_' + this.getName().toUpperCase() + "_SEQ";
                    cmds.add("DROP SEQUENCE " + strSeqName);
                    break;
                }
            }
        }
    }
}

