/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.setup;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.db.SQLServerDatabaseType;
import org.rhq.core.db.setup.Column;
import org.rhq.core.db.setup.Constraint;
import org.rhq.core.db.setup.DBSetup;
import org.rhq.core.db.setup.DataSet;
import org.rhq.core.db.setup.Index;
import org.rhq.core.db.setup.OracleTable;
import org.rhq.core.db.setup.SQLServerSqlDataSet;
import org.rhq.core.db.setup.SQLServerXmlDataSet;
import org.rhq.core.db.setup.SqlDataSet;
import org.rhq.core.db.setup.XmlDataSet;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Table {
    private DBSetup m_parent;
    private String m_strName;
    private boolean m_indexOrganized = false;
    private boolean m_parallel = false;
    private boolean m_logging = false;
    private boolean m_cache = false;
    private String m_tableSpace;
    private String m_storage;
    private String m_engine;
    private List<Column> m_listColumns;
    private Collection<Index> m_collIndexes;
    private Collection<Constraint> m_collConstraints;
    private DataSet m_dataset;
    private boolean m_obsolete = false;

    protected Table(Node node, DatabaseType dbtype, DBSetup dbsetup) throws SAXException {
        this.m_parent = dbsetup;
        if (Table.isTable(node)) {
            NamedNodeMap map = node.getAttributes();
            for (int iTab = 0; iTab < map.getLength(); ++iTab) {
                Node nodeMap = map.item(iTab);
                if (nodeMap.getNodeName().equalsIgnoreCase("name")) {
                    this.m_strName = nodeMap.getNodeValue();
                    continue;
                }
                if (nodeMap.getNodeName().equalsIgnoreCase("index-organized")) {
                    this.m_indexOrganized = nodeMap.getNodeValue().equalsIgnoreCase("true");
                    continue;
                }
                if (nodeMap.getNodeName().equalsIgnoreCase("parallel")) {
                    this.m_parallel = nodeMap.getNodeValue().equalsIgnoreCase("true");
                    continue;
                }
                if (nodeMap.getNodeName().equalsIgnoreCase("logging")) {
                    this.m_logging = nodeMap.getNodeValue().equalsIgnoreCase("true");
                    continue;
                }
                if (nodeMap.getNodeName().equalsIgnoreCase("cache")) {
                    this.m_cache = nodeMap.getNodeValue().equalsIgnoreCase("true");
                    continue;
                }
                if (nodeMap.getNodeName().equalsIgnoreCase("tablespace")) {
                    this.m_tableSpace = nodeMap.getNodeValue();
                    continue;
                }
                if (nodeMap.getNodeName().equalsIgnoreCase("storage-options")) {
                    this.m_storage = nodeMap.getNodeValue();
                    continue;
                }
                if (nodeMap.getNodeName().equalsIgnoreCase("engine")) {
                    this.m_engine = nodeMap.getNodeValue();
                    continue;
                }
                if (nodeMap.getNodeName().equalsIgnoreCase("obsolete")) {
                    this.m_obsolete = nodeMap.getNodeValue() != null && nodeMap.getNodeValue().equalsIgnoreCase("true");
                    continue;
                }
                System.out.println("Unknown attribute '" + nodeMap.getNodeName() + "' in tag 'table'");
            }
            this.m_listColumns = Column.getColumns(node, this, dbtype);
            this.m_collIndexes = Index.getIndexes(this, node, dbtype);
            this.m_collConstraints = Constraint.getConstraints(this, node, dbtype);
            this.m_dataset = dbsetup.getDatabaseType() instanceof SQLServerDatabaseType ? new SQLServerXmlDataSet(this, node) : new XmlDataSet(this, node);
        } else {
            throw new SAXException("node is not a table.");
        }
    }

    protected Table(ResultSet set, DatabaseMetaData meta, DBSetup dbsetup) throws SQLException {
        this.m_parent = dbsetup;
        this.m_strName = set.getString(3);
        this.m_listColumns = Column.getColumns(meta, this, dbsetup.getJdbcUser());
        this.m_dataset = dbsetup.getDatabaseType() instanceof SQLServerDatabaseType ? new SQLServerSqlDataSet(this) : new SqlDataSet(this);
    }

    protected void create(Collection typemaps) throws SQLException {
        Vector collCmds = new Vector();
        this.getCreateCommands(collCmds, typemaps, this.m_parent.getDatabaseType());
        for (String strCmd : collCmds) {
            this.m_parent.doSQL(strCmd);
        }
    }

    private void doCmd(List collCmds) throws SQLException {
        for (String strCmd : collCmds) {
            this.m_parent.doSQL(strCmd);
        }
    }

    private void doCmdsWithoutAbortingOnErrors(List collCmds) throws SQLException {
        SQLException sqlException = null;
        for (String strCmd : collCmds) {
            try {
                this.m_parent.doSQL(strCmd);
            }
            catch (SQLException e) {
                if (sqlException == null) {
                    sqlException = e;
                    continue;
                }
                sqlException.setNextException(e);
                sqlException = e;
            }
        }
        if (sqlException != null) {
            throw sqlException;
        }
    }

    protected void clear() throws SQLException {
        ArrayList collCmds = new ArrayList();
        this.getClearCommands(collCmds);
        this.doCmd(collCmds);
    }

    protected void drop() throws SQLException {
        ArrayList collCmds = new ArrayList();
        this.getDropCommands(collCmds);
        this.doCmdsWithoutAbortingOnErrors(collCmds);
    }

    protected List getColumns() {
        return this.m_listColumns;
    }

    protected String getTableSpace() {
        return this.m_tableSpace;
    }

    protected String getStorage() {
        return this.m_storage;
    }

    protected String getEngine() {
        return this.m_engine;
    }

    protected boolean isObsolete() {
        return this.m_obsolete;
    }

    protected void getCreateCommands(List cmds, Collection typemaps, DatabaseType dbtype) {
        String strCmd = "CREATE TABLE " + this.getName() + " (";
        if (this.getName().length() > 30) {
            throw new RuntimeException("Column names must be at most 30 characters for oracle compatibility " + this.getName());
        }
        Iterator<Object> iter = this.getColumns().iterator();
        boolean bFirst = true;
        ArrayList preCreateCommands = new ArrayList();
        ArrayList postCreateCommands = new ArrayList();
        while (iter.hasNext()) {
            if (bFirst) {
                bFirst = false;
            } else {
                strCmd = strCmd + ", ";
            }
            Column col = (Column)iter.next();
            col.getPreCreateCommands(preCreateCommands);
            strCmd = strCmd + col.getCreateCommand(cmds, typemaps, dbtype);
            col.getPostCreateCommands(postCreateCommands);
        }
        for (Constraint constraint : this.getConstraints()) {
            strCmd = strCmd + constraint.getCreateString();
            constraint.getPostCreateCommands(postCreateCommands);
        }
        strCmd = strCmd + ')';
        if (this.m_indexOrganized) {
            strCmd = strCmd + this.getIndexOrganizedSyntax(dbtype);
        }
        if (this.m_tableSpace != null && !this.m_tableSpace.equals("DEFAULT") && !this.getTableSpaceSyntax().equals("")) {
            strCmd = strCmd + this.getTableSpaceSyntax() + this.getTableSpace();
        }
        strCmd = strCmd + this.getStorageClause();
        if (this.m_parallel) {
            strCmd = strCmd + this.getParallelSyntax();
        }
        if (!this.m_logging) {
            strCmd = strCmd + this.getLoggingSyntax();
        }
        if (this.m_cache) {
            strCmd = strCmd + this.getCacheSyntax();
        }
        cmds.addAll(preCreateCommands);
        cmds.add(strCmd);
        cmds.addAll(postCreateCommands);
    }

    public String getStorageClause() {
        if (this.m_storage != null && !this.getStorageSyntax().equals("")) {
            return this.getStorageSyntax() + "(" + this.m_storage + ")";
        }
        return "";
    }

    public String getEngineClause() {
        if (!this.getEngineSyntax().equals("")) {
            return this.getEngineSyntax();
        }
        return "";
    }

    protected String getIndexOrganizedSyntax(DatabaseType dbtype) {
        return DatabaseTypeFactory.isOracle(dbtype) ? " ORGANIZATION INDEX" : "";
    }

    protected String getParallelSyntax() {
        return "";
    }

    protected String getLoggingSyntax() {
        return "";
    }

    protected String getCacheSyntax() {
        return "";
    }

    protected String getTableSpaceSyntax() {
        return "";
    }

    protected String getStorageSyntax() {
        return "";
    }

    protected String getEngineSyntax() {
        return "";
    }

    protected DataSet getDataSet() {
        return this.m_dataset;
    }

    protected void getClearCommands(List cmds) {
        String strCmd = "DELETE FROM " + this.getName();
        cmds.add(strCmd);
    }

    protected void getDropCommands(List cmds) {
        String strCmd = "DROP TABLE " + this.getName();
        cmds.add(strCmd);
        Iterator iter = this.getColumns().iterator();
        while (iter.hasNext()) {
            ((Column)iter.next()).getDropCommands(cmds);
        }
    }

    protected Collection<Constraint> getConstraints() {
        return this.m_collConstraints;
    }

    protected Collection<Index> getIndexes() {
        return this.m_collIndexes;
    }

    protected String getQueryCommand() {
        String strCmd = "SELECT ";
        Iterator iter = this.getColumns().iterator();
        while (iter.hasNext()) {
            strCmd = strCmd + ((Column)iter.next()).getName();
            if (iter.hasNext()) {
                strCmd = strCmd + ',';
            }
            strCmd = strCmd + ' ';
        }
        strCmd = strCmd + "FROM " + this.getName();
        return strCmd;
    }

    protected String getName() {
        return this.m_strName;
    }

    protected static List<Table> getTables(Node node, DatabaseType dbtype, DBSetup parent) {
        ArrayList<Table> colResult = new ArrayList<Table>();
        NodeList listTabs = node.getChildNodes();
        for (int iTab = 0; iTab < listTabs.getLength(); ++iTab) {
            Node nodeTab = listTabs.item(iTab);
            if (!Table.isTable(nodeTab)) continue;
            try {
                if (DatabaseTypeFactory.isOracle(dbtype)) {
                    colResult.add(new OracleTable(nodeTab, dbtype, parent));
                    continue;
                }
                colResult.add(new Table(nodeTab, dbtype, parent));
                continue;
            }
            catch (SAXException e) {
                // empty catch block
            }
        }
        return colResult;
    }

    protected static Collection<Table> getTables(DatabaseType dbtype, DBSetup parent, String username) throws SQLException {
        if (DatabaseTypeFactory.isOracle(dbtype)) {
            return OracleTable.getTables(parent, username);
        }
        ArrayList<Table> coll = new ArrayList<Table>();
        DatabaseMetaData meta = parent.getConnection().getMetaData();
        String[] types = new String[]{"TABLE"};
        ResultSet setTabs = meta.getTables(null, null, "%", types);
        while (setTabs.next()) {
            coll.add(new Table(setTabs, meta, parent));
        }
        return coll;
    }

    protected static boolean isTable(Node nodeTable) {
        return nodeTable.getNodeName().equalsIgnoreCase("table");
    }

    protected static void uninstallCleanup(DBSetup parent) throws SQLException {
    }

    protected DBSetup getDBSetup() {
        return this.m_parent;
    }
}

