/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.upgrade;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.OracleDatabaseType;
import org.rhq.core.db.PostgresqlDatabaseType;
import org.rhq.core.db.upgrade.DatabaseUpgradeTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomAlertSenderUpgradeTask
implements DatabaseUpgradeTask {
    private DatabaseType databaseType;
    private Connection connection;
    private final long NOW = System.currentTimeMillis();

    @Override
    public void execute(DatabaseType databaseType, Connection connection) throws SQLException {
        this.databaseType = databaseType;
        this.connection = connection;
        this.upgradeSubjectNotificationLogs();
        this.upgradeRoleNotificationLogs();
        this.upgradeEmailNotificationLogs();
        this.upgradeOperationNotificationLogs();
        this.upgradeSubjectNotifications();
        this.upgradeRoleNotifications();
        this.upgradeEmailNotifications();
        this.upgradeSNMPNotifications();
        this.upgradeOperationNotifications();
    }

    private void upgradeSubjectNotificationLogs() throws SQLException {
        String field = "notif.subjects";
        String message = this.concat("'Sending to subjects: '", field);
        String insertSQL = this.getNotificationLogConversionSQL("'System Users'", "'UNKNOWN'", message, field);
        System.out.println("Executing: " + insertSQL);
        this.databaseType.executeSql(this.connection, insertSQL);
    }

    private void upgradeRoleNotificationLogs() throws SQLException {
        String field = "notif.roles";
        String message = this.concat("'Sending to roles: '", field);
        String insertSQL = this.getNotificationLogConversionSQL("'System Roles'", "'UNKNOWN'", message, field);
        System.out.println("Executing: " + insertSQL);
        this.databaseType.executeSql(this.connection, insertSQL);
    }

    private void upgradeEmailNotificationLogs() throws SQLException {
        String field = "notif.emails";
        String message = this.concat("'Sending to addresses: '", field);
        String insertSQL = this.getNotificationLogConversionSQL("'Direct Emails'", "'UNKNOWN'", message, field);
        System.out.println("Executing: " + insertSQL);
        this.databaseType.executeSql(this.connection, insertSQL);
    }

    private String getNotificationLogConversionSQL(String sender, String resultState, String message, String notNullField) {
        if (this.databaseType instanceof PostgresqlDatabaseType) {
            return "INSERT INTO rhq_alert_notif_log ( id, alert_id, sender, result_state, message )      SELECT nextval('RHQ_ALERT_NOTIF_LOG_ID_SEQ'),              notif.alert_id AS notifAlertId,              " + sender + " AS notifSender, " + "             " + resultState + " AS notifResultState, " + "             " + message + " AS notifMessage " + "        FROM rhq_alert_notif_log notif " + "       WHERE " + notNullField + " IS NOT NULL";
        }
        if (this.databaseType instanceof OracleDatabaseType) {
            return "INSERT INTO rhq_alert_notif_log ( id, alert_id, sender, result_state, message )      SELECT RHQ_ALERT_NOTIF_LOG_ID_SEQ.nextval,              notifAlertId, notifSender, notifResultState, notifMessage         FROM ( SELECT notif.alert_id AS notifAlertId,                       " + sender + " AS notifSender, " + "                      " + resultState + " AS notifResultState, " + "                      " + message + " AS notifMessage " + "                 FROM rhq_alert_notif_log notif " + "                WHERE " + notNullField + " IS NOT NULL )";
        }
        throw new IllegalStateException(this.getClass().getSimpleName() + " does not support upgrades for " + this.databaseType.getName());
    }

    private void upgradeOperationNotificationLogs() throws SQLException {
        String field = "alert.triggered_operation";
        String message = this.concat("'Executed \"'", field, "'\" on this resource'");
        String insertSQL = this.getNotificationLogInsertionSQL("'Resource Operations'", "'SUCCESS'", message, field);
        System.out.println("Executing: " + insertSQL);
        this.databaseType.executeSql(this.connection, insertSQL);
    }

    private String getNotificationLogInsertionSQL(String sender, String resultState, String message, String notNullField) {
        if (this.databaseType instanceof PostgresqlDatabaseType) {
            return "INSERT INTO rhq_alert_notif_log ( id, alert_id, sender, result_state, message )      SELECT nextval('RHQ_ALERT_NOTIF_LOG_ID_SEQ'),              alert.id AS notifAlertId,              " + sender + " AS notifSender, " + "             " + resultState + " AS notifResultState, " + "             " + message + " AS notifMessage " + "        FROM rhq_alert alert " + "       WHERE " + notNullField + " IS NOT NULL";
        }
        if (this.databaseType instanceof OracleDatabaseType) {
            return "INSERT INTO rhq_alert_notif_log ( id, alert_id, sender, result_state, message )      SELECT RHQ_ALERT_NOTIF_LOG_ID_SEQ.nextval,              notifAlertId, notifSender, notifResultState, notifMessage         FROM ( SELECT alert.id AS notifAlertId,                       " + sender + " AS notifSender, " + "                      " + resultState + " AS notifResultState, " + "                      " + message + " AS notifMessage " + "                 FROM rhq_alert alert " + "                WHERE " + notNullField + " IS NOT NULL )";
        }
        throw new IllegalStateException(this.getClass().getSimpleName() + " does not support upgrades for " + this.databaseType.getName());
    }

    private String concat(String ... elements) {
        StringBuilder builder = new StringBuilder();
        if (this.databaseType instanceof PostgresqlDatabaseType || this.databaseType instanceof OracleDatabaseType) {
            boolean first = true;
            for (String next : elements) {
                if (first) {
                    first = false;
                } else {
                    builder.append("||");
                }
                builder.append(next);
            }
        } else {
            throw new IllegalStateException(this.getClass().getSimpleName() + " does not support upgrades for " + this.databaseType.getName());
        }
        return builder.toString();
    }

    private void upgradeSubjectNotifications() throws SQLException {
        String dataMapSQL = "  SELECT notif.alert_definition_id, notif.subject_id     FROM rhq_alert_notification notif    WHERE notif.notification_type = 'SUBJECT' ORDER BY notif.alert_definition_id";
        List<Object[]> data = this.databaseType.executeSelectSql(this.connection, dataMapSQL);
        String propertyName = "subjectId";
        String senderName = "System Users";
        this.persist(data, propertyName, senderName, "|", true);
    }

    private void upgradeRoleNotifications() throws SQLException {
        String dataMapSQL = "  SELECT notif.alert_definition_id, notif.role_id     FROM rhq_alert_notification notif    WHERE notif.notification_type = 'ROLE' ORDER BY notif.alert_definition_id";
        List<Object[]> data = this.databaseType.executeSelectSql(this.connection, dataMapSQL);
        String propertyName = "roleId";
        String senderName = "System Roles";
        this.persist(data, propertyName, senderName, "|", true);
    }

    private void upgradeEmailNotifications() throws SQLException {
        String dataMapSQL = "  SELECT notif.alert_definition_id, notif.email_address     FROM rhq_alert_notification notif    WHERE notif.notification_type = 'EMAIL' ORDER BY notif.alert_definition_id";
        List<Object[]> data = this.databaseType.executeSelectSql(this.connection, dataMapSQL);
        String propertyName = "emailAddress";
        String senderName = "Direct Emails";
        this.persist(data, propertyName, senderName, ",", false);
    }

    private void upgradeSNMPNotifications() throws SQLException {
        String dataMapSQL = "  SELECT notif.alert_definition_id, notif.snmp_host, notif.snmp_port, notif.snmp_oid     FROM rhq_alert_notification notif    WHERE notif.notification_type = 'SNMP' ORDER BY notif.alert_definition_id";
        List<Object[]> data = this.databaseType.executeSelectSql(this.connection, dataMapSQL);
        for (Object[] next : data) {
            int alertDefinitionId = ((Number)next[0]).intValue();
            String host = (String)next[1];
            String port = ((Number)next[2]).toString();
            String oid = (String)next[3];
            int configId = this.persistConfiguration("host", host, "port", port, "oid", oid);
            this.persistNotification(alertDefinitionId, configId, "SNMP Traps");
        }
    }

    private void upgradeOperationNotifications() throws SQLException {
        String dataMapSQL = "  SELECT def.id, def.operation_def_id    FROM rhq_alert_definition def   WHERE def.operation_def_id IS NOT NULL";
        List<Object[]> data = this.databaseType.executeSelectSql(this.connection, dataMapSQL);
        for (Object[] next : data) {
            int alertDefinitionId = ((Number)next[0]).intValue();
            String operationDefinitionId = ((Number)next[1]).toString();
            int configId = this.persistConfiguration("operation-definition-id", operationDefinitionId, "selection-mode", "SELF");
            this.persistNotification(alertDefinitionId, configId, "Resource Operations");
        }
    }

    private void persist(List<Object[]> data, String propertyName, String sender, String delimiter, boolean bufferWithDelimiter) throws SQLException {
        int definitionId = -1;
        StringBuilder buffer = new StringBuilder();
        for (Object[] next : data) {
            int nextDefinitionId = ((Number)next[0]).intValue();
            String nextData = String.valueOf(next[1]);
            if (nextDefinitionId != definitionId) {
                if (buffer.length() != 0) {
                    String bufferedData = bufferWithDelimiter ? delimiter + buffer.toString() + delimiter : buffer.toString();
                    int configId = this.persistConfiguration(propertyName, bufferedData);
                    this.persistNotification(definitionId, configId, sender);
                }
                definitionId = nextDefinitionId;
                buffer = new StringBuilder();
            }
            if (buffer.length() != 0) {
                buffer.append(delimiter);
            }
            buffer.append(nextData);
        }
        if (buffer.length() != 0) {
            String bufferedData = bufferWithDelimiter ? delimiter + buffer.toString() + delimiter : buffer.toString();
            int configId = this.persistConfiguration(propertyName, bufferedData);
            this.persistNotification(definitionId, configId, sender);
        }
    }

    private int persistConfiguration(String ... propertyNameValues) throws SQLException {
        int configId = this.databaseType.getNextSequenceValue(this.connection, "rhq_config", "id");
        String insertConfigSQL = this.getInsertConfigSQL(configId);
        this.databaseType.executeSql(this.connection, insertConfigSQL);
        for (int i = 0; i < propertyNameValues.length; i += 2) {
            String propertyName = propertyNameValues[i];
            String propertyValue = propertyNameValues[i + 1];
            int propertyId = this.databaseType.getNextSequenceValue(this.connection, "rhq_config_property", "id");
            String insertPropertySQL = this.getInsertPropertySQL(propertyId, configId, propertyName, propertyValue);
            this.databaseType.executeSql(this.connection, insertPropertySQL);
        }
        return configId;
    }

    private void persistNotification(int definitionId, int configId, String sender) throws SQLException {
        int notificationId = this.databaseType.getNextSequenceValue(this.connection, "rhq_alert_notification", "id");
        String insertNotificationSQL = this.getInsertNotificationSQL(notificationId, definitionId, configId, sender);
        this.databaseType.executeSql(this.connection, insertNotificationSQL);
    }

    private String getInsertConfigSQL(int id) {
        return "INSERT INTO rhq_config ( id, version, ctime, mtime )      VALUES ( " + id + ", 0, " + this.NOW + ", " + this.NOW + " ) ";
    }

    private String getInsertPropertySQL(int id, int configId, String name, String value) {
        return "INSERT INTO rhq_config_property ( id, configuration_id, name, string_value, dtype )      VALUES ( " + id + ", " + configId + ", '" + name + "', '" + value + "', 'property' ) ";
    }

    private String getInsertNotificationSQL(int id, int definitionId, int configId, String sender) {
        return "INSERT INTO rhq_alert_notification ( id, alert_definition_id, sender_config_id, sender_name )      VALUES ( " + id + ", " + definitionId + ", " + configId + ", '" + sender + "' ) ";
    }
}

