/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.plugins.tomcat.helper;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.rhq.core.domain.content.PackageDetails;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.pluginapi.util.FileUtils;
import org.rhq.core.util.ZipUtil;
import org.rhq.core.util.file.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileContentDelegate {
    private File deployDirectory;
    private String packageTypeName;

    public FileContentDelegate(File directory, String packageTypeName) {
        this.deployDirectory = directory;
        this.packageTypeName = packageTypeName;
    }

    public String getPackageTypeName() {
        return this.packageTypeName;
    }

    public File getDirectory() {
        return this.deployDirectory;
    }

    public void createContent(File contentFile, InputStream content, boolean unzip) {
        try {
            if (unzip) {
                ZipUtil.unzipFile((InputStream)content, (File)contentFile);
            } else {
                FileUtil.writeFile((InputStream)content, (File)contentFile);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating artifact for contentFile: " + contentFile, e);
        }
    }

    public File getPath(PackageDetails details) {
        PackageDetailsKey key = details.getKey();
        String fileName = key.getName();
        int lastPathStart = fileName.lastIndexOf(File.separatorChar);
        if (lastPathStart > -1) {
            fileName = fileName.substring(lastPathStart + 1);
        }
        return new File(this.deployDirectory, fileName);
    }

    public InputStream getContent(PackageDetails details) {
        File contentFile = this.getPath(details);
        try {
            return new BufferedInputStream(new FileInputStream(contentFile));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Package content not found for package " + contentFile, e);
        }
    }

    public void deleteContent(PackageDetails details) {
        File contentFile = this.getPath(details);
        if (!contentFile.exists()) {
            return;
        }
        try {
            FileUtils.purge((File)contentFile, (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to delete underlying file [" + contentFile + "] for " + details + ".", e);
        }
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages() {
        return null;
    }
}

