/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil;

import eu.medsea.mimeutil.MimeType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

class MimeTypeHashSet
implements Set,
Collection {
    private Set hashSet = new LinkedHashSet();

    MimeTypeHashSet() {
    }

    MimeTypeHashSet(Collection collection) {
        this.addAll(collection);
    }

    MimeTypeHashSet(int initialCapacity) {
        this.hashSet = new HashSet(initialCapacity);
    }

    MimeTypeHashSet(int initialCapacity, float loadFactor) {
        this.hashSet = new HashSet(initialCapacity, loadFactor);
    }

    MimeTypeHashSet(String arg0) {
        this.add(arg0);
    }

    MimeTypeHashSet(String[] arg0) {
        this.add(arg0);
    }

    MimeTypeHashSet(MimeType mimeType) {
        this.add(mimeType);
    }

    public boolean add(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (arg0 instanceof MimeType) {
            this.updateSpecificity(arg0);
            return this.hashSet.add(arg0);
        }
        if (arg0 instanceof Collection) {
            return this.addAll((Collection)arg0);
        }
        if (arg0 instanceof String) {
            String[] mimeTypes = ((String)arg0).split(",");
            boolean added = false;
            for (int i = 0; i < mimeTypes.length; ++i) {
                try {
                    if (!this.add(new MimeType(mimeTypes[i]))) continue;
                    added = true;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return added;
        }
        if (arg0 instanceof String[]) {
            boolean added = false;
            String[] mimeTypes = (String[])arg0;
            for (int i = 0; i < mimeTypes.length; ++i) {
                String[] parts = mimeTypes[i].split(",");
                for (int j = 0; j < parts.length; ++j) {
                    try {
                        if (!this.add(new MimeType(parts[j]))) continue;
                        added = true;
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            return added;
        }
        return false;
    }

    public boolean addAll(Collection arg0) throws NullPointerException {
        if (arg0 == null) {
            throw new NullPointerException();
        }
        boolean added = false;
        Iterator it = arg0.iterator();
        while (it.hasNext()) {
            try {
                if (!this.add(it.next())) continue;
                added = true;
            }
            catch (Exception e) {}
        }
        return added;
    }

    public void clear() {
        this.hashSet.clear();
    }

    public boolean contains(Object o) {
        if (o instanceof MimeType) {
            return this.hashSet.contains(o);
        }
        if (o instanceof Collection) {
            return this.containsAll((Collection)o);
        }
        if (o instanceof String) {
            String[] parts = ((String)o).split(",");
            for (int i = 0; i < parts.length; ++i) {
                if (this.contains(new MimeType(parts[i]))) continue;
                return false;
            }
            return true;
        }
        if (o instanceof String[]) {
            String[] mimeTypes = (String[])o;
            for (int i = 0; i < mimeTypes.length; ++i) {
                String[] parts = mimeTypes[i].split(",");
                for (int j = 0; j < parts.length; ++j) {
                    if (this.contains(new MimeType(parts[j]))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection arg0) {
        if (arg0 == null) {
            throw new NullPointerException();
        }
        Iterator it = arg0.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.hashSet.isEmpty();
    }

    public Iterator iterator() {
        return this.hashSet.iterator();
    }

    public boolean remove(Object o) {
        boolean removed = false;
        if (o == null) {
            return removed;
        }
        if (o instanceof MimeType) {
            return this.hashSet.remove(o);
        }
        if (o instanceof String) {
            String[] parts = ((String)o).split(",");
            for (int i = 0; i < parts.length; ++i) {
                if (!this.remove(new MimeType(parts[i]))) continue;
                removed = true;
            }
        } else if (o instanceof String[]) {
            String[] mimeTypes = (String[])o;
            for (int i = 0; i < mimeTypes.length; ++i) {
                String[] parts = mimeTypes[i].split(",");
                for (int j = 0; j < parts.length; ++j) {
                    if (!this.remove(new MimeType(parts[j]))) continue;
                    removed = true;
                }
            }
        } else if (o instanceof Collection) {
            return this.removeAll((Collection)o);
        }
        return removed;
    }

    public boolean removeAll(Collection arg0) {
        if (arg0 == null) {
            throw new NullPointerException();
        }
        boolean removed = false;
        Iterator it = arg0.iterator();
        while (it.hasNext()) {
            if (!this.remove(it.next())) continue;
            removed = true;
        }
        return removed;
    }

    public boolean retainAll(Collection arg0) {
        if (arg0 == null) {
            throw new NullPointerException();
        }
        MimeTypeHashSet c = new MimeTypeHashSet(arg0);
        return this.hashSet.retainAll(c);
    }

    public int size() {
        return this.hashSet.size();
    }

    public Object[] toArray() {
        return this.hashSet.toArray();
    }

    public Object[] toArray(Object[] arg0) {
        return this.hashSet.toArray(arg0);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            buf.append(((MimeType)it.next()).toString());
            if (!it.hasNext()) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        MimeTypeHashSet c = new MimeTypeHashSet();
        c.add(o);
        return this.match(c);
    }

    private boolean match(Collection c) {
        if (this.size() != c.size()) {
            return false;
        }
        MimeType[] mt = c.toArray(new MimeType[c.size()]);
        for (int i = 0; i < mt.length; ++i) {
            if (this.contains(mt[i])) continue;
            return false;
        }
        return true;
    }

    private void updateSpecificity(Object o) {
        if (o instanceof MimeType) {
            this.updateMimeType((MimeType)o);
        } else {
            Collection mimeTypes = (Collection)o;
            Iterator it = mimeTypes.iterator();
            while (it.hasNext()) {
                this.updateMimeType((MimeType)it.next());
            }
        }
    }

    private void updateMimeType(MimeType mimeType) {
        if (!this.hashSet.contains(mimeType)) {
            return;
        }
        Iterator it = this.hashSet.iterator();
        while (it.hasNext()) {
            MimeType mt = (MimeType)it.next();
            if (!mt.equals(mimeType)) continue;
            mt.setSpecificity(mt.getSpecificity() + mimeType.getSpecificity());
            return;
        }
    }

    public Collection matches(String pattern) {
        MimeTypeHashSet c = new MimeTypeHashSet();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            MimeType mimeType = (MimeType)it.next();
            if (!mimeType.toString().matches(pattern)) continue;
            c.add(mimeType);
        }
        return c;
    }
}

