/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil;

import eu.medsea.mimeutil.MimeException;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtilMimeDetectorRegistry;
import eu.medsea.mimeutil.TextMimeType;
import eu.medsea.mimeutil.detector.MimeDetector;
import eu.medsea.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MimeUtil {
    private static Log log = LogFactory.getLog((Class)MimeUtil.class);
    public static final MimeType DIRECTORY_MIME_TYPE = new MimeType("application/directory");
    public static final MimeType UNKNOWN_MIME_TYPE = new MimeType("application/octet-stream");
    private static final Pattern mimeSplitter = Pattern.compile("[/;]++");
    private static Map mimeTypes = new HashMap();
    private static MimeUtilMimeDetectorRegistry mimeUtilMimeDetector = new MimeUtilMimeDetectorRegistry();
    private static ByteOrder nativeByteOrder = ByteOrder.nativeOrder();

    public static void addKnownMimeType(MimeType mimeType) {
        MimeUtil.addKnownMimeType(mimeType.toString());
    }

    public static void addKnownMimeType(String mimeType) {
        try {
            String key = MimeUtil.getMediaType(mimeType);
            TreeSet<String> s = (TreeSet<String>)mimeTypes.get(key);
            if (s == null) {
                s = new TreeSet<String>();
            }
            s.add(MimeUtil.getSubType(mimeType));
            mimeTypes.put(key, s);
        }
        catch (MimeException mimeException) {
            // empty catch block
        }
    }

    public static void addMimeDetector(MimeDetector mimeDetector) {
        mimeUtilMimeDetector.addMimeDetector(mimeDetector);
    }

    public static String getExtension(File file) {
        return MimeUtil.getExtension(file.getName());
    }

    public static String getExtension(String fileName) {
        File file = new File(fileName);
        String fname = file.getName();
        if (fname == null || fname.indexOf(".") < 0) {
            return "";
        }
        return fname.substring(fname.indexOf(".") + 1);
    }

    public static MimeType getFirstMimeType(String mimeTypes) {
        if (mimeTypes != null && mimeTypes.trim().length() != 0) {
            return new MimeType(mimeTypes.split(",")[0].trim());
        }
        return null;
    }

    public static String getMediaType(String mimeType) throws MimeException {
        return new MimeType(mimeType).getMediaType();
    }

    public static double getMimeQuality(String mimeType) throws MimeException {
        if (mimeType == null) {
            throw new MimeException("Invalid MimeType [" + mimeType + "].");
        }
        String[] parts = mimeSplitter.split(mimeType);
        if (parts.length < 2) {
            throw new MimeException("Invalid MimeType [" + mimeType + "].");
        }
        if (parts.length > 2) {
            for (int i = 2; i < parts.length; ++i) {
                if (!parts[i].trim().startsWith("q=")) continue;
                try {
                    double d = Double.parseDouble(parts[i].split("=")[1].trim());
                    return d > 1.0 ? 1.0 : d;
                }
                catch (NumberFormatException e) {
                    throw new MimeException("Invalid Mime quality indicator [" + parts[i].trim() + "]. Must be a valid double between 0 and 1");
                }
                catch (Exception e) {
                    throw new MimeException("Error parsing Mime quality indicator.", e);
                }
            }
        }
        if (parts[0].contains("*")) {
            return 0.01;
        }
        if (parts[1].contains("*")) {
            return 0.02;
        }
        return 1.0;
    }

    public static MimeDetector getMimeDetector(String name) {
        return mimeUtilMimeDetector.getMimeDetector(name);
    }

    public static Collection getMimeTypes(byte[] data) throws MimeException {
        return MimeUtil.getMimeTypes(data, UNKNOWN_MIME_TYPE);
    }

    public static Collection getMimeTypes(byte[] data, MimeType unknownMimeType) throws MimeException {
        if (log.isDebugEnabled()) {
            try {
                log.debug((Object)("Getting mime types for byte array [" + StringUtil.getHexString(data) + "]."));
            }
            catch (UnsupportedEncodingException uee) {
                throw new MimeException(uee);
            }
        }
        return mimeUtilMimeDetector.getMimeTypes(data, unknownMimeType);
    }

    public static Collection getMimeTypes(File file) throws MimeException {
        return MimeUtil.getMimeTypes(file, UNKNOWN_MIME_TYPE);
    }

    public static Collection getMimeTypes(File file, MimeType unknownMimeType) throws MimeException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting mime types for file [" + file.getAbsolutePath() + "]."));
        }
        return mimeUtilMimeDetector.getMimeTypes(file, unknownMimeType);
    }

    public static Collection getMimeTypes(InputStream in) throws MimeException {
        return MimeUtil.getMimeTypes(in, UNKNOWN_MIME_TYPE);
    }

    public static Collection getMimeTypes(InputStream in, MimeType unknownMimeType) throws MimeException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting mime types for InputSteam [" + in + "]."));
        }
        if (!in.markSupported()) {
            throw new MimeException("InputStream does not support mark and reset!");
        }
        return mimeUtilMimeDetector.getMimeTypes(in, unknownMimeType);
    }

    public static Collection getMimeTypes(String fileName) throws MimeException {
        return MimeUtil.getMimeTypes(fileName, UNKNOWN_MIME_TYPE);
    }

    public static Collection getMimeTypes(String fileName, MimeType unknownMimeType) throws MimeException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting mime types for file name [" + fileName + "]."));
        }
        return mimeUtilMimeDetector.getMimeTypes(fileName, unknownMimeType);
    }

    public static Collection getMimeTypes(URLConnection url) throws MimeException {
        return MimeUtil.getMimeTypes(url, UNKNOWN_MIME_TYPE);
    }

    public static Collection getMimeTypes(URLConnection url, MimeType unknownMimeType) throws MimeException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting mime types for URL [" + url + "]."));
        }
        try {
            return mimeUtilMimeDetector.getMimeTypes(new BufferedInputStream(url.getInputStream()), unknownMimeType);
        }
        catch (Exception e) {
            throw new MimeException(e);
        }
    }

    public static ByteOrder getNativeOrder() {
        return nativeByteOrder;
    }

    public static MimeType getPreferedMimeType(String accept, String canProvide) {
        if (canProvide == null || canProvide.trim().length() == 0) {
            throw new MimeException("Must specify at least one mime type that can be provided.");
        }
        if (accept == null || accept.trim().length() == 0) {
            accept = "*/*";
        }
        if (accept.indexOf(":") > 0) {
            accept = accept.substring(accept.indexOf(":") + 1);
        }
        accept = accept.replaceAll(" ", "");
        return MimeUtil.getBestMatch(accept, MimeUtil.getList(canProvide));
    }

    public static MimeType getMostSpecificMimeType(Collection mimeTypes) {
        MimeType mimeType = null;
        int specificity = 0;
        Iterator it = mimeTypes.iterator();
        while (it.hasNext()) {
            MimeType mt = (MimeType)it.next();
            if (mt.getSpecificity() <= specificity) continue;
            mimeType = mt;
        }
        return mimeType;
    }

    public static String getSubType(String mimeType) throws MimeException {
        return new MimeType(mimeType).getSubType();
    }

    public static boolean isMimeTypeKnown(MimeType mimeType) {
        try {
            Set s = (Set)mimeTypes.get(mimeType.getMediaType());
            if (s == null) {
                return false;
            }
            return s.contains(mimeType.getSubType());
        }
        catch (MimeException e) {
            return false;
        }
    }

    public static boolean isMimeTypeKnown(String mimeType) {
        return MimeUtil.isMimeTypeKnown(new MimeType(mimeType));
    }

    public static boolean isTextMimeType(MimeType mimeType) {
        return mimeType instanceof TextMimeType;
    }

    public static MimeDetector removeMimeDetector(MimeDetector mimeDetector) {
        return mimeUtilMimeDetector.removeMimeDetector(mimeDetector);
    }

    public static double getQuality(String mimeType) throws MimeException {
        if (mimeType == null || mimeType.trim().length() == 0) {
            return 0.0;
        }
        String[] parts = mimeSplitter.split(mimeType);
        if (parts.length > 2) {
            for (int i = 2; i < parts.length; ++i) {
                if (!parts[i].trim().startsWith("q=")) continue;
                try {
                    double d = Double.parseDouble(parts[i].split("=")[1].trim());
                    return d > 1.0 ? 1.0 : d;
                }
                catch (NumberFormatException e) {
                    throw new MimeException("Invalid Mime quality indicator [" + parts[i].trim() + "]. Must be a valid double between 0 and 1");
                }
                catch (Exception e) {
                    throw new MimeException("Error parsing Mime quality indicator.", e);
                }
            }
        }
        if (parts[0].contains("*")) {
            return 0.01;
        }
        if (parts[1].contains("*")) {
            return 0.02;
        }
        return 1.0;
    }

    private static MimeType getBestMatch(String accept, List canProvideList) {
        if (canProvideList.size() == 1) {
            return new MimeType((String)canProvideList.get(0));
        }
        Map wantedMap = MimeUtil.normaliseWantedMap(accept, canProvideList);
        MimeType bestMatch = null;
        double qos = 0.0;
        Iterator it = wantedMap.keySet().iterator();
        while (it.hasNext()) {
            List wantedList = (List)wantedMap.get(it.next());
            Iterator it2 = wantedList.iterator();
            while (it2.hasNext()) {
                String mimeType = (String)it2.next();
                double q = MimeUtil.getMimeQuality(mimeType);
                String majorComponent = MimeUtil.getMediaType(mimeType);
                String minorComponent = MimeUtil.getSubType(mimeType);
                if (!(q > qos)) continue;
                qos = q;
                bestMatch = new MimeType(majorComponent + "/" + minorComponent);
            }
        }
        return bestMatch;
    }

    private static List getList(String options) {
        ArrayList<String> list = new ArrayList<String>();
        String[] array = options.split(",");
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i].trim());
        }
        return list;
    }

    private static Map normaliseWantedMap(String accept, List canProvide) {
        LinkedHashMap map = new LinkedHashMap();
        String[] array = accept.split(",");
        for (int i = 0; i < array.length; ++i) {
            List<String> list;
            String mt;
            Iterator it;
            String mimeType = array[i].trim();
            String major = MimeUtil.getMediaType(mimeType);
            String minor = MimeUtil.getSubType(mimeType);
            double qos = MimeUtil.getMimeQuality(mimeType);
            if (major.contains("*")) {
                it = canProvide.iterator();
                while (it.hasNext()) {
                    mt = (String)it.next();
                    list = (ArrayList<String>)map.get(MimeUtil.getMediaType(mt));
                    if (list == null) {
                        list = new ArrayList<String>();
                    }
                    list.add(mt + ";q=" + qos);
                    map.put(MimeUtil.getMediaType(mt), list);
                }
                continue;
            }
            if (minor.contains("*")) {
                it = canProvide.iterator();
                while (it.hasNext()) {
                    mt = (String)it.next();
                    if (!MimeUtil.getMediaType(mt).equals(major)) continue;
                    list = (List)map.get(major);
                    if (list == null) {
                        list = new ArrayList();
                    }
                    list.add(major + "/" + MimeUtil.getSubType(mt) + ";q=" + qos);
                    map.put(major, list);
                }
                continue;
            }
            if (!canProvide.contains(major + "/" + minor)) continue;
            ArrayList<String> list2 = (ArrayList<String>)map.get(major);
            if (list2 == null) {
                list2 = new ArrayList<String>();
            }
            list2.add(major + "/" + minor + ";q=" + qos);
            map.put(major, list2);
        }
        return map;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("java -jar mime-util-<version>.jar <file> [<file> ...]");
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            File f = new File(args[i]);
            System.out.println("File:[" + f.getAbsolutePath() + "] - " + MimeUtil.getMimeTypes(args[i]));
        }
    }

    static {
        InputStream is = MimeUtil.class.getResourceAsStream("/MimeDetectors");
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        if (is != null) {
            try {
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (line.trim().startsWith("#")) continue;
                    Class.forName(line);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

