/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil;

import eu.medsea.mimeutil.MimeException;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.TextEncodings;
import java.io.UnsupportedEncodingException;
import java.util.Collection;

public class TextMimeType
extends MimeType {
    private static final long serialVersionUID = -4798584119063522367L;
    private static TextEncodings textEncodings = new TextEncodings();
    private String encoding = "UTF-8";

    public TextMimeType(MimeType mimeType) {
        super(mimeType);
    }

    public TextMimeType(String mimeType) {
        super(mimeType);
    }

    public TextMimeType(String mimeType, String encoding) {
        super(mimeType);
        this.encoding = this.getValidEncoding(encoding);
    }

    public Collection getKnownEncodings() {
        return textEncodings;
    }

    public static void addKnownEncoding(String encoding) {
        if (encoding == null || encoding.trim().length() == 0) {
            return;
        }
        textEncodings.add(encoding);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        if (!textEncodings.contains(encoding)) {
            throw new MimeException(new UnsupportedEncodingException("The encoding [" + encoding + "] is not a supported encoding."));
        }
        this.encoding = this.getValidEncoding(encoding);
    }

    private String getValidEncoding(String encoding) {
        if (encoding == null || encoding.trim().length() == 0 || !this.isKnownEncoding(encoding)) {
            return "UTF-8";
        }
        return encoding;
    }

    public boolean isKnownEncoding(String encoding) {
        return textEncodings.contains(encoding);
    }
}

