/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil.detector;

import eu.medsea.mimeutil.MimeException;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.handler.MimeHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class MimeDetector {
    private SortedSet mimeHandlers = new TreeSet();

    public final String getName() {
        return this.getClass().getName();
    }

    public final void addMimeHandler(MimeHandler handler) {
        this.mimeHandlers.add(handler);
    }

    public final boolean removeMimeHandler(MimeHandler handler) {
        return this.mimeHandlers.remove(handler);
    }

    public final Set getMimeHandlers() {
        return this.mimeHandlers;
    }

    private Collection fireMimeHandlers(Collection mimeTypes) {
        Iterator it = this.mimeHandlers.iterator();
        block0: while (it.hasNext()) {
            MimeHandler mh = (MimeHandler)it.next();
            Iterator itmh = mh.getMimeTypes().iterator();
            while (itmh.hasNext()) {
                MimeType mt = (MimeType)itmh.next();
                if (!mimeTypes.contains(mt)) continue;
                mimeTypes = mh.handle(mimeTypes);
                continue block0;
            }
        }
        return mimeTypes;
    }

    public final Collection getMimeTypes(byte[] data) {
        return this.fireMimeHandlers(this.getMimeTypesByteArray(data));
    }

    public final Collection getMimeTypes(URLConnection url) {
        try {
            Collection mimeTypes = this.fireMimeHandlers(this.getMimeTypesInputStream(new BufferedInputStream(url.getInputStream())));
            if (mimeTypes.isEmpty()) {
                mimeTypes.add(url.getContentType());
            }
            return mimeTypes;
        }
        catch (IOException e) {
            throw new MimeException(e);
        }
    }

    public final Collection getMimeTypes(File file) throws MimeException {
        return this.fireMimeHandlers(this.getMimeTypesFile(file));
    }

    public final Collection getMimeTypes(String fileName) throws MimeException {
        return this.fireMimeHandlers(this.getMimeTypesFile(new File(fileName)));
    }

    public final Collection getMimeTypes(InputStream in) throws MimeException {
        return this.fireMimeHandlers(this.getMimeTypesInputStream(in));
    }

    public abstract String getDescription();

    public abstract Collection getMimeTypesFile(File var1) throws UnsupportedOperationException;

    public abstract Collection getMimeTypesInputStream(InputStream var1) throws UnsupportedOperationException;

    public abstract Collection getMimeTypesByteArray(byte[] var1) throws UnsupportedOperationException;
}

