/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil.detector;

import eu.medsea.mimeutil.MimeException;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import eu.medsea.mimeutil.detector.MimeDetector;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpendesktopMimeDetector
extends MimeDetector {
    private static Log log = LogFactory.getLog((Class)OpendesktopMimeDetector.class);
    private static String mimeCacheFile = "/usr/share/mime/mime.cache";
    private static String internalMimeCacheFile = "src/main/resources/mime.cache";
    private ByteBuffer content;

    public OpendesktopMimeDetector(String mimeCacheFile) {
        this.init(mimeCacheFile);
    }

    public OpendesktopMimeDetector() {
        this.init(mimeCacheFile);
    }

    private void init(String mimeCacheFile) {
        String cacheFile = mimeCacheFile;
        if (!new File(cacheFile).exists()) {
            cacheFile = internalMimeCacheFile;
        }
        AbstractInterruptibleChannel rCh = null;
        try {
            RandomAccessFile raf = null;
            raf = new RandomAccessFile(cacheFile, "r");
            rCh = raf.getChannel();
            this.content = ((FileChannel)rCh).map(FileChannel.MapMode.READ_ONLY, 0L, ((FileChannel)rCh).size());
        }
        catch (Exception e) {
            throw new MimeException(e);
        }
        finally {
            if (rCh != null) {
                try {
                    rCh.close();
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    public String getDescription() {
        return "Resolve mime types for files and streams using the Opendesktop shared mime.cache file. Version [" + this.getMajorVersion() + "." + this.getMinorVersion() + "].";
    }

    public Collection getMimeTypesFile(File file) throws UnsupportedOperationException {
        Collection<String> mimeTypes = new ArrayList();
        this.lookupMimeTypesForGlobFileName(file, mimeTypes);
        if (!mimeTypes.isEmpty()) {
            mimeTypes = this.normalizeWeightedMimeList((List)mimeTypes);
        }
        if (file.exists() && !file.isDirectory() && (mimeTypes.isEmpty() || mimeTypes.size() > 1)) {
            try {
                Collection _mimeTypes = this.getMimeTypes(file.toURI().toURL().openConnection());
                if (!_mimeTypes.isEmpty()) {
                    Iterator it = mimeTypes.iterator();
                    while (it.hasNext()) {
                        String mimeType = (String)it.next();
                        if (_mimeTypes.contains(mimeType)) {
                            mimeTypes = new ArrayList();
                            mimeTypes.add(mimeType);
                            return mimeTypes;
                        }
                        Iterator _it = _mimeTypes.iterator();
                        while (_it.hasNext()) {
                            String _mimeType = (String)_it.next();
                            if (!this.isMimeTypeSubclass(mimeType, _mimeType)) continue;
                            mimeTypes = new ArrayList();
                            mimeTypes.add(mimeType);
                            return mimeTypes;
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new MimeException(e);
            }
        }
        return mimeTypes;
    }

    public Collection getMimeTypesInputStream(InputStream in) throws UnsupportedOperationException {
        ArrayList mimeTypes = new ArrayList();
        this.lookupMimeTypesForMagicData(in, mimeTypes);
        return mimeTypes;
    }

    public Collection getMimeTypesByteArray(byte[] data) throws UnsupportedOperationException {
        ArrayList mimeTypes = new ArrayList();
        this.lookupMagicData(data, mimeTypes);
        return mimeTypes;
    }

    public String dump() {
        return "{MAJOR_VERSION=" + this.getMajorVersion() + " MINOR_VERSION=" + this.getMinorVersion() + " ALIAS_LIST_OFFSET=" + this.getAliasListOffset() + " PARENT_LIST_OFFSET=" + this.getParentListOffset() + " LITERAL_LIST_OFFSET=" + this.getLiteralListOffset() + " REVERSE_SUFFIX_TREE_OFFSET=" + this.getReverseSuffixTreeOffset() + " GLOB_LIST_OFFSET=" + this.getGlobListOffset() + " MAGIC_LIST_OFFSET=" + this.getMagicListOffset() + " NAMESPACE_LIST_OFFSET=" + this.getNameSpaceListOffset() + " ICONS_LIST_OFFSET=" + this.getIconListOffset() + " GENERIC_ICONS_LIST_OFFSET=" + this.getGenericIconListOffset() + "}";
    }

    private void lookupMimeTypesForMagicData(InputStream in, Collection mimeTypes) {
        int offset = 0;
        int len = this.getMaxExtents();
        byte[] data = new byte[len];
        try {
            int bytesRead;
            for (int restBytesToRead = len; restBytesToRead > 0 && (bytesRead = in.read(data, offset, restBytesToRead)) >= 0; restBytesToRead -= bytesRead) {
                offset += bytesRead;
            }
        }
        catch (IOException ioe) {
            throw new MimeException(ioe);
        }
        this.lookupMagicData(data, mimeTypes);
    }

    private void lookupMagicData(byte[] data, Collection mimeTypes) {
        int listOffset = this.getMagicListOffset();
        int numEntries = this.content.getInt(listOffset);
        int offset = this.content.getInt(listOffset + 8);
        for (int i = 0; i < numEntries; ++i) {
            String mimeType = this.compareToMagicData(offset + 16 * i, data);
            if (mimeType != null) {
                mimeTypes.add(mimeType);
                continue;
            }
            String nonMatch = this.getMimeType(this.content.getInt(offset + 16 * i + 4));
            mimeTypes.remove(nonMatch);
        }
    }

    private String compareToMagicData(int offset, byte[] data) {
        int priority = this.content.getInt(offset);
        int mimeOffset = this.content.getInt(offset + 4);
        int numMatches = this.content.getInt(offset + 8);
        int matchletOffset = this.content.getInt(offset + 12);
        for (int i = 0; i < numMatches; ++i) {
            if (!this.matchletMagicCompare(matchletOffset + i * 32, data)) continue;
            return this.getMimeType(mimeOffset);
        }
        return null;
    }

    private boolean matchletMagicCompare(int offset, byte[] data) {
        int rangeStart = this.content.getInt(offset);
        int rangeLength = this.content.getInt(offset + 4);
        int dataLength = this.content.getInt(offset + 12);
        int dataOffset = this.content.getInt(offset + 16);
        int maskOffset = this.content.getInt(offset + 20);
        for (int i = rangeStart; i <= rangeStart + rangeLength; ++i) {
            int j;
            boolean validMatch = true;
            if (i + dataLength > data.length) {
                return false;
            }
            if (maskOffset != 0) {
                for (j = 0; j < dataLength; ++j) {
                    if ((this.content.get(dataOffset + j) & this.content.get(maskOffset + j)) == (data[j + i] & this.content.get(maskOffset + j))) continue;
                    validMatch = false;
                    break;
                }
            } else {
                for (j = 0; j < dataLength; ++j) {
                    if (this.content.get(dataOffset + j) == data[j + i]) continue;
                    validMatch = false;
                    break;
                }
            }
            if (!validMatch) continue;
            return true;
        }
        return false;
    }

    private void lookupGlobLiteral(String fileName, Collection mimeTypes) {
        int listOffset = this.getLiteralListOffset();
        int numEntries = this.content.getInt(listOffset);
        int min = 0;
        int max = numEntries - 1;
        while (max >= min) {
            int mid = (min + max) / 2;
            String literal = this.getString(this.content.getInt(listOffset + 4 + 12 * mid));
            int cmp = literal.compareTo(fileName);
            if (cmp < 0) {
                min = mid + 1;
                continue;
            }
            if (cmp > 0) {
                max = mid - 1;
                continue;
            }
            String mimeType = this.getMimeType(this.content.getInt(listOffset + 4 + 12 * mid + 4));
            int weight = this.content.getInt(listOffset + 4 + 12 * mid + 8);
            mimeTypes.add(new WeightedMimeType(mimeType, literal, weight));
            return;
        }
    }

    private void lookupGlobFileNameMatch(String fileName, Collection mimeTypes) {
        int listOffset = this.getGlobListOffset();
        int numEntries = this.content.getInt(listOffset);
        for (int i = 0; i < numEntries; ++i) {
            int offset = this.content.getInt(listOffset + 4 + 12 * i);
            int mimeTypeOffset = this.content.getInt(listOffset + 4 + 12 * i + 4);
            int weight = this.content.getInt(listOffset + 4 + 12 * i + 8);
            String pattern = this.getString(offset, true);
            String mimeType = this.getMimeType(mimeTypeOffset);
            if (!fileName.matches(pattern)) continue;
            mimeTypes.add(new WeightedMimeType(mimeType, pattern, weight));
        }
    }

    private Collection normalizeWeightedMimeList(Collection weightedMimeTypes) {
        WeightedMimeType mw;
        LinkedHashSet<WeightedMimeType> mimeTypes = new LinkedHashSet<WeightedMimeType>();
        Collections.sort((List)weightedMimeTypes, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                return ((WeightedMimeType)obj1).weight - ((WeightedMimeType)obj2).weight;
            }
        });
        int weight = 0;
        int patternLen = 0;
        Iterator it = weightedMimeTypes.iterator();
        while (it.hasNext()) {
            mw = (WeightedMimeType)it.next();
            if (weight < mw.weight) {
                weight = mw.weight;
            }
            if (weight < mw.weight) continue;
            if (mw.pattern.length() > patternLen) {
                patternLen = mw.pattern.length();
            }
            mimeTypes.add(mw);
        }
        it = weightedMimeTypes.iterator();
        while (it.hasNext()) {
            mw = (WeightedMimeType)it.next();
            if (mw.pattern.length() >= patternLen) continue;
            mimeTypes.remove(mw);
        }
        HashSet _mimeTypes = new HashSet();
        Iterator it2 = mimeTypes.iterator();
        while (it2.hasNext()) {
            _mimeTypes.add(it2.next());
        }
        return _mimeTypes;
    }

    private void lookupMimeTypesForGlobFileName(File fileName, Collection mimeTypes) {
        if (fileName == null) {
            return;
        }
        this.lookupGlobLiteral(fileName.getName(), mimeTypes);
        if (!mimeTypes.isEmpty()) {
            return;
        }
        int len = fileName.getName().length();
        this.lookupGlobSuffix(fileName.getName(), false, len, mimeTypes);
        if (mimeTypes.isEmpty()) {
            this.lookupGlobSuffix(fileName.getName(), true, len, mimeTypes);
        }
        if (mimeTypes.isEmpty()) {
            this.lookupGlobFileNameMatch(fileName.getName(), mimeTypes);
        }
    }

    private void lookupGlobSuffix(String fileName, boolean ignoreCase, int len, Collection mimeTypes) {
        int listOffset = this.getReverseSuffixTreeOffset();
        int numEntries = this.content.getInt(listOffset);
        int offset = this.content.getInt(listOffset + 4);
        this.lookupGlobNodeSuffix(fileName, numEntries, offset, ignoreCase, len, mimeTypes, new StringBuffer());
    }

    private void lookupGlobNodeSuffix(String fileName, int numEntries, int offset, boolean ignoreCase, int len, Collection mimeTypes, StringBuffer pattern) {
        char character;
        char c = character = ignoreCase ? fileName.toLowerCase().charAt(len - 1) : fileName.charAt(len - 1);
        if (character == '\u0000') {
            return;
        }
        int min = 0;
        int max = numEntries - 1;
        while (max >= min && len >= 0) {
            int mid = (min + max) / 2;
            char matchChar = (char)this.content.getInt(offset + 12 * mid);
            if (matchChar < character) {
                min = mid + 1;
                continue;
            }
            if (matchChar > character) {
                max = mid - 1;
                continue;
            }
            int numChildren = this.content.getInt(offset + 12 * mid + 4);
            int childOffset = this.content.getInt(offset + 12 * mid + 8);
            if (--len > 0) {
                pattern.append(matchChar);
                this.lookupGlobNodeSuffix(fileName, numChildren, childOffset, ignoreCase, len, mimeTypes, pattern);
            }
            if (mimeTypes.isEmpty()) {
                for (int i = 0; i < numChildren && (matchChar = (char)this.content.getInt(childOffset + 12 * i)) == '\u0000'; ++i) {
                    int mimeOffset = this.content.getInt(childOffset + 12 * i + 4);
                    int weight = this.content.getInt(childOffset + 12 * i + 8);
                    mimeTypes.add(new WeightedMimeType(this.getMimeType(mimeOffset), pattern.toString(), weight));
                }
            }
            return;
        }
    }

    private int getMaxExtents() {
        return this.content.getInt(this.getMagicListOffset() + 4);
    }

    private String aliasLookup(String alias) {
        int aliasListOffset = this.getAliasListOffset();
        int min = 0;
        int max = this.content.getInt(aliasListOffset) - 1;
        while (max >= min) {
            int mid = (min + max) / 2;
            this.content.position(aliasListOffset + 4 + mid * 8);
            int aliasOffset = this.content.getInt();
            int mimeOffset = this.content.getInt();
            int cmp = this.getMimeType(aliasOffset).compareTo(alias);
            if (cmp < 0) {
                min = mid + 1;
                continue;
            }
            if (cmp > 0) {
                max = mid - 1;
                continue;
            }
            return this.getMimeType(mimeOffset);
        }
        return null;
    }

    private String unaliasMimeType(String mimeType) {
        String lookup = this.aliasLookup(mimeType);
        return lookup == null ? mimeType : lookup;
    }

    private boolean isMimeTypeSubclass(String mimeType, String subClass) {
        String umimeType = this.unaliasMimeType(mimeType);
        String usubClass = this.unaliasMimeType(subClass);
        MimeType _mimeType = new MimeType(umimeType);
        MimeType _subClass = new MimeType(usubClass);
        if (umimeType.compareTo(usubClass) == 0) {
            return true;
        }
        if (this.isSuperType(usubClass) && _mimeType.getMediaType().equals(_subClass.getMediaType())) {
            return true;
        }
        if (usubClass.equals("text/plain") && _mimeType.getMediaType().equals("text")) {
            return true;
        }
        if (usubClass.equals("application/octet-stream")) {
            return true;
        }
        int parentListOffset = this.getParentListOffset();
        int numParents = this.content.getInt(parentListOffset);
        int min = 0;
        int max = numParents - 1;
        while (max >= min) {
            int med = (min + max) / 2;
            int offset = this.content.getInt(parentListOffset + 4 + 8 * med);
            String parentMime = this.getMimeType(offset);
            int cmp = parentMime.compareTo(umimeType);
            if (cmp < 0) {
                min = med + 1;
                continue;
            }
            if (cmp > 0) {
                max = med - 1;
                continue;
            }
            offset = this.content.getInt(parentListOffset + 4 + 8 * med + 4);
            int _numParents = this.content.getInt(offset);
            for (int i = 0; i < _numParents; ++i) {
                int parentOffset = this.content.getInt(offset + 4 + 4 * i);
                if (!this.isMimeTypeSubclass(this.getMimeType(parentOffset), usubClass)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSuperType(String mimeType) {
        String type = mimeType.substring(mimeType.length() - 2);
        return type.equals("/*");
    }

    private int getGenericIconListOffset() {
        return this.content.getInt(36);
    }

    private int getIconListOffset() {
        return this.content.getInt(32);
    }

    private int getNameSpaceListOffset() {
        return this.content.getInt(28);
    }

    private int getMagicListOffset() {
        return this.content.getInt(24);
    }

    private int getGlobListOffset() {
        return this.content.getInt(20);
    }

    private int getReverseSuffixTreeOffset() {
        return this.content.getInt(16);
    }

    private int getLiteralListOffset() {
        return this.content.getInt(12);
    }

    private int getParentListOffset() {
        return this.content.getInt(8);
    }

    private int getAliasListOffset() {
        return this.content.getInt(4);
    }

    private short getMinorVersion() {
        return this.content.getShort(2);
    }

    private short getMajorVersion() {
        return this.content.getShort(0);
    }

    private String getMimeType(int offset) {
        String mimeType = this.getString(offset);
        MimeUtil.addKnownMimeType(new MimeType(mimeType));
        return mimeType;
    }

    private String getString(int offset) {
        return this.getString(offset, false);
    }

    private String getString(int offset, boolean regularExpression) {
        int position = this.content.position();
        this.content.position(offset);
        StringBuffer buf = new StringBuffer();
        char c = '\u0000';
        while ((c = (char)this.content.get()) != '\u0000') {
            if (regularExpression) {
                switch (c) {
                    case '.': {
                        buf.append("\\");
                        break;
                    }
                    case '*': 
                    case '+': 
                    case '?': {
                        buf.append(".");
                    }
                }
            }
            buf.append(c);
        }
        this.content.position(position + 4);
        if (regularExpression) {
            buf.insert(0, '^');
            buf.append('$');
        }
        return buf.toString();
    }

    public static void main(String[] args) throws Exception {
        OpendesktopMimeDetector mimeDetector = new OpendesktopMimeDetector();
        log.debug((Object)mimeDetector.dump());
        if (mimeDetector.isMimeTypeSubclass("video/x-matroska", "application/x-matroska")) {
            log.debug((Object)"video/x-matroska is a base type of application/x-matroska");
        } else {
            log.debug((Object)"video/x-matroska is NOT a base type of application/x-matroska");
        }
        if (mimeDetector.isMimeTypeSubclass("application/x-matroska", "video/x-matroska")) {
            log.debug((Object)"application/x-matroska is a base type of video/x-matroska");
        } else {
            log.debug((Object)"application/x-matroska is NOT a base type of video/x-matroska");
        }
        String fileName = "src/main/java/eu/medsea/mimeutil/detector/OpendesktopMimeDetector.java";
        Collection mimeTypes = mimeDetector.getMimeTypesFile(new File(fileName));
        Iterator it = mimeTypes.iterator();
        while (it.hasNext()) {
            System.out.println(fileName + "=" + it.next());
        }
        fileName = "target/classes/eu/medsea/mimeutil/detector/OpendesktopMimeDetector.class";
        mimeTypes = mimeDetector.getMimeTypesInputStream(new FileInputStream(fileName));
        it = mimeTypes.iterator();
        while (it.hasNext()) {
            System.out.println(fileName + "=" + it.next());
        }
        MimeUtil.addMimeDetector(mimeDetector);
        fileName = "/projects/mimeutil/src/test/resources/e-svg.img";
        mimeTypes = MimeUtil.getMimeTypes(new File(fileName));
        it = mimeTypes.iterator();
        while (it.hasNext()) {
            System.out.println(fileName + "=" + it.next());
        }
        fileName = "/projects/mimeutil/src/test/resources/f.tar.gz";
        mimeTypes = MimeUtil.getMimeTypes(new File(fileName));
        it = mimeTypes.iterator();
        while (it.hasNext()) {
            System.out.println(fileName + "=" + it.next());
        }
        byte[] data = new byte[2048];
        FileInputStream fis = new FileInputStream(fileName);
        fis.read(data, 0, 1024);
        mimeTypes = MimeUtil.getMimeTypes(data);
        Iterator it2 = mimeTypes.iterator();
        while (it2.hasNext()) {
            System.out.println(fileName + "=" + it2.next());
        }
        fileName = "/projects/mimeutil/src/test/resources/e.svg";
        mimeTypes = MimeUtil.getMimeTypes(new File(fileName));
        it2 = mimeTypes.iterator();
        while (it2.hasNext()) {
            System.out.println(fileName + "=" + it2.next());
        }
        data = new byte[1024];
        fis = new FileInputStream(fileName);
        fis.read(data, 0, 1024);
        mimeTypes = MimeUtil.getMimeTypes(data);
        it2 = mimeTypes.iterator();
        while (it2.hasNext()) {
            System.out.println(fileName + "=" + it2.next());
        }
        MimeUtil.removeMimeDetector(MimeUtil.getMimeDetector("eu.medsea.mimeutil.detector.MagicMimeMimeDetector"));
        MimeUtil.removeMimeDetector(MimeUtil.getMimeDetector("eu.medsea.mimeutil.detector.ExtensionMimeDetector"));
        mimeTypes = MimeUtil.getMimeTypes(new File(fileName));
        it2 = mimeTypes.iterator();
        while (it2.hasNext()) {
            System.out.println(fileName + "=" + it2.next());
        }
        data = new byte[1024];
        fis = new FileInputStream(fileName);
        fis.read(data, 0, 1024);
        mimeTypes = MimeUtil.getMimeTypes(data);
        it2 = mimeTypes.iterator();
        while (it2.hasNext()) {
            System.out.println(fileName + "=" + it2.next());
        }
        mimeTypes = MimeUtil.getMimeTypes(new File(fileName).toURL().openConnection());
        it2 = mimeTypes.iterator();
        while (it2.hasNext()) {
            System.out.println(fileName + "=" + it2.next());
        }
        mimeTypes = MimeUtil.getMimeTypes(new BufferedInputStream(new FileInputStream(fileName)));
        it2 = mimeTypes.iterator();
        while (it2.hasNext()) {
            System.out.println(fileName + "=" + it2.next());
        }
    }

    static {
        MimeUtil.addMimeDetector(new OpendesktopMimeDetector());
    }

    class WeightedMimeType
    extends MimeType {
        String pattern;
        int weight;

        WeightedMimeType(String mimeType, String pattern, int weight) {
            super(mimeType);
            this.pattern = pattern;
            this.weight = weight;
        }
    }
}

