/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.xmlschema;

import org.rhq.enterprise.server.xmlschema.CronScheduleType;
import org.rhq.enterprise.server.xmlschema.PeriodicScheduleType;

public abstract class AbstractScheduleType {
    private final String typeName;
    private final boolean concurrent;
    private final boolean clustered;

    public static final AbstractScheduleType create(boolean concurrent, boolean clustered, String scheduleType, String scheduleTrigger) {
        AbstractScheduleType scheduleTypeObj = null;
        if ("periodic".equalsIgnoreCase(scheduleType)) {
            scheduleTypeObj = new PeriodicScheduleType(concurrent, clustered, Long.parseLong(scheduleTrigger));
        } else if ("cron".equalsIgnoreCase(scheduleType)) {
            scheduleTypeObj = new CronScheduleType(concurrent, clustered, scheduleTrigger);
        }
        return scheduleTypeObj;
    }

    public AbstractScheduleType(boolean concurrent, boolean clustered, String typeName) {
        this.typeName = typeName;
        this.concurrent = concurrent;
        this.clustered = clustered;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isConcurrent() {
        return this.concurrent;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public abstract String getScheduleTrigger();
}

