/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.xmlschema;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.rhq.core.clientapi.agent.metadata.ConfigurationMetadataParser;
import org.rhq.core.clientapi.agent.metadata.InvalidPluginDescriptorException;
import org.rhq.core.clientapi.descriptor.configuration.ConfigurationDescriptor;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.enterprise.server.xmlschema.AbstractScheduleType;
import org.rhq.enterprise.server.xmlschema.ControlDefinition;
import org.rhq.enterprise.server.xmlschema.ScheduledJobDefinition;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.ControlType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.ServerPluginComponentType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.ServerPluginDescriptorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerPluginDescriptorMetadataParser {
    private static final String SCHEDULED_JOB_PROP_NAME_ENABLED = "enabled";
    private static final String SCHEDULED_JOB_PROP_NAME_CLASS = "class";
    private static final String SCHEDULED_JOB_PROP_NAME_METHOD_NAME = "methodName";
    private static final String SCHEDULED_JOB_PROP_NAME_CONCURRENT = "concurrent";
    private static final String SCHEDULED_JOB_PROP_NAME_CLUSTERED = "clustered";
    private static final String SCHEDULED_JOB_PROP_NAME_SCHEDULE_TYPE = "scheduleType";
    private static final String SCHEDULED_JOB_PROP_NAME_SCHEDULE_TRIGGER = "scheduleTrigger";

    public static String getPluginComponentClassName(ServerPluginDescriptorType descriptor) {
        ServerPluginComponentType componentXml = descriptor.getPluginComponent();
        if (componentXml == null) {
            return null;
        }
        String className = componentXml.getClazz();
        if (className == null) {
            throw new IllegalArgumentException("Missing plugin component classname for plugin " + descriptor.getName());
        }
        className = ServerPluginDescriptorMetadataParser.getFullyQualifiedClassName(descriptor, className);
        return className;
    }

    public static String getFullyQualifiedClassName(ServerPluginDescriptorType descriptor, String className) {
        if (className != null) {
            String pkg;
            String string = pkg = descriptor != null ? descriptor.getPackage() : null;
            if (className.indexOf(46) == -1 && pkg != null) {
                className = pkg + '.' + className;
            }
        }
        return className;
    }

    public static List<ControlDefinition> getControlDefinitions(ServerPluginDescriptorType descriptor) throws Exception {
        List<ControlType> descriptorDefs;
        ArrayList<ControlDefinition> defs = new ArrayList<ControlDefinition>();
        if (descriptor.getPluginComponent() != null && (descriptorDefs = descriptor.getPluginComponent().getControl()) != null && descriptorDefs.size() > 0) {
            for (ControlType descriptorDef : descriptorDefs) {
                String name = descriptorDef.getName();
                String displayName = descriptorDef.getDisplayName();
                String description = descriptorDef.getDescription();
                ConfigurationDefinition params = null;
                ConfigurationDefinition results = null;
                ConfigurationDescriptor xml = descriptorDef.getParameters();
                if (xml != null) {
                    params = ConfigurationMetadataParser.parse((String)(descriptorDef.getName() + "_params"), (ConfigurationDescriptor)xml);
                }
                if ((xml = descriptorDef.getResults()) != null) {
                    results = ConfigurationMetadataParser.parse((String)(descriptorDef.getName() + "_results"), (ConfigurationDescriptor)xml);
                }
                ControlDefinition def = new ControlDefinition(name, displayName, description, params, results);
                defs.add(def);
            }
        }
        return defs;
    }

    public static ConfigurationDefinition getPluginConfigurationDefinition(ServerPluginDescriptorType descriptor) throws Exception {
        ConfigurationDefinition config = null;
        ConfigurationDescriptor configXml = descriptor.getPluginConfiguration();
        if (configXml != null) {
            config = ConfigurationMetadataParser.parse((String)descriptor.getName(), (ConfigurationDescriptor)configXml);
        }
        return config;
    }

    public static ConfigurationDefinition getScheduledJobsDefinition(ServerPluginDescriptorType descriptor) throws Exception {
        ConfigurationDefinition config = null;
        ConfigurationDescriptor configXml = descriptor.getScheduledJobs();
        if (configXml != null) {
            config = ConfigurationMetadataParser.parse((String)descriptor.getName(), (ConfigurationDescriptor)configXml);
        }
        return config;
    }

    public static List<ScheduledJobDefinition> getScheduledJobs(ServerPluginDescriptorType descriptor) throws Exception {
        ArrayList<ScheduledJobDefinition> jobs = new ArrayList<ScheduledJobDefinition>();
        ConfigurationDescriptor configXml = descriptor.getScheduledJobs();
        if (configXml != null) {
            ConfigurationDefinition config = ConfigurationMetadataParser.parse((String)descriptor.getName(), (ConfigurationDescriptor)configXml);
            for (PropertyDefinition propDef : config.getPropertyDefinitions().values()) {
                ScheduledJobDefinition jobDef = ServerPluginDescriptorMetadataParser.getScheduledJob(propDef);
                if (jobDef == null) continue;
                jobs.add(jobDef);
            }
        }
        return jobs;
    }

    private static ScheduledJobDefinition getScheduledJob(PropertyDefinition mapDef) throws Exception {
        ScheduledJobDefinition job = null;
        if (mapDef instanceof PropertyDefinitionMap) {
            boolean clustered;
            PropertyDefinitionMap jobMapDef = (PropertyDefinitionMap)mapDef;
            ConfigurationTemplate defaultTemplate = jobMapDef.getConfigurationDefinition().getDefaultTemplate();
            PropertyMap defaults = defaultTemplate.getConfiguration().getMap(mapDef.getName());
            String methodName = defaults.getSimpleValue(SCHEDULED_JOB_PROP_NAME_METHOD_NAME, mapDef.getName());
            String className = defaults.getSimpleValue(SCHEDULED_JOB_PROP_NAME_CLASS, null);
            String enabledStr = defaults.getSimpleValue(SCHEDULED_JOB_PROP_NAME_ENABLED, "true");
            String concurrentStr = defaults.getSimpleValue(SCHEDULED_JOB_PROP_NAME_CONCURRENT, "false");
            String clusteredStr = defaults.getSimpleValue(SCHEDULED_JOB_PROP_NAME_CLUSTERED, "true");
            String scheduleTypeStr = defaults.getSimpleValue(SCHEDULED_JOB_PROP_NAME_SCHEDULE_TYPE, "periodic");
            String scheduleTriggerStr = defaults.getSimpleValue(SCHEDULED_JOB_PROP_NAME_SCHEDULE_TRIGGER, "600000");
            String jobId = jobMapDef.getName();
            boolean enabled = Boolean.parseBoolean(enabledStr);
            boolean concurrent = Boolean.parseBoolean(concurrentStr);
            AbstractScheduleType scheduleType = AbstractScheduleType.create(concurrent, clustered = Boolean.parseBoolean(clusteredStr), scheduleTypeStr, scheduleTriggerStr);
            if (scheduleType == null) {
                throw new InvalidPluginDescriptorException("Invalid schedule type: " + scheduleTypeStr);
            }
            Properties callbackData = new Properties();
            Map allPropDefs = jobMapDef.getPropertyDefinitions();
            for (PropertyDefinition currentPropDef : allPropDefs.values()) {
                if (!(currentPropDef instanceof PropertyDefinitionSimple)) continue;
                String currentPropDefName = currentPropDef.getName();
                callbackData.setProperty(currentPropDefName, defaults.getSimpleValue(currentPropDefName, null));
            }
            job = new ScheduledJobDefinition(jobId, enabled, className, methodName, scheduleType, callbackData);
        } else if (!(mapDef instanceof PropertyDefinitionList)) {
            throw new Exception("Invalid scheduled job definition [" + mapDef.getName() + "]");
        }
        return job;
    }

    public static List<ScheduledJobDefinition> getScheduledJobs(Configuration scheduledJobsConfig) throws Exception {
        ArrayList<ScheduledJobDefinition> jobs = new ArrayList<ScheduledJobDefinition>();
        if (scheduledJobsConfig != null) {
            for (Property prop : scheduledJobsConfig.getProperties()) {
                ScheduledJobDefinition jobDef = ServerPluginDescriptorMetadataParser.getScheduledJob(prop);
                if (jobDef != null) {
                    jobs.add(jobDef);
                    continue;
                }
                if (!(prop instanceof PropertyList)) continue;
                PropertyList listOfJobs = (PropertyList)prop;
                for (Property listItem : listOfJobs.getList()) {
                    jobDef = ServerPluginDescriptorMetadataParser.getScheduledJob(listItem);
                    if (jobDef == null) continue;
                    jobs.add(jobDef);
                }
            }
        }
        return jobs;
    }

    private static ScheduledJobDefinition getScheduledJob(Property map) throws Exception {
        ScheduledJobDefinition job = null;
        if (map instanceof PropertyMap) {
            boolean clustered;
            PropertyMap jobMap = (PropertyMap)map;
            String methodName = jobMap.getSimpleValue(SCHEDULED_JOB_PROP_NAME_METHOD_NAME, jobMap.getName());
            String className = jobMap.getSimpleValue(SCHEDULED_JOB_PROP_NAME_CLASS, null);
            String enabledStr = jobMap.getSimpleValue(SCHEDULED_JOB_PROP_NAME_ENABLED, "true");
            String concurrentStr = jobMap.getSimpleValue(SCHEDULED_JOB_PROP_NAME_CONCURRENT, "false");
            String clusteredStr = jobMap.getSimpleValue(SCHEDULED_JOB_PROP_NAME_CLUSTERED, "true");
            String scheduleTypeStr = jobMap.getSimpleValue(SCHEDULED_JOB_PROP_NAME_SCHEDULE_TYPE, "periodic");
            String scheduleTriggerStr = jobMap.getSimpleValue(SCHEDULED_JOB_PROP_NAME_SCHEDULE_TRIGGER, "600000");
            String jobId = jobMap.getName();
            boolean enabled = Boolean.parseBoolean(enabledStr);
            boolean concurrent = Boolean.parseBoolean(concurrentStr);
            AbstractScheduleType scheduleType = AbstractScheduleType.create(concurrent, clustered = Boolean.parseBoolean(clusteredStr), scheduleTypeStr, scheduleTriggerStr);
            if (scheduleType == null) {
                throw new InvalidPluginDescriptorException("Invalid schedule type: " + scheduleTypeStr);
            }
            Properties callbackData = new Properties();
            Map allProps = jobMap.getMap();
            for (Property currentProp : allProps.values()) {
                if (!(currentProp instanceof PropertySimple)) continue;
                String currentPropName = currentProp.getName();
                callbackData.setProperty(currentPropName, jobMap.getSimpleValue(currentPropName, null));
            }
            job = new ScheduledJobDefinition(jobId, enabled, className, methodName, scheduleType, callbackData);
        }
        return job;
    }
}

