/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.iis.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.win32.Service;
import org.hyperic.sigar.win32.Win32Exception;
import org.rhq.core.domain.measurement.AvailabilityType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Win32ServiceControlDelegate {
    private Log log = LogFactory.getLog(Win32ServiceControlDelegate.class);
    private String serviceName;
    private List<String> dependencies;
    private List<String> reverseDependencies;
    private List<String> dependents;
    private List<String> reverseDependents;
    private Service service;
    private long timeout;

    public Win32ServiceControlDelegate(String serviceName, long timeout) throws Win32Exception {
        this(serviceName, null, null, timeout);
    }

    public Win32ServiceControlDelegate(String serviceName, List<String> dependencies, List<String> dependents, long timeout) throws Win32Exception {
        this.log.debug((Object)("serviceName = " + serviceName));
        this.log.debug((Object)("serviceDependencies = " + (dependencies == null ? "none" : dependencies)));
        this.log.debug((Object)("serviceDependents = " + (dependents == null ? "none" : dependents)));
        this.log.debug((Object)("serviceOperationTimeout = " + timeout + " ms"));
        this.serviceName = serviceName;
        this.dependencies = dependencies;
        if (dependencies != null) {
            this.reverseDependencies = new ArrayList<String>(dependencies);
            Collections.reverse(this.reverseDependencies);
        }
        this.dependents = dependents;
        if (dependents != null) {
            this.reverseDependents = new ArrayList<String>(dependents);
            Collections.reverse(this.dependents);
        }
        this.timeout = timeout;
        this.service = new Service(serviceName);
    }

    public AvailabilityType getAvailabilityType() {
        return this.getAvailability(this.service);
    }

    public void start() throws Win32Exception {
        this.startServices(this.dependencies);
        this.service.start();
        this.startServices(this.dependents);
    }

    public void stop() throws Win32Exception {
        this.stopServices(this.reverseDependents);
        this.service.stop();
        this.stopServices(this.reverseDependencies);
    }

    public void restart() throws Win32Exception {
        this.stop();
        this.start();
    }

    protected void startServices(List<String> services) {
        if (services == null) {
            return;
        }
        this.log.debug((Object)("Starting list of services for Service [" + this.serviceName + "], services [" + services + "]"));
        for (String relatedServiceName : services) {
            try {
                Service relatedService = new Service(relatedServiceName);
                int relatedServiceStatus = relatedService.getStatus();
                if (relatedServiceStatus != 1 && relatedServiceStatus != 3) continue;
                this.log.debug((Object)("Starting Service [" + relatedServiceName + "]"));
                relatedService.start(this.timeout);
                this.log.debug((Object)("Service started [" + relatedServiceName + "]"));
                relatedService.close();
            }
            catch (Exception e) {
                this.log.warn((Object)("Unable to start [" + relatedServiceName + "] from the list [" + services + "]. Will continue with the rest. Cause:" + e));
            }
        }
    }

    protected void stopServices(List<String> services) {
        if (services == null) {
            return;
        }
        this.log.debug((Object)("Stopping list of services for Service [" + this.serviceName + "], services [" + services + "]"));
        for (String relatedServiceName : services) {
            try {
                Service relatedService = new Service(relatedServiceName);
                int relatedServiceStatus = relatedService.getStatus();
                if (relatedServiceStatus == 1 || relatedServiceStatus == 3) continue;
                this.log.debug((Object)("Stopping Service [" + relatedServiceName + "]"));
                relatedService.stop(this.timeout);
                this.log.debug((Object)("Service stopped [" + relatedServiceName + "]"));
                relatedService.close();
            }
            catch (Exception e) {
                this.log.warn((Object)("Unable to stop [" + relatedServiceName + "] from the list [" + services + "]. Will continue with the rest. Cause:" + e));
            }
        }
    }

    protected AvailabilityType getAvailability(Service service) {
        switch (service.getStatus()) {
            case 2: 
            case 3: 
            case 4: {
                return AvailabilityType.UP;
            }
        }
        return AvailabilityType.DOWN;
    }
}

