/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationHandler;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.remoting.Proxy;
import org.jboss.logging.Logger;

public abstract class LocalProxy
implements InvocationHandler,
Externalizable,
Proxy {
    private static Logger log = Logger.getLogger(LocalProxy.class);
    private transient Container container = null;
    protected String containerClusterUid;
    protected String containerGuid;
    protected String proxyName;

    public LocalProxy() {
    }

    public LocalProxy(Container container) {
        this.container = container;
        this.containerGuid = Ejb3Registry.guid(container);
        this.containerClusterUid = Ejb3Registry.clusterUid(container);
        this.proxyName = container.getEjbName();
    }

    protected Container getContainer() {
        if (this.container == null) {
            this.container = Ejb3Registry.findContainer(this.containerGuid);
        }
        if (this.container == null) {
            log.warn((Object)("Container " + this.containerGuid + " is not yet available"));
        }
        return this.container;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.containerGuid = in.readUTF();
        this.containerClusterUid = in.readUTF();
        this.proxyName = in.readUTF();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.containerGuid);
        out.writeUTF(this.containerClusterUid);
        out.writeUTF(this.proxyName);
    }

    public abstract String toString();
}

