/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;

public class NonSerializableFactory
implements ObjectFactory {
    private static Map wrapperMap = Collections.synchronizedMap(new HashMap());
    private static final Logger log = Logger.getLogger(NonSerializableFactory.class);

    public static void unbind(Context ctx, String strName) throws NamingException {
        Name name = ctx.getNameParser("").parse(strName);
        int size = name.size();
        String atom = name.get(size - 1);
        Context parentCtx = Util.createSubcontext((Context)ctx, (Name)name.getPrefix(size - 1));
        String key = parentCtx.getNameInNamespace() + "/" + atom;
        wrapperMap.remove(key);
        Util.unbind((Context)ctx, (String)strName);
    }

    public static void rebind(Context ctx, String strName, Object value) throws NamingException {
        Name name = ctx.getNameParser("").parse(strName);
        int size = name.size();
        String atom = name.get(size - 1);
        Context parentCtx = Util.createSubcontext((Context)ctx, (Name)name.getPrefix(size - 1));
        String key = parentCtx.getNameInNamespace() + "/" + atom;
        wrapperMap.put(key, value);
        String className = value.getClass().getName();
        String factory = NonSerializableFactory.class.getName();
        StringRefAddr addr = new StringRefAddr("nns", key);
        Reference memoryRef = new Reference(className, addr, factory, null);
        parentCtx.rebind(atom, (Object)memoryRef);
    }

    public static void bind(Context ctx, String strName, Object value) throws NamingException {
        Name name = ctx.getNameParser("").parse(strName);
        int size = name.size();
        String atom = name.get(size - 1);
        Context parentCtx = Util.createSubcontext((Context)ctx, (Name)name.getPrefix(size - 1));
        String key = parentCtx.getNameInNamespace() + "/" + atom;
        wrapperMap.put(key, value);
        String className = value.getClass().getName();
        String factory = NonSerializableFactory.class.getName();
        StringRefAddr addr = new StringRefAddr("nns", key);
        Reference memoryRef = new Reference(className, addr, factory, null);
        parentCtx.bind(atom, (Object)memoryRef);
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env) throws Exception {
        Reference ref = (Reference)obj;
        RefAddr addr = ref.get("nns");
        String key = (String)addr.getContent();
        Object o = wrapperMap.get(key);
        return o;
    }
}

