/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.InfinitePool;
import org.jboss.ejb3.Pool;
import org.jboss.injection.Injector;
import org.jboss.lang.ref.WeakThreadLocal;
import org.jboss.logging.Logger;

public class ThreadlocalPool
implements Pool {
    private static final Logger log = Logger.getLogger(ThreadlocalPool.class);
    protected Pool pool = new InfinitePool();
    protected WeakThreadLocal<BeanContext> currentBeanContext = new WeakThreadLocal();
    private int inUse = 0;
    private int maxSize = 30;

    protected BeanContext create() {
        return this.pool.get();
    }

    protected BeanContext create(Class[] initTypes, Object[] initValues) {
        return this.pool.get(initTypes, initValues);
    }

    public void discard(BeanContext obj) {
        this.pool.discard(obj);
        --this.inUse;
    }

    public void destroy() {
        log.trace((Object)"destroying pool");
        this.pool.destroy();
        this.currentBeanContext.remove();
        this.inUse = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanContext get() {
        BeanContext ctx = null;
        Pool pool = this.pool;
        synchronized (pool) {
            ctx = this.currentBeanContext.get();
            if (ctx != null) {
                this.currentBeanContext.set(null);
                ++this.inUse;
                return ctx;
            }
            ctx = this.create();
            ++this.inUse;
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanContext get(Class[] initTypes, Object[] initValues) {
        BeanContext ctx = null;
        Pool pool = this.pool;
        synchronized (pool) {
            ctx = this.currentBeanContext.get();
            if (ctx != null) {
                this.currentBeanContext.set(null);
                ++this.inUse;
                return ctx;
            }
            ctx = this.create(initTypes, initValues);
            ++this.inUse;
        }
        return ctx;
    }

    public void initialize(Container container, Class contextClass, Class beanClass, int maxSize, long timeout) {
        this.pool.initialize(container, contextClass, beanClass, maxSize, timeout);
        this.maxSize = maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(BeanContext ctx) {
        Pool pool = this.pool;
        synchronized (pool) {
            if (this.currentBeanContext.get() != null) {
                this.remove(ctx);
            } else {
                this.currentBeanContext.set(ctx);
            }
            --this.inUse;
        }
    }

    public void remove(BeanContext ctx) {
        this.pool.remove(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentSize() {
        int size;
        Pool pool = this.pool;
        synchronized (pool) {
            size = this.pool.getCreateCount() - this.pool.getRemoveCount();
        }
        return size;
    }

    public int getAvailableCount() {
        return this.maxSize - this.inUse;
    }

    public int getCreateCount() {
        return this.pool.getCreateCount();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getRemoveCount() {
        return this.pool.getRemoveCount();
    }

    public void setInjectors(Injector[] injectors) {
        this.pool.setInjectors(injectors);
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }
}

