/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.security;

import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityAssociation;

class SecurityActions {
    SecurityActions() {
    }

    static Subject getContextSubject() throws PolicyContextException {
        if (System.getSecurityManager() == null) {
            return PolicyContextActions.NON_PRIVILEGED.getContextSubject();
        }
        return PolicyContextActions.PRIVILEGED.getContextSubject();
    }

    static String setContextID(String contextID) {
        SetContextID action = new SetContextID(contextID);
        String previousID = (String)AccessController.doPrivileged(action);
        return previousID;
    }

    static RunAsIdentity peekRunAsIdentity() {
        if (System.getSecurityManager() == null) {
            return RunAsIdentityActions.NON_PRIVILEGED.peek();
        }
        return RunAsIdentityActions.PRIVILEGED.peek();
    }

    static void pushRunAsIdentity(RunAsIdentity principal) {
        if (System.getSecurityManager() == null) {
            RunAsIdentityActions.NON_PRIVILEGED.push(principal);
        } else {
            RunAsIdentityActions.PRIVILEGED.push(principal);
        }
    }

    static RunAsIdentity popRunAsIdentity() {
        if (System.getSecurityManager() == null) {
            return RunAsIdentityActions.NON_PRIVILEGED.pop();
        }
        return RunAsIdentityActions.PRIVILEGED.pop();
    }

    static Principal getCallerPrincipal() {
        return (Principal)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return SecurityAssociation.getCallerPrincipal();
            }
        });
    }

    static interface RunAsIdentityActions {
        public static final RunAsIdentityActions PRIVILEGED = new RunAsIdentityActions(){
            private final PrivilegedAction peekAction = new PrivilegedAction(){

                public Object run() {
                    return SecurityAssociation.peekRunAsIdentity();
                }
            };
            private final PrivilegedAction popAction = new PrivilegedAction(){

                public Object run() {
                    return SecurityAssociation.popRunAsIdentity();
                }
            };

            public RunAsIdentity peek() {
                return (RunAsIdentity)AccessController.doPrivileged(this.peekAction);
            }

            public void push(final RunAsIdentity id) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        SecurityAssociation.pushRunAsIdentity((RunAsIdentity)id);
                        return null;
                    }
                });
            }

            public RunAsIdentity pop() {
                return (RunAsIdentity)AccessController.doPrivileged(this.popAction);
            }
        };
        public static final RunAsIdentityActions NON_PRIVILEGED = new RunAsIdentityActions(){

            public RunAsIdentity peek() {
                return SecurityAssociation.peekRunAsIdentity();
            }

            public void push(RunAsIdentity id) {
                SecurityAssociation.pushRunAsIdentity((RunAsIdentity)id);
            }

            public RunAsIdentity pop() {
                return SecurityAssociation.popRunAsIdentity();
            }
        };

        public RunAsIdentity peek();

        public void push(RunAsIdentity var1);

        public RunAsIdentity pop();
    }

    static interface PolicyContextActions {
        public static final String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";
        public static final PolicyContextActions PRIVILEGED = new PolicyContextActions(){
            private final PrivilegedExceptionAction exAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return (Subject)PolicyContext.getContext((String)PolicyContextActions.SUBJECT_CONTEXT_KEY);
                }
            };

            public Subject getContextSubject() throws PolicyContextException {
                try {
                    return (Subject)AccessController.doPrivileged(this.exAction);
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof PolicyContextException) {
                        throw (PolicyContextException)((Object)ex);
                    }
                    throw new UndeclaredThrowableException(ex);
                }
            }
        };
        public static final PolicyContextActions NON_PRIVILEGED = new PolicyContextActions(){

            public Subject getContextSubject() throws PolicyContextException {
                return (Subject)PolicyContext.getContext((String)PolicyContextActions.SUBJECT_CONTEXT_KEY);
            }
        };

        public Subject getContextSubject() throws PolicyContextException;
    }

    private static class SetContextID
    implements PrivilegedAction {
        String contextID;

        SetContextID(String contextID) {
            this.contextID = contextID;
        }

        public Object run() {
            String previousID = PolicyContext.getContextID();
            PolicyContext.setContextID((String)this.contextID);
            return previousID;
        }
    }
}

