/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateless;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import javax.ejb.RemoteHome;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.annotation.ejb.RemoteBinding;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.JBossProxy;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.remoting.RemoteProxyFactory;
import org.jboss.ejb3.stateless.BaseStatelessProxyFactory;
import org.jboss.ejb3.stateless.StatelessContainer;
import org.jboss.ejb3.stateless.StatelessHandleImpl;
import org.jboss.ejb3.stateless.StatelessRemoteProxy;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;
import org.jboss.remoting.InvokerLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatelessRemoteProxyFactory
extends BaseStatelessProxyFactory
implements RemoteProxyFactory {
    private static final Logger log = Logger.getLogger(StatelessRemoteProxyFactory.class);
    protected RemoteBinding binding;
    protected InvokerLocator locator;

    @Override
    public void setRemoteBinding(RemoteBinding binding) {
        this.binding = binding;
    }

    protected Class<?>[] getInterfaces() {
        StatelessContainer statelessContainer = (StatelessContainer)this.getContainer();
        RemoteHome remoteHome = (RemoteHome)statelessContainer.resolveAnnotation(RemoteHome.class);
        boolean bindTogether = false;
        if (remoteHome != null && this.bindHomeAndBusinessTogether(statelessContainer)) {
            bindTogether = true;
        }
        ArrayList<Class> remoteInterfaces = new ArrayList<Class>();
        remoteInterfaces.addAll(Arrays.asList(ProxyFactoryHelper.getRemoteInterfaces(statelessContainer)));
        if (remoteInterfaces.size() > 0) {
            remoteInterfaces.add(JBossProxy.class);
            if (bindTogether) {
                remoteInterfaces.add(remoteHome.value());
            }
        } else {
            log.warn((Object)"[EJBTHREE-933] NPE when deploying web service beans");
        }
        return remoteInterfaces.toArray(new Class[0]);
    }

    protected boolean bindHomeAndBusinessTogether(EJBContainer container) {
        return ProxyFactoryHelper.getHomeJndiName(container).equals(ProxyFactoryHelper.getRemoteJndiName(container));
    }

    @Override
    protected void initializeJndiName() {
        this.jndiName = ProxyFactoryHelper.getRemoteJndiName(this.getContainer(), this.binding);
    }

    @Override
    public void init() throws Exception {
        super.init();
        String clientBindUrl = ProxyFactoryHelper.getClientBindUrl(this.binding);
        this.locator = new InvokerLocator(clientBindUrl);
    }

    @Override
    public void start() throws Exception {
        super.start();
        EJBContainer statelessContainer = (EJBContainer)this.getContainer();
        RemoteHome remoteHome = (RemoteHome)statelessContainer.resolveAnnotation(RemoteHome.class);
        if (remoteHome != null && !this.bindHomeAndBusinessTogether(statelessContainer)) {
            Object homeProxy = this.createHomeProxy(remoteHome.value());
            try {
                Util.rebind((Context)this.getContainer().getInitialContext(), (String)ProxyFactoryHelper.getHomeJndiName(this.getContainer()), (Object)homeProxy);
            }
            catch (NamingException e) {
                NamingException namingException = new NamingException("Could not bind stateless home proxy with ejb name " + this.getContainer().getEjbName() + " into JNDI under jndiName: " + this.getContainer().getInitialContext().getNameInNamespace() + "/" + ProxyFactoryHelper.getHomeJndiName(this.getContainer()));
                namingException.setRootCause(e);
                throw namingException;
            }
        }
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        EJBContainer statelessContainer = (EJBContainer)this.getContainer();
        RemoteHome remoteHome = (RemoteHome)statelessContainer.resolveAnnotation(RemoteHome.class);
        if (remoteHome != null && !this.bindHomeAndBusinessTogether(statelessContainer)) {
            Util.unbind((Context)this.getContainer().getInitialContext(), (String)ProxyFactoryHelper.getHomeJndiName(this.getContainer()));
        }
    }

    @Override
    protected StatelessHandleImpl getHandle() {
        StatelessHandleImpl handle = new StatelessHandleImpl();
        RemoteBinding remoteBinding = (RemoteBinding)((Advisor)this.getContainer()).resolveAnnotation(RemoteBinding.class);
        if (remoteBinding != null) {
            handle.jndiName = remoteBinding.jndiBinding();
        }
        return handle;
    }

    public Object createHomeProxy(Class homeInterface) {
        try {
            String stackName = "StatelessSessionClientInterceptors";
            if (this.binding.interceptorStack() != null && !this.binding.interceptorStack().equals("")) {
                stackName = this.binding.interceptorStack();
            }
            AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
            StatelessRemoteProxy proxy = new StatelessRemoteProxy(this.getContainer(), stack.createInterceptors((Advisor)this.getContainer(), null), this.locator);
            this.setEjb21Objects(proxy);
            Class[] interfaces = new Class[]{homeInterface};
            return Proxy.newProxyInstance(this.getContainer().getBeanClass().getClassLoader(), interfaces, (InvocationHandler)proxy);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object createProxy() {
        String stackName = "StatelessSessionClientInterceptors";
        if (this.binding.interceptorStack() != null && !this.binding.interceptorStack().equals("")) {
            stackName = this.binding.interceptorStack();
        }
        AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
        StatelessRemoteProxy proxy = new StatelessRemoteProxy(this.getContainer(), stack.createInterceptors((Advisor)this.getContainer(), null), this.locator);
        this.setEjb21Objects(proxy);
        return this.constructProxy(proxy);
    }
}

