/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.DefaultResponseHandler;
import com.bradmcevoy.http.ResourceFactory;
import com.bradmcevoy.http.ResourceFactoryFactory;
import com.bradmcevoy.http.ResponseHandler;
import com.bradmcevoy.http.ServletHttpManager;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractMiltonEndPoint {
    private Logger log = LoggerFactory.getLogger(AbstractMiltonEndPoint.class);
    protected ServletHttpManager httpManager;

    protected void init(String resourceFactoryClassName, String notFoundPath, String responseHandlerClassName) throws ServletException {
        this.log.debug("resourceFactoryClassName: " + resourceFactoryClassName);
        ResourceFactory rf = (ResourceFactory)this.instantiate(resourceFactoryClassName);
        Object responseHandler = responseHandlerClassName == null ? new DefaultResponseHandler() : (ResponseHandler)this.instantiate(responseHandlerClassName);
        this.init(rf, (ResponseHandler)responseHandler, notFoundPath);
    }

    protected void initFromFactoryFactory(String resourceFactoryFactoryClassName, String notFoundPath) throws ServletException {
        this.log.debug("resourceFactoryFactoryClassName: " + resourceFactoryFactoryClassName);
        ResourceFactoryFactory rff = (ResourceFactoryFactory)this.instantiate(resourceFactoryFactoryClassName);
        rff.init();
        ResourceFactory rf = rff.createResourceFactory();
        ResponseHandler responseHandler = rff.createResponseHandler();
        this.init(rf, responseHandler, notFoundPath);
    }

    protected void init(ResourceFactory rf, ResponseHandler responseHandler, String notFoundPath) {
        this.httpManager = new ServletHttpManager(rf, notFoundPath, responseHandler);
    }

    protected <T> T instantiate(String className) throws ServletException {
        try {
            Class<?> c = Class.forName(className);
            Object rf = c.newInstance();
            return (T)rf;
        }
        catch (Throwable ex) {
            throw new ServletException("Failed to instantiate: " + className, ex);
        }
    }

    public void destroy() {
        this.log.debug("destroy");
        if (this.httpManager == null) {
            return;
        }
        this.httpManager.destroy(this.httpManager);
    }
}

