/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.test;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.rhq.test.MatchResult;
import org.rhq.test.PropertyMatchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyMatcher<T> {
    private T expected;
    private T actual;
    private Set<String> ignoredProperties = new HashSet<String>();

    public void setExpected(T expected) {
        this.expected = expected;
    }

    public void setActual(T actual) {
        this.actual = actual;
    }

    public void setIgnoredProperties(Collection<String> ignoredProperties) {
        this.ignoredProperties.addAll(ignoredProperties);
    }

    public MatchResult execute() {
        try {
            Map expectedProps = PropertyUtils.describe(this.expected);
            Map actualProps = PropertyUtils.describe(this.actual);
            boolean isMatch = true;
            StringBuilder details = new StringBuilder(this.expected.getClass().getSimpleName() + " objects do not match:\n");
            for (String name : expectedProps.keySet()) {
                Object expectedValue = expectedProps.get(name);
                Object actualValue = actualProps.get(name);
                if (this.ignoredProperties.contains(name) || this.propertyEquals(expectedValue, actualValue)) continue;
                isMatch = false;
                details.append("expected." + name + " = " + expectedValue + "\n");
                details.append("actual." + name + " = " + actualValue + "\n\n");
            }
            return new MatchResult(isMatch, details.toString());
        }
        catch (IllegalAccessException e) {
            throw new PropertyMatchException(e);
        }
        catch (InvocationTargetException e) {
            throw new PropertyMatchException(e);
        }
        catch (NoSuchMethodException e) {
            throw new PropertyMatchException(e);
        }
    }

    private boolean propertyEquals(Object expected, Object actual) {
        if (expected == null && actual == null) {
            return true;
        }
        if (expected == null && actual != null) {
            return false;
        }
        return expected.equals(actual);
    }
}

