/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertOperations;

import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.notification.SenderResult;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.operation.JobId;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.operation.OperationRequestStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.server.operation.ResourceOperationSchedule;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSender;
import org.rhq.enterprise.server.plugins.alertOperations.AlertTokenReplacer;
import org.rhq.enterprise.server.plugins.alertOperations.OperationInfo;
import org.rhq.enterprise.server.util.LookupUtil;

public class OperationsSender
extends AlertSender {
    private static final String URL_RESOURCE_OPERATION_HISTORY = "/rhq/resource/operation/resourceOperationHistory.xhtml";
    private static final String URL_RESOURCE_OPERATION_HISTORY_DETAILS = "/rhq/resource/operation/resourceOperationHistoryDetails.xhtml";

    public SenderResult send(Alert alert) {
        OperationInfo info = OperationInfo.load(this.alertParameters, this.extraParameters);
        if (info.error != null) {
            return SenderResult.getSimpleFailure((String)info.error);
        }
        Subject subject = LookupUtil.getSubjectManager().getOverlord();
        OperationDefinition operation = info.getOperationDefinition();
        Configuration parameters = info.getArguments();
        Resource targetResource = null;
        try {
            targetResource = info.getTargetResource(alert);
        }
        catch (Throwable t) {
            String message = this.getResultMessage(info, "could not calculate which resources to execute the operation on: " + t.getMessage());
            return SenderResult.getSimpleFailure((String)message);
        }
        Configuration replacedParameters = null;
        try {
            if (parameters != null) {
                replacedParameters = parameters.deepCopy(false);
                AlertTokenReplacer replacementEngine = new AlertTokenReplacer(alert, operation, targetResource);
                for (PropertySimple simpleProperty : replacedParameters.getSimpleProperties().values()) {
                    String temp = simpleProperty.getStringValue();
                    if (temp == null) continue;
                    temp = replacementEngine.replaceTokens(temp);
                    simpleProperty.setStringValue(temp);
                }
            }
        }
        catch (Exception e) {
            String message = this.getResultMessage(info, "parameterized argument replacement failed with " + e.getMessage());
            return SenderResult.getSimpleFailure((String)message);
        }
        try {
            String description = "Alert operation for " + alert.getAlertDefinition().getName();
            ResourceOperationSchedule schedule = LookupUtil.getOperationManager().scheduleResourceOperation(subject, targetResource.getId(), operation.getName(), 0L, 0L, 0, 0, replacedParameters, description);
            String message = this.getResultMessage(info, this.getHyperLinkForOperationSchedule(subject, targetResource.getId(), operation.getName(), schedule.getJobId()));
            return SenderResult.getSimpleDeffered((String)message);
        }
        catch (Throwable t) {
            String message = this.getResultMessage(info, "invocation failed with " + t.getMessage());
            return SenderResult.getSimpleFailure((String)message);
        }
    }

    private String getHyperLinkForOperationSchedule(Subject subject, int resourceId, String operationName, JobId jobId) {
        return "Check the corresponding " + this.link("operation history", "/rhq/resource/operation/resourceOperationHistory.xhtml?id=" + resourceId) + " for more details.";
    }

    public String decorate(OperationRequestStatus status) {
        if (status == null) {
            return "<unknown>";
        }
        if (status == OperationRequestStatus.SUCCESS) {
            return "<span style=\"color: green; font-weight: bold;\">" + status + "</span>";
        }
        if (status == OperationRequestStatus.FAILURE) {
            return "<span style=\"color: red; font-weight: bold;\">" + status + "</span>";
        }
        if (status == OperationRequestStatus.CANCELED) {
            return "<span style=\"color: orange; font-weight: bold;\">" + status + "</span>";
        }
        return status.toString();
    }

    private String link(String label, String url) {
        return "<a href=\"" + url + "\">" + label + "</a>";
    }

    private String getResultMessage(OperationInfo info, String details) {
        return "Executed " + info + "<br/>" + details;
    }

    public String previewConfiguration() {
        OperationInfo info = OperationInfo.load(this.alertParameters, this.extraParameters);
        return info.toString();
    }
}

