/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.HrefStatus;
import com.bradmcevoy.http.Range;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.ResponseHandler;
import com.bradmcevoy.http.XmlWriter;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResponseHandler
implements ResponseHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultResponseHandler.class);
    public static final String METHOD_NOT_ALLOWED_HTML = "<html><body><h1>Method Not Allowed</h1></body></html>";
    public static final String NOT_FOUND_HTML = "<html><body><h1>Not Found (404)</h1></body></html>";
    public static final String METHOD_NOT_IMPLEMENTED_HTML = "<html><body><h1>Method Not Implemented</h1></body></html>";
    public static final String CONFLICT_HTML = "<html><body><h1>Conflict</h1></body></html>";
    private String supportedLevels;

    public DefaultResponseHandler() {
        this("1");
    }

    public DefaultResponseHandler(String supportedLevels) {
        this.supportedLevels = supportedLevels;
    }

    @Override
    public void respondWithOptions(Resource resource, Response response, Request request, List<Request.Method> methodsAllowed) {
        response.setStatus(Response.Status.SC_OK);
        response.setDavHeader(this.getSupportedLevels());
        response.setAllowHeader(methodsAllowed);
        response.setNonStandardHeader("MS-Author-Via", "DAV");
        response.setContentLengthHeader(0L);
    }

    @Override
    public void respondNotFound(Response response, Request request) {
        log.debug("responding not found");
        response.setStatus(Response.Status.SC_NOT_FOUND);
        this.sendErrorContent(response, Response.Status.SC_NOT_FOUND);
    }

    @Override
    public void respondUnauthorised(Resource resource, Response response, Request request) {
        log.debug("requesting authorisation");
        response.setStatus(Response.Status.SC_UNAUTHORIZED);
        response.setAuthenticateHeader(resource.getRealm());
    }

    @Override
    public void respondMethodNotImplemented(Resource resource, Response response, Request request) {
        log.debug("method not implemented. resource: " + resource.getClass().getName() + " - method " + (Object)((Object)request.getMethod()));
        try {
            response.setStatus(Response.Status.SC_NOT_IMPLEMENTED);
            OutputStream out = response.getOutputStream();
            out.write(METHOD_NOT_IMPLEMENTED_HTML.getBytes());
        }
        catch (IOException ex) {
            log.warn("exception writing content");
        }
    }

    @Override
    public void respondMethodNotAllowed(Resource res, Response response, Request request) {
        log.debug("method not allowed. handler: " + this.getClass().getName() + " resource: " + res.getClass().getName());
        try {
            response.setStatus(Response.Status.SC_METHOD_NOT_ALLOWED);
            OutputStream out = response.getOutputStream();
            out.write(METHOD_NOT_ALLOWED_HTML.getBytes());
        }
        catch (IOException ex) {
            log.warn("exception writing content");
        }
    }

    @Override
    public void respondConflict(Resource resource, Response response, Request request, String message) {
        try {
            response.setStatus(Response.Status.SC_CONFLICT);
            OutputStream out = response.getOutputStream();
            out.write(CONFLICT_HTML.getBytes());
        }
        catch (IOException ex) {
            log.warn("exception writing content");
        }
    }

    @Override
    public void respondRedirect(Response response, Request request, String redirectUrl) {
        if (redirectUrl == null) {
            throw new NullPointerException("redirectUrl cannot be null");
        }
        response.setStatus(Response.Status.SC_MOVED_TEMPORARILY);
        response.setLocationHeader(redirectUrl);
    }

    @Override
    public void respondCreated(Resource resource, Response response, Request request) {
        log.debug("respondCreated");
        response.setStatus(Response.Status.SC_CREATED);
    }

    @Override
    public void respondNoContent(Resource resource, Response response, Request request) {
        log.debug("respondNoContent");
        response.setStatus(Response.Status.SC_OK);
    }

    @Override
    public void respondPartialContent(GetableResource resource, Response response, Request request, Map<String, String> params, Range range) throws NotAuthorizedException {
        String acc;
        String ct;
        log.debug("respondPartialContent");
        response.setStatus(Response.Status.SC_PARTIAL_CONTENT);
        response.setContentRangeHeader(range.start, range.finish, resource.getContentLength());
        response.setDateHeader(new Date());
        String etag = resource.getUniqueId();
        if (etag != null) {
            response.setEtag(etag);
        }
        if ((ct = resource.getContentType(acc = request.getAcceptHeader())) != null) {
            response.setContentTypeHeader(ct);
        }
        try {
            resource.sendContent(response.getOutputStream(), range, params, ct);
        }
        catch (IOException ex) {
            log.warn("IOException writing to output, probably client terminated connection", (Throwable)ex);
        }
    }

    @Override
    public void respondContent(Resource resource, Response response, Request request, Map<String, String> params) throws NotAuthorizedException {
        log.debug("respondContent: " + resource.getClass());
        DefaultResponseHandler.setRespondContentCommonHeaders(response, resource);
        if (resource instanceof GetableResource) {
            String acc;
            String ct;
            log.debug("..is getable");
            GetableResource gr = (GetableResource)resource;
            Long contentLength = gr.getContentLength();
            if (contentLength != null) {
                response.setContentLengthHeader(contentLength);
            }
            if ((ct = gr.getContentType(acc = request.getAcceptHeader())) != null) {
                response.setContentTypeHeader(ct);
            }
            DefaultResponseHandler.setCacheControl(gr, response, request.getAuthorization());
            this.sendContent(request, response, (GetableResource)resource, params, null, ct);
        }
    }

    @Override
    public void respondNotModified(GetableResource resource, Response response, Request request) {
        log.debug("not modified");
        response.setDateHeader(new Date());
        String acc = request.getAcceptHeader();
        String etag = resource.getUniqueId();
        if (etag != null) {
            response.setEtag(etag);
        }
        response.setLastModifiedHeader(resource.getModifiedDate());
        DefaultResponseHandler.setCacheControl(resource, response, request.getAuthorization());
        response.setStatus(Response.Status.SC_NOT_MODIFIED);
    }

    @Override
    public void responseMultiStatus(Resource resource, Response response, Request request, List<HrefStatus> statii) {
        response.setStatus(Response.Status.SC_MULTI_STATUS);
        response.setContentTypeHeader("text/xml; charset=UTF-8");
        String href = request.getAbsoluteUrl();
        XmlWriter writer = new XmlWriter(response.getOutputStream());
        writer.writeXMLHeader();
        writer.open("multistatus" + this.generateNamespaceDeclarations());
        writer.newLine();
        for (HrefStatus status : statii) {
            XmlWriter.Element elResponse = writer.begin("response").open();
            writer.writeProperty("", "href", status.href);
            writer.writeProperty("", "status", status.status.code + "");
            elResponse.close();
        }
        writer.close("multistatus");
        writer.flush();
    }

    protected String generateNamespaceDeclarations() {
        return " xmlns:D=\"DAV:\"";
    }

    public static void setCacheControl(GetableResource resource, Response response, Auth auth) {
        Long delta = resource.getMaxAgeSeconds(auth);
        if (delta != null) {
            if (auth != null) {
                response.setCacheControlPrivateMaxAgeHeader(delta);
            } else {
                response.setCacheControlMaxAgeHeader(delta);
            }
            Date expiresAt = DefaultResponseHandler.calcExpiresAt(resource.getModifiedDate(), delta);
            response.setExpiresHeader(expiresAt);
        } else {
            response.setCacheControlNoCacheHeader();
        }
    }

    public static Date calcExpiresAt(Date modifiedDate, long deltaSeconds) {
        long deltaMs = deltaSeconds * 1000L;
        long expiresAt = System.currentTimeMillis() + deltaMs;
        return new Date(expiresAt);
    }

    protected void sendContent(Request request, Response response, GetableResource resource, Map<String, String> params, Range range, String contentType) throws NotAuthorizedException {
        OutputStream out = this.outputStreamForResponse(request, response, resource);
        try {
            resource.sendContent(out, null, params, contentType);
            out.flush();
        }
        catch (IOException ex) {
            log.warn("IOException sending content", (Throwable)ex);
        }
    }

    protected OutputStream outputStreamForResponse(Request request, Response response, GetableResource resource) {
        OutputStream outToUse = response.getOutputStream();
        return outToUse;
    }

    public String getSupportedLevels() {
        return this.supportedLevels;
    }

    private void sendErrorContent(Response response, Response.Status status) {
        switch (status) {
            case SC_NOT_FOUND: {
                this.output(response, NOT_FOUND_HTML);
                break;
            }
        }
    }

    protected void output(Response response, String s) {
        PrintWriter pw = new PrintWriter(response.getOutputStream(), true);
        pw.print(s);
        pw.flush();
    }

    public static void setRespondContentCommonHeaders(Response response, Resource resource) {
        response.setStatus(Response.Status.SC_OK);
        response.setDateHeader(new Date());
        String etag = resource.getUniqueId();
        if (etag != null) {
            response.setEtag(etag);
        }
        response.setLastModifiedHeader(resource.getModifiedDate());
    }
}

