/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.DeletableResource;
import com.bradmcevoy.http.ExistingEntityHandler;
import com.bradmcevoy.http.HrefStatus;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteHandler
extends ExistingEntityHandler {
    private Logger log = LoggerFactory.getLogger(DeleteHandler.class);

    public DeleteHandler(HttpManager manager) {
        super(manager);
    }

    protected Request.Method method() {
        return Request.Method.DELETE;
    }

    protected boolean isCompatible(Resource handler) {
        return handler instanceof DeletableResource;
    }

    protected void process(HttpManager milton, Request request, Response response, Resource resource) {
        this.log.debug("DELETE: " + request.getAbsoluteUrl());
        DeletableResource r = (DeletableResource)resource;
        try {
            this.delete(r);
            response.setStatus(Response.Status.SC_NO_CONTENT);
            this.log.debug("deleted ok");
        }
        catch (CantDeleteException e) {
            this.log.error("failed to delete: " + request.getAbsoluteUrl(), (Throwable)e);
            ArrayList<HrefStatus> statii = new ArrayList<HrefStatus>();
            statii.add(new HrefStatus(request.getAbsoluteUrl(), e.status));
            this.manager.getResponseHandler().responseMultiStatus(resource, response, request, statii);
        }
    }

    private void delete(DeletableResource r) throws CantDeleteException {
        if (r instanceof CollectionResource) {
            CollectionResource col = (CollectionResource)((Object)r);
            ArrayList<? extends Resource> list = new ArrayList<Resource>();
            list.addAll(col.getChildren());
            for (Resource resource : list) {
                if (resource instanceof DeletableResource) {
                    DeletableResource rChildDel = (DeletableResource)resource;
                    this.delete(rChildDel);
                    continue;
                }
                throw new CantDeleteException(resource, Response.Status.SC_LOCKED);
            }
        }
        r.delete();
    }

    public static class CantDeleteException
    extends Exception {
        private static final long serialVersionUID = 1L;
        public final Resource resource;
        public final Response.Status status;

        CantDeleteException(Resource r, Response.Status status) {
            this.resource = r;
            this.status = status;
        }
    }
}

