/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.CopyHandler;
import com.bradmcevoy.http.DefaultResponseHandler;
import com.bradmcevoy.http.DeleteHandler;
import com.bradmcevoy.http.EventListener;
import com.bradmcevoy.http.FileItem;
import com.bradmcevoy.http.Filter;
import com.bradmcevoy.http.FilterChain;
import com.bradmcevoy.http.GetHandler;
import com.bradmcevoy.http.Handler;
import com.bradmcevoy.http.HeadHandler;
import com.bradmcevoy.http.LockHandler;
import com.bradmcevoy.http.MkColHandler;
import com.bradmcevoy.http.MoveHandler;
import com.bradmcevoy.http.OptionsHandler;
import com.bradmcevoy.http.PostHandler;
import com.bradmcevoy.http.PropFindHandler;
import com.bradmcevoy.http.PropPatchHandler;
import com.bradmcevoy.http.PutHandler;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.ResourceFactory;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.ResponseHandler;
import com.bradmcevoy.http.SessionAuthenticationHandler;
import com.bradmcevoy.http.StandardFilter;
import com.bradmcevoy.http.UnlockHandler;
import com.bradmcevoy.http.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpManager {
    private static final Logger log = LoggerFactory.getLogger(HttpManager.class);
    final OptionsHandler optionsHandler;
    final GetHandler getHandler;
    final PostHandler postHandler;
    final PropFindHandler propFindHandler;
    final MkColHandler mkColHandler;
    final MoveHandler moveHandler;
    final PutHandler putHandler;
    final DeleteHandler deleteHandler;
    final PropPatchHandler propPatchHandler;
    final CopyHandler copyHandler;
    final HeadHandler headHandler;
    final LockHandler lockHandler;
    final UnlockHandler unlockHandler;
    public final Handler[] allHandlers;
    Map<Request.Method, Handler> methodFactoryMap = new ConcurrentHashMap<Request.Method, Handler>();
    List<Filter> filters = new ArrayList<Filter>();
    List<EventListener> eventListeners = new ArrayList<EventListener>();
    final ResourceFactory resourceFactory;
    final ResponseHandler responseHandler;
    final String notFoundPath;
    private SessionAuthenticationHandler sessionAuthenticationHandler;

    public HttpManager(ResourceFactory resourceFactory, String notFoundPath) {
        this(resourceFactory, notFoundPath, new DefaultResponseHandler());
    }

    public HttpManager(ResourceFactory resourceFactory) {
        this(resourceFactory, null, null);
    }

    public HttpManager(ResourceFactory resourceFactory, ResponseHandler responseHandler) {
        this(resourceFactory, null, responseHandler);
    }

    public HttpManager(ResourceFactory resourceFactory, String notFoundPath, ResponseHandler responseHandler) {
        if (resourceFactory == null) {
            throw new NullPointerException("resourceFactory cannot be null");
        }
        this.resourceFactory = resourceFactory;
        this.responseHandler = responseHandler;
        this.notFoundPath = notFoundPath;
        this.optionsHandler = this.add(this.createOptionsHandler());
        this.getHandler = this.add(this.createGetHandler());
        this.postHandler = this.add(this.createPostHandler());
        this.propFindHandler = this.add(this.createPropFindHandler());
        this.mkColHandler = this.add(this.createMkColHandler());
        this.moveHandler = this.add(this.createMoveFactory());
        this.putHandler = this.add(this.createPutFactory());
        this.deleteHandler = this.add(this.createDeleteHandler());
        this.copyHandler = this.add(this.createCopyHandler());
        this.headHandler = this.add(this.createHeadHandler());
        this.propPatchHandler = this.add(this.createPropPatchHandler());
        this.lockHandler = this.add(this.createLockHandler());
        this.unlockHandler = this.add(this.createUnlockHandler());
        this.allHandlers = new Handler[]{this.optionsHandler, this.getHandler, this.postHandler, this.propFindHandler, this.mkColHandler, this.moveHandler, this.putHandler, this.deleteHandler, this.propPatchHandler, this.lockHandler, this.unlockHandler};
        this.filters.add(this.createStandardFilter());
    }

    public String getNotFoundPath() {
        return this.notFoundPath;
    }

    public ResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    public SessionAuthenticationHandler getSessionAuthenticationHandler() {
        return this.sessionAuthenticationHandler;
    }

    public void setSessionAuthenticationHandler(SessionAuthenticationHandler sessionAuthenticationHandler) {
        this.sessionAuthenticationHandler = sessionAuthenticationHandler;
    }

    public Auth getSessionAuthentication(Request request) {
        if (this.sessionAuthenticationHandler == null) {
            return null;
        }
        return this.sessionAuthenticationHandler.getSessionAuthentication(request);
    }

    public ResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    private <T extends Handler> T add(T h) {
        this.methodFactoryMap.put(h.method(), h);
        return h;
    }

    public void process(Request request, Response response) {
        log.debug((Object)((Object)request.getMethod()) + " :: " + request.getAbsoluteUrl());
        FilterChain chain = new FilterChain(this);
        chain.process(request, response);
    }

    protected Filter createStandardFilter() {
        return new StandardFilter();
    }

    protected OptionsHandler createOptionsHandler() {
        return new OptionsHandler(this);
    }

    protected GetHandler createGetHandler() {
        return new GetHandler(this);
    }

    protected PostHandler createPostHandler() {
        return new PostHandler(this);
    }

    protected DeleteHandler createDeleteHandler() {
        return new DeleteHandler(this);
    }

    protected PutHandler createPutFactory() {
        return new PutHandler(this);
    }

    protected MoveHandler createMoveFactory() {
        return new MoveHandler(this);
    }

    protected MkColHandler createMkColHandler() {
        return new MkColHandler(this);
    }

    protected PropFindHandler createPropFindHandler() {
        return new PropFindHandler(this);
    }

    protected CopyHandler createCopyHandler() {
        return new CopyHandler(this);
    }

    protected HeadHandler createHeadHandler() {
        return new HeadHandler(this);
    }

    protected PropPatchHandler createPropPatchHandler() {
        return new PropPatchHandler(this);
    }

    protected LockHandler createLockHandler() {
        return new LockHandler(this);
    }

    protected UnlockHandler createUnlockHandler() {
        return new UnlockHandler(this);
    }

    public static String decodeUrl(String s) {
        return Utils.decodePath(s);
    }

    public void addFilter(int pos, Filter filter) {
        this.filters.add(pos, filter);
    }

    public void addEventListener(EventListener l) {
        this.eventListeners.add(l);
    }

    public void removeEventListener(EventListener l) {
        this.eventListeners.remove(l);
    }

    void onProcessResourceFinish(Request request, Response response, Resource resource, long duration) {
        for (EventListener l : this.eventListeners) {
            l.onProcessResourceFinish(request, response, resource, duration);
        }
    }

    void onProcessResourceStart(Request request, Response response, Resource resource) {
        for (EventListener l : this.eventListeners) {
            l.onProcessResourceStart(request, response, resource);
        }
    }

    void onPost(Request request, Response response, Resource resource, Map<String, String> params, Map<String, FileItem> files) {
        for (EventListener l : this.eventListeners) {
            l.onPost(request, response, resource, params, files);
        }
    }

    void onGet(Request request, Response response, Resource resource, Map<String, String> params) {
        for (EventListener l : this.eventListeners) {
            l.onGet(request, response, resource, params);
        }
    }

    public List<Filter> getFilters() {
        ArrayList<Filter> col = new ArrayList<Filter>(this.filters);
        return col;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
        filters.add(new StandardFilter());
    }

    public void setEventListeners(List<EventListener> eventListeners) {
        this.eventListeners = eventListeners;
    }

    public CopyHandler getCopyHandler() {
        return this.copyHandler;
    }

    public DeleteHandler getDeleteHandler() {
        return this.deleteHandler;
    }

    public GetHandler getGetHandler() {
        return this.getHandler;
    }

    public HeadHandler getHeadHandler() {
        return this.headHandler;
    }

    public LockHandler getLockHandler() {
        return this.lockHandler;
    }

    public MkColHandler getMkColHandler() {
        return this.mkColHandler;
    }

    public MoveHandler getMoveHandler() {
        return this.moveHandler;
    }

    public OptionsHandler getOptionsHandler() {
        return this.optionsHandler;
    }

    public PostHandler getPostHandler() {
        return this.postHandler;
    }

    public PropFindHandler getPropFindHandler() {
        return this.propFindHandler;
    }

    public PropPatchHandler getPropPatchHandler() {
        return this.propPatchHandler;
    }

    public UnlockHandler getUnlockHandler() {
        return this.unlockHandler;
    }

    public PutHandler getPutHandler() {
        return this.putHandler;
    }
}

