/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.common.Path;
import com.bradmcevoy.http.Handler;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.LockInfo;
import com.bradmcevoy.http.LockResult;
import com.bradmcevoy.http.LockTimeout;
import com.bradmcevoy.http.LockToken;
import com.bradmcevoy.http.LockableResource;
import com.bradmcevoy.http.LockingCollectionResource;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.XmlWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class LockHandler
extends Handler {
    private Logger log = LoggerFactory.getLogger(LockHandler.class);

    public LockHandler(HttpManager manager) {
        super(manager);
    }

    public void process(HttpManager manager, Request request, Response response) {
        String host = request.getHostHeader();
        String url = HttpManager.decodeUrl(request.getAbsolutePath());
        Resource r = manager.getResourceFactory().getResource(host, url);
        if (r != null) {
            this.log.debug("locking existing resource: " + r.getName());
            this.processExistingResource(manager, request, response, r);
        } else {
            this.log.debug("lock target doesnt exist, attempting lock null..");
            this.processNonExistingResource(manager, request, response, host, url);
        }
    }

    protected void processExistingResource(HttpManager milton, Request request, Response response, Resource resource) {
        if (!this.isCompatible(resource)) {
            this.respondMethodNotImplemented(resource, response, request);
            return;
        }
        LockableResource r = (LockableResource)resource;
        LockTimeout timeout = LockTimeout.parseTimeout(request);
        String ifHeader = request.getIfHeader();
        response.setContentTypeHeader("text/xml; charset=UTF-8");
        if (ifHeader == null || ifHeader.length() == 0) {
            this.processNewLock(milton, request, response, r, timeout);
        } else {
            this.processRefresh(milton, request, response, r, timeout, ifHeader);
        }
    }

    private void processNonExistingResource(HttpManager manager, Request request, Response response, String host, String url) {
        Path parentPath = Path.path(url);
        String name = parentPath.getName();
        parentPath = parentPath.getParent();
        url = parentPath.toString();
        Resource r = manager.getResourceFactory().getResource(host, url);
        if (r != null) {
            this.processCreateAndLock(request, response, r, name);
        } else {
            this.log.debug("couldnt find parent to execute lock-null, returning not found");
            this.respondNotFound(response, request);
        }
    }

    private void processCreateAndLock(Request request, Response response, Resource parentResource, String name) {
        if (parentResource instanceof LockingCollectionResource) {
            LockInfo lockInfo;
            this.log.debug("parent supports lock-null. doing createAndLock");
            response.setStatus(Response.Status.SC_CREATED);
            LockingCollectionResource lockingParent = (LockingCollectionResource)parentResource;
            LockTimeout timeout = LockTimeout.parseTimeout(request);
            response.setContentTypeHeader("text/xml; charset=UTF-8");
            try {
                lockInfo = LockInfo.parseLockInfo(request);
            }
            catch (SAXException ex) {
                throw new RuntimeException("Exception reading request body", ex);
            }
            catch (IOException ex) {
                throw new RuntimeException("Exception reading request body", ex);
            }
            this.log.debug("Creating lock on unmapped resource: " + name);
            LockToken tok = lockingParent.createAndLock(name, timeout, lockInfo);
            response.setLockTokenHeader("<opaquelocktoken:" + tok.tokenId + ">");
            this.respondWithToken(tok, request, response);
        } else {
            this.log.debug("parent does not support lock-null, respondong method not allowed");
            this.respondMethodNotImplemented(parentResource, response, request);
        }
    }

    public Request.Method method() {
        return Request.Method.LOCK;
    }

    protected boolean isCompatible(Resource handler) {
        return handler instanceof LockableResource;
    }

    protected void processNewLock(HttpManager milton, Request request, Response response, LockableResource r, LockTimeout timeout) {
        LockInfo lockInfo;
        try {
            lockInfo = LockInfo.parseLockInfo(request);
        }
        catch (SAXException ex) {
            throw new RuntimeException("Exception reading request body", ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("Exception reading request body", ex);
        }
        this.log.debug("locking: " + r.getName());
        LockResult result = r.lock(timeout, lockInfo);
        if (result.isSuccessful()) {
            LockToken tok = result.lockToken;
            this.log.debug("..locked: " + tok.tokenId);
            response.setLockTokenHeader("<opaquelocktoken:" + tok.tokenId + ">");
            this.respondWithToken(tok, request, response);
        } else {
            this.responseWithLockFailure(result, request, response);
        }
    }

    protected void processRefresh(HttpManager milton, Request request, Response response, LockableResource r, LockTimeout timeout, String ifHeader) {
        String token = LockHandler.parseToken(ifHeader);
        this.log.debug("refreshing lock: " + token);
        LockResult result = r.refreshLock(token);
        if (result.isSuccessful()) {
            LockToken tok = result.lockToken;
            this.respondWithToken(tok, request, response);
        } else {
            this.responseWithLockFailure(result, request, response);
        }
    }

    protected void respondWithToken(LockToken tok, Request request, Response response) {
        response.setStatus(Response.Status.SC_OK);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XmlWriter writer = new XmlWriter(out);
        writer.writeXMLHeader();
        writer.open("D:prop  xmlns:D=\"DAV:\"");
        writer.newLine();
        writer.open("D:lockdiscovery");
        writer.newLine();
        writer.open("D:activelock");
        writer.newLine();
        this.appendType(writer, tok.info.type);
        this.appendScope(writer, tok.info.scope);
        this.appendDepth(writer, tok.info.depth);
        this.appendOwner(writer, tok.info.owner);
        this.appendTimeout(writer, tok.timeout.seconds);
        this.appendTokenId(writer, tok.tokenId);
        this.appendRoot(writer, request.getAbsoluteUrl());
        writer.close("D:activelock");
        writer.close("D:lockdiscovery");
        writer.close("D:prop");
        writer.flush();
        this.log.debug("lock response: " + out.toString());
        try {
            response.getOutputStream().write(out.toByteArray());
        }
        catch (IOException ex) {
            this.log.warn("exception writing to outputstream", (Throwable)ex);
        }
    }

    static String parseToken(String ifHeader) {
        String token = ifHeader;
        int pos = token.indexOf(":");
        if (pos >= 0 && (pos = (token = token.substring(pos + 1)).indexOf(">")) >= 0) {
            token = token.substring(0, pos);
        }
        return token;
    }

    private void appendDepth(XmlWriter writer, LockInfo.LockDepth depthType) {
        String s = "Infinity";
        if (depthType != null && depthType.equals((Object)LockInfo.LockDepth.INFINITY)) {
            s = depthType.name().toUpperCase();
        }
        writer.writeProperty(null, "D:depth", s);
    }

    private void appendOwner(XmlWriter writer, String owner) {
        XmlWriter.Element el = writer.begin("D:owner").open();
        XmlWriter.Element el2 = writer.begin("D:href").open();
        if (owner != null) {
            el2.writeText(owner);
        }
        el2.close();
        el.close();
    }

    private void appendScope(XmlWriter writer, LockInfo.LockScope scope) {
        writer.writeProperty(null, "D:lockscope", "<D:" + scope.toString().toLowerCase() + "/>");
    }

    private void appendTimeout(XmlWriter writer, Long seconds) {
        if (seconds != null && seconds > 0L) {
            writer.writeProperty(null, "D:timeout", "Second-" + seconds);
        }
    }

    private void appendTokenId(XmlWriter writer, String tokenId) {
        XmlWriter.Element el = writer.begin("D:locktoken").open();
        writer.writeProperty(null, "D:href", "opaquelocktoken:" + tokenId);
        el.close();
    }

    private void appendType(XmlWriter writer, LockInfo.LockType type) {
        writer.writeProperty(null, "D:locktype", "<D:" + type.toString().toLowerCase() + "/>");
    }

    private void appendRoot(XmlWriter writer, String lockRoot) {
        XmlWriter.Element el = writer.begin("D:lockroot").open();
        writer.writeProperty(null, "D:href", lockRoot);
        el.close();
    }

    private void responseWithLockFailure(LockResult result, Request request, Response response) {
        response.setStatus(result.failureReason.status);
    }
}

