/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.ExistingEntityHandler;
import com.bradmcevoy.http.Handler;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionsHandler
extends ExistingEntityHandler {
    public OptionsHandler(HttpManager manager) {
        super(manager);
    }

    @Override
    protected void process(HttpManager milton, Request request, Response response, Resource resource) {
        this.respondWithOptions(response, request, resource);
    }

    @Override
    public Request.Method method() {
        return Request.Method.OPTIONS;
    }

    @Override
    protected boolean isCompatible(Resource handler) {
        return true;
    }

    private List<Request.Method> determineMethodsAllowed(Resource res) {
        ArrayList<Request.Method> list = new ArrayList<Request.Method>();
        for (Handler f : this.manager.allHandlers) {
            if (!f.isCompatible(res)) continue;
            list.add(f.method());
        }
        return list;
    }

    private void respondWithOptions(Response response, Request request, Resource resource) {
        List<Request.Method> methodsAllowed = this.determineMethodsAllowed(resource);
        this.getResponseHandler().respondWithOptions(resource, response, request, methodsAllowed);
    }
}

