/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.ExistingEntityHandler;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.PropPatchSaxHandler;
import com.bradmcevoy.http.PropPatchableResource;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.io.ReadingException;
import com.bradmcevoy.io.StreamToStream;
import com.bradmcevoy.io.WritingException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class PropPatchHandler
extends ExistingEntityHandler {
    private static final Logger log = LoggerFactory.getLogger(PropPatchHandler.class);

    PropPatchHandler(HttpManager manager) {
        super(manager);
    }

    public Request.Method method() {
        return Request.Method.PROPPATCH;
    }

    protected boolean isCompatible(Resource handler) {
        return handler instanceof PropPatchableResource;
    }

    protected void process(HttpManager milton, Request request, Response response, Resource resource) {
        PropPatchableResource patchable = (PropPatchableResource)resource;
        try {
            InputStream in = request.getInputStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamToStream.readTo(in, out);
            log.debug("PropPatch: " + out.toString());
            Fields fields = PropPatchHandler.parseContent(request);
            if (fields != null) {
                patchable.setProperties(fields);
            }
            this.respondOk(request, response, fields);
        }
        catch (SAXException ex) {
            throw new RuntimeException(ex);
        }
        catch (WritingException ex) {
            throw new RuntimeException(ex);
        }
        catch (ReadingException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static Fields parseContent(Request request) throws IOException, SAXException {
        InputStream in = request.getInputStream();
        return PropPatchHandler.parseContent(in);
    }

    static Fields parseContent(InputStream in) throws IOException, SAXException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        StreamToStream.readTo(in, bout, false, true);
        byte[] arr = bout.toByteArray();
        if (arr.length == 0) {
            return null;
        }
        return PropPatchHandler.parseContent(arr);
    }

    static Fields parseContent(byte[] arr) throws IOException, SAXException {
        ByteArrayInputStream bin = new ByteArrayInputStream(arr);
        XMLReader reader = XMLReaderFactory.createXMLReader();
        PropPatchSaxHandler handler = new PropPatchSaxHandler();
        reader.setContentHandler(handler);
        reader.parse(new InputSource(bin));
        return handler.getFields();
    }

    private void respondOk(Request request, Response response, Fields fields) {
        response.setStatus(Response.Status.SC_OK);
    }

    public static class Fields {
        final List<Field> removeFields = new ArrayList<Field>();
        List<SetField> setFields = new ArrayList<SetField>();
    }

    public static class SetField
    extends Field {
        final String value;

        public SetField(String name, String value) {
            super(name);
            this.value = value;
        }
    }

    public static class Field {
        final String name;

        public Field(String name) {
            this.name = name;
        }
    }
}

