/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.common.ContentTypeUtils;
import com.bradmcevoy.common.Path;
import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.Handler;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.MakeCollectionableResource;
import com.bradmcevoy.http.PutableResource;
import com.bradmcevoy.http.ReplaceableResource;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutHandler
extends Handler {
    private static final Logger log = LoggerFactory.getLogger(PutHandler.class);

    public PutHandler(HttpManager manager) {
        super(manager);
    }

    public Request.Method method() {
        return Request.Method.PUT;
    }

    protected boolean isCompatible(Resource handler) {
        return handler instanceof PutableResource;
    }

    public void process(HttpManager manager, Request request, Response response) throws NotAuthorizedException, ConflictException {
        String host = request.getHostHeader();
        String urlToCreateOrUpdate = HttpManager.decodeUrl(request.getAbsolutePath());
        log.debug("process request: host: " + host + " url: " + urlToCreateOrUpdate);
        Path path = Path.path(urlToCreateOrUpdate);
        urlToCreateOrUpdate = path.toString();
        Resource existingResource = manager.getResourceFactory().getResource(host, urlToCreateOrUpdate);
        ReplaceableResource replacee = existingResource != null && existingResource instanceof ReplaceableResource ? (ReplaceableResource)existingResource : null;
        if (replacee != null) {
            this.processReplace(request, response, (ReplaceableResource)existingResource);
        } else {
            String urlFolder = path.getParent().toString();
            String nameToCreate = path.getName();
            CollectionResource folderResource = this.findOrCreateFolders(host, path.getParent());
            if (folderResource != null) {
                log.debug("found folder: " + urlFolder);
                if (folderResource instanceof PutableResource) {
                    PutableResource putableResource = (PutableResource)folderResource;
                    this.processCreate(manager, request, response, putableResource, nameToCreate);
                } else {
                    manager.getResponseHandler().respondMethodNotImplemented(folderResource, response, request);
                }
            } else {
                response.setStatus(Response.Status.SC_NOT_FOUND);
            }
        }
    }

    protected void processCreate(HttpManager milton, Request request, Response response, PutableResource folder, String newName) {
        log.debug("processCreate: " + newName + " in " + folder.getName());
        if (!this.checkAuthorisation(folder, request)) {
            this.respondUnauthorised(folder, response, request);
            return;
        }
        log.debug("process: putting to: " + folder.getName());
        try {
            Long l = request.getContentLengthHeader();
            String ct = this.findContentTypes(request, newName);
            log.debug("PutHandler: creating resource of type: " + ct);
            folder.createNew(newName, request.getInputStream(), l, ct);
            log.debug("PutHandler: DONE creating resource");
        }
        catch (IOException ex) {
            log.warn("IOException reading input stream. Probably interrupted upload: " + ex.getMessage());
            return;
        }
        this.getResponseHandler().respondCreated(folder, response, request);
        log.debug("process: finished");
    }

    private String findContentTypes(Request request, String newName) {
        String ct = request.getContentTypeHeader();
        if (ct != null) {
            return ct;
        }
        return ContentTypeUtils.findContentTypes(newName);
    }

    private CollectionResource findOrCreateFolders(String host, Path path) throws NotAuthorizedException, ConflictException {
        log.debug("findOrCreateFolders");
        if (path == null) {
            return null;
        }
        Resource thisResource = this.manager.getResourceFactory().getResource(host, path.toString());
        if (thisResource != null) {
            if (thisResource instanceof CollectionResource) {
                return (CollectionResource)thisResource;
            }
            log.warn("parent is not a collection: " + path);
            return null;
        }
        CollectionResource parent = this.findOrCreateFolders(host, path.getParent());
        if (parent == null) {
            log.warn("couldnt find parent: " + path);
            return null;
        }
        Resource r = parent.child(path.getName());
        if (r == null) {
            if (parent instanceof MakeCollectionableResource) {
                MakeCollectionableResource mkcol = (MakeCollectionableResource)parent;
                log.debug("autocreating new folder: " + path.getName());
                return mkcol.createCollection(path.getName());
            }
            log.debug("parent folder isnt a MakeCollectionableResource: " + parent.getName());
            return null;
        }
        if (r instanceof CollectionResource) {
            return (CollectionResource)r;
        }
        log.debug("parent in URL is not a collection: " + r.getName());
        return null;
    }

    private void processReplace(Request request, Response response, ReplaceableResource replacee) {
        if (!this.checkAuthorisation(replacee, request)) {
            this.respondUnauthorised(replacee, response, request);
            return;
        }
        try {
            Long l = request.getContentLengthHeader();
            replacee.replaceContent(request.getInputStream(), l);
            log.debug("PutHandler: DONE creating resource");
        }
        catch (IOException ex) {
            log.warn("IOException reading input stream. Probably interrupted upload: " + ex.getMessage());
            return;
        }
        this.getResponseHandler().respondCreated(replacee, response, request);
        log.debug("process: finished");
    }
}

