/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.Request;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Response {
    public static final String HTTP = "text/html";
    public static final String IMAGE_JPG = "image/jpg";
    public static final String MULTIPART = "multipart/form-data";
    public static final String XML = "text/xml; charset=UTF-8";

    public Status getStatus();

    public Map<String, String> getHeaders();

    public Long getContentLength();

    public void setContentEncodingHeader(ContentEncoding var1);

    public void setExpiresHeader(Date var1);

    public void setLockTokenHeader(String var1);

    public void setAuthenticateHeader(String var1);

    public void setStatus(Status var1);

    public void setEtag(String var1);

    public void setContentRangeHeader(long var1, long var3, Long var5);

    public void setContentLengthHeader(Long var1);

    public void setContentTypeHeader(String var1);

    public String getContentTypeHeader();

    public void setCacheControlMaxAgeHeader(Long var1);

    public void setCacheControlPrivateMaxAgeHeader(Long var1);

    public void setCacheControlNoCacheHeader();

    public void setLastModifiedHeader(Date var1);

    public void setDavHeader(String var1);

    public void setNonStandardHeader(String var1, String var2);

    public String getNonStandardHeader(String var1);

    public void setAllowHeader(List<Request.Method> var1);

    public OutputStream getOutputStream();

    public void setLocationHeader(String var1);

    public void setDateHeader(Date var1);

    public void close();

    public void sendRedirect(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        SC_OK(200),
        SC_CREATED(201),
        SC_ACCEPTED(202),
        SC_NO_CONTENT(204),
        SC_MOVED_PERMANENTLY(301),
        SC_MOVED_TEMPORARILY(302),
        SC_NOT_MODIFIED(304),
        SC_BAD_REQUEST(400),
        SC_UNAUTHORIZED(401),
        SC_FORBIDDEN(403),
        SC_NOT_FOUND(404),
        SC_INTERNAL_SERVER_ERROR(500),
        SC_NOT_IMPLEMENTED(501),
        SC_BAD_GATEWAY(502),
        SC_SERVICE_UNAVAILABLE(503),
        SC_PARTIAL_CONTENT(206),
        SC_CONTINUE(100),
        SC_METHOD_NOT_ALLOWED(405),
        SC_CONFLICT(409),
        SC_PRECONDITION_FAILED(412),
        SC_REQUEST_TOO_LONG(413),
        SC_UNSUPPORTED_MEDIA_TYPE(415),
        SC_MULTI_STATUS(207),
        SC_UNPROCESSABLE_ENTITY(418),
        SC_INSUFFICIENT_SPACE_ON_RESOURCE(419),
        SC_METHOD_FAILURE(420),
        SC_LOCKED(423);

        public int code;

        private Status(int code) {
            this.code = code;
        }

        public String toString() {
            return "HTTP/1.1 " + this.code;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CacheControlResponse {
        PUBLIC("public"),
        PRIVATE("private"),
        NO_CACHE("no-cache"),
        NO_STORE("no-store"),
        NO_TRANSFORM("no-transform"),
        MUST_REVALIDATE("must-revalidate"),
        PROXY_REVALIDATE("proxy-revalidate"),
        MAX_AGE("max-age"),
        S_MAX_AGE("s-maxage"),
        CACHE_EXT("cache-extension");

        public String code;

        private CacheControlResponse(String code) {
            this.code = code;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Header {
        CACHE_CONTROL("Cache-Control"),
        WWW_AUTHENTICATE("WWW-Authenticate"),
        CONTENT_LENGTH("Content-Length"),
        CONTENT_TYPE("Content-Type"),
        CONTENT_ENCODING("Content-Encoding"),
        LOCATION("Location"),
        ALLOW("Allow"),
        DAV("DAV"),
        DATE("DATE"),
        LAST_MODIFIED("Last-Modified"),
        LOCK_TOKEN("Lock-Token"),
        EXPIRES("Expires"),
        ETAG("Etag"),
        CONTENT_RANGE("Content-Range");

        public String code;

        private Header(String code) {
            this.code = code;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContentEncoding {
        GZIP("gzip");

        public String code;

        private ContentEncoding(String code) {
            this.code = code;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContentType {
        HTTP,
        MULTIPART,
        IMAGE_JPG,
        XML;

    }
}

