/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.common.Path;
import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.Resource;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.Calendar;
import java.util.Date;
import sun.nio.cs.ThreadLocalCoders;

public class Utils {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static Resource findChild(Resource parent, Path path) {
        return Utils._findChild(parent, path.getParts(), 0);
    }

    public static String decodePath(String href) {
        try {
            if (href.startsWith("/")) {
                URI uri = new URI("http://anything.com" + href);
                return uri.getPath();
            }
            URI uri = new URI("http://anything.com/" + href);
            String s = uri.getPath();
            return s.substring(1);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Resource _findChild(Resource parent, String[] arr, int i) {
        if (parent instanceof CollectionResource) {
            CollectionResource col = (CollectionResource)parent;
            String childName = arr[i];
            Resource child = col.child(childName);
            if (child == null) {
                return null;
            }
            if (i < arr.length - 1) {
                return Utils._findChild(child, arr, i + 1);
            }
            return child;
        }
        return null;
    }

    public static Date now() {
        return new Date();
    }

    public static Date addSeconds(Date dt, long seconds) {
        return Utils.addSeconds(dt, (int)seconds);
    }

    public static Date addSeconds(Date dt, int seconds) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        cal.add(13, seconds);
        return cal.getTime();
    }

    public static String getProtocol(String url) {
        String protocol = url.substring(0, url.indexOf(":"));
        return protocol;
    }

    public static String escapeXml(String s) {
        s = s.replaceAll("\"", "&quot;");
        s = s.replaceAll("&", "&amp;");
        s = s.replaceAll("'", "&apos;");
        s = s.replaceAll("<", "&lt;");
        s = s.replaceAll(">", "&gt;");
        return s;
    }

    public static String percentEncode(String s) {
        ByteBuffer bb;
        block6: {
            int n = s.length();
            if (n == 0) {
                return s;
            }
            int i = 0;
            while (s.charAt(i) < '\u0080' && s.charAt(i) > '0') {
                if (++i < n) continue;
                return s;
            }
            String ns = Utils.normalize(s);
            bb = null;
            try {
                bb = ThreadLocalCoders.encoderFor("UTF-8").encode(CharBuffer.wrap(ns));
            }
            catch (CharacterCodingException x) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        StringBuffer sb = new StringBuffer();
        while (bb.hasRemaining()) {
            int b = bb.get() & 0xFF;
            if (b >= 128 || b < 48 && b != 46 && b != 45) {
                Utils.appendEscape(sb, (byte)b);
                continue;
            }
            sb.append((char)b);
        }
        return sb.toString();
    }

    private static void appendEscape(StringBuffer sb, byte b) {
        sb.append('%');
        sb.append(hexDigits[b >> 4 & 0xF]);
        sb.append(hexDigits[b >> 0 & 0xF]);
    }

    public static Date mostRecent(Date ... dates) {
        if (dates == null || dates.length == 0) {
            return null;
        }
        Date recent = dates[0];
        for (Date dt : dates) {
            if (dt.getTime() <= recent.getTime()) continue;
            recent = dt;
        }
        return recent;
    }

    private static String normalize(String s) {
        return s;
    }
}

