/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BufferingOutputStream
extends OutputStream {
    private ByteArrayOutputStream tempMemoryBuffer = new ByteArrayOutputStream();
    private int maxMemorySize;
    private File tempFile;
    private FileOutputStream fout;
    private BufferedOutputStream bufOut;
    private long size;
    private boolean closed;

    public BufferingOutputStream(int maxMemorySize) {
        this.maxMemorySize = maxMemorySize;
    }

    public InputStream getInputStream() {
        if (!this.closed) {
            throw new IllegalStateException("this output stream is not yet closed");
        }
        if (this.tempMemoryBuffer == null) {
            FileInputStream fin;
            try {
                fin = new FileInputStream(this.tempFile);
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException(this.tempFile.getAbsolutePath(), ex);
            }
            BufferedInputStream bufIn = new BufferedInputStream(fin);
            return bufIn;
        }
        return new ByteArrayInputStream(this.tempMemoryBuffer.toByteArray());
    }

    public void write(byte[] b) throws IOException {
        this.size += (long)b.length;
        this.tempMemoryBuffer.write(b);
        this.checkSize();
    }

    public void write(int b) throws IOException {
        ++this.size;
        this.tempMemoryBuffer.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.size += (long)len;
        this.tempMemoryBuffer.write(b, off, len);
    }

    private void checkSize() throws IOException {
        if (this.tempMemoryBuffer == null) {
            return;
        }
        if (this.tempMemoryBuffer.size() < this.maxMemorySize) {
            return;
        }
        this.tempFile = File.createTempFile("" + System.currentTimeMillis(), ".buffer");
        this.fout = new FileOutputStream(this.tempFile);
        this.bufOut = new BufferedOutputStream(this.fout);
        this.bufOut.write(this.tempMemoryBuffer.toByteArray());
        this.tempMemoryBuffer = null;
    }

    public void flush() throws IOException {
        if (this.tempMemoryBuffer != null) {
            this.tempMemoryBuffer.flush();
        } else {
            this.bufOut.flush();
            this.fout.flush();
        }
    }

    public void close() throws IOException {
        if (this.tempMemoryBuffer != null) {
            this.tempMemoryBuffer.close();
        } else {
            this.bufOut.close();
            this.fout.close();
        }
        this.closed = true;
    }

    public long getSize() {
        return this.size;
    }

    File getTempFile() {
        return this.tempFile;
    }

    ByteArrayOutputStream getTempMemoryBuffer() {
        return this.tempMemoryBuffer;
    }
}

