/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.lang.reflect.Method;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.jacc.EJBMethodPermission;
import org.jboss.ejb.Container;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.ejb.plugins.SecurityActions;
import org.jboss.invocation.Invocation;
import org.jboss.metadata.BeanMetaData;

public class JaccAuthorizationInterceptor
extends AbstractInterceptor {
    protected Policy policy;
    protected String ejbName;
    protected CodeSource ejbCS;

    public void setContainer(Container container) {
        super.setContainer(container);
        if (container != null) {
            BeanMetaData beanMetaData = container.getBeanMetaData();
            this.ejbName = beanMetaData.getEjbName();
            this.ejbCS = container.getBeanClass().getProtectionDomain().getCodeSource();
            container.setJaccEnabled(true);
        }
        this.policy = Policy.getPolicy();
    }

    public void start() throws Exception {
        super.start();
    }

    public Object invokeHome(Invocation mi) throws Exception {
        this.checkSecurityAssociation(mi);
        Object returnValue = this.getNext().invokeHome(mi);
        return returnValue;
    }

    public Object invoke(Invocation mi) throws Exception {
        this.checkSecurityAssociation(mi);
        Object returnValue = this.getNext().invoke(mi);
        return returnValue;
    }

    protected void checkSecurityAssociation(Invocation mi) throws Exception {
        Method m = mi.getMethod();
        if (m == null) {
            return;
        }
        String iface = mi.getType().toInterfaceString();
        EJBMethodPermission methodPerm = new EJBMethodPermission(this.ejbName, iface, m);
        Subject caller = SecurityActions.getContextSubject();
        Principal[] principals = null;
        if (caller != null) {
            Set<Principal> principalsSet = caller.getPrincipals();
            principals = new Principal[principalsSet.size()];
            principalsSet.toArray(principals);
        }
        this.checkPolicy(principals, methodPerm, caller);
    }

    protected void checkPolicy(Principal[] principals, EJBMethodPermission methodPerm, Subject caller) {
        ProtectionDomain pd = new ProtectionDomain(this.ejbCS, null, null, principals);
        if (!this.policy.implies(pd, (Permission)methodPerm)) {
            String msg = "Denied: " + methodPerm + ", caller=" + caller;
            SecurityException e = new SecurityException(msg);
            throw e;
        }
    }
}

