/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.plugins.database.DatabaseComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomTableDiscoveryComponent
implements ResourceDiscoveryComponent<DatabaseComponent> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<DatabaseComponent> resourceDiscoveryContext) throws InvalidPluginConfigurationException, Exception {
        Set<DiscoveredResourceDetails> set;
        Statement statement = null;
        try {
            Connection conn = ((DatabaseComponent)resourceDiscoveryContext.getParentResourceComponent()).getConnection();
            Configuration config = resourceDiscoveryContext.getDefaultPluginConfiguration();
            String table = config.getSimpleValue("table", null);
            String resourceName = config.getSimpleValue("name", null);
            String resourceDescription = config.getSimpleValue("description", null);
            statement = conn.createStatement();
            statement.executeQuery("SELECT COUNT(*) FROM " + table);
            DiscoveredResourceDetails details = new DiscoveredResourceDetails(resourceDiscoveryContext.getResourceType(), table, resourceName, null, resourceDescription, config, null);
            set = Collections.singleton(details);
        }
        catch (SQLException sQLException) {
            JDBCUtil.safeClose(statement);
            catch (Throwable throwable) {
                JDBCUtil.safeClose(statement);
                throw throwable;
            }
        }
        JDBCUtil.safeClose((Statement)statement);
        return set;
        return Collections.emptySet();
    }
}

