/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.jboss.logging.Logger;
import org.jboss.ws.extensions.wsrm.server.RMServerSequence;

public final class RMStore {
    private static final Logger logger = Logger.getLogger(RMStore.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void serialize(String dataDir, RMServerSequence seq) {
        File dir = new File(dataDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File sequenceFile = new File(dir, seq.getId());
        if (seq.isTerminated() && sequenceFile.exists()) {
            sequenceFile.delete();
            return;
        }
        FileOutputStream fos = null;
        fos = new FileOutputStream(sequenceFile);
        fos.write(seq.toByteArray());
        Object var7_5 = null;
        if (fos == null) return;
        try {
            fos.close();
            return;
        }
        catch (IOException ioe2) {
            logger.error((Object)("Can't close sequence file " + sequenceFile.getName()), (Throwable)ioe2);
        }
        return;
        {
            catch (IOException ioe) {
                logger.error((Object)("Can't write sequence to file " + sequenceFile.getName()), (Throwable)ioe);
                Object var7_6 = null;
                if (fos == null) return;
                try {
                    fos.close();
                    return;
                }
                catch (IOException ioe2) {
                    logger.error((Object)("Can't close sequence file " + sequenceFile.getName()), (Throwable)ioe2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (IOException ioe2) {
                logger.error((Object)("Can't close sequence file " + sequenceFile.getName()), (Throwable)ioe2);
            }
            throw throwable;
        }
    }

    public static final RMServerSequence deserialize(String dataDir, String seqId, boolean inbound) {
        File[] sequences = new File(dataDir).listFiles();
        for (int i = 0; i < sequences.length; ++i) {
            try {
                boolean matches;
                RMServerSequence sequence = new RMServerSequence(sequences[i]);
                boolean bl = matches = inbound ? sequence.getInboundId().equals(seqId) : sequence.getOutboundId().equals(seqId);
                if (matches) {
                    return sequence;
                }
                if (sequence.getCreationTime() + sequence.getDuration() < System.currentTimeMillis()) continue;
                sequences[i].delete();
                continue;
            }
            catch (IOException ioe) {
                logger.error((Object)("Can't read sequence from file " + sequences[i].getName()), (Throwable)ioe);
            }
        }
        return null;
    }
}

