/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.content;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.server.content.ContentServerService;
import org.rhq.core.clientapi.server.content.DeletePackagesRequest;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.transfer.ContentResponseResult;
import org.rhq.core.domain.content.transfer.RemoveIndividualPackageResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.pc.content.ContentManager;
import org.rhq.core.util.exception.ThrowableUtil;

public class DeleteContentRunner
implements Runnable {
    private final Log log = LogFactory.getLog(DeleteContentRunner.class);
    private ContentManager contentManager;
    private DeletePackagesRequest request;

    public DeleteContentRunner(ContentManager contentManager, DeletePackagesRequest request) {
        this.contentManager = contentManager;
        this.request = request;
    }

    public void run() {
        ContentServerService serverService;
        RemovePackagesResponse response;
        try {
            response = this.contentManager.performPackageDelete(this.request.getResourceId(), this.request.getPackages());
        }
        catch (Throwable throwable) {
            response = new RemovePackagesResponse(ContentResponseResult.FAILURE);
            response.setOverallRequestErrorMessage(ThrowableUtil.getStackAsString((Throwable)throwable));
        }
        response.setRequestId(this.request.getRequestId());
        Set packageResponses = response.getPackageResponses();
        if (packageResponses != null) {
            HashSet<String> packageTypeNames = new HashSet<String>();
            for (RemoveIndividualPackageResponse individualResponse : packageResponses) {
                String packageTypeName;
                PackageDetailsKey key = individualResponse.getKey();
                if (key == null || packageTypeNames.contains(packageTypeName = key.getPackageTypeName())) continue;
                packageTypeNames.add(packageTypeName);
                try {
                    this.contentManager.executeResourcePackageDiscoveryImmediately(this.request.getRequestId(), individualResponse.getKey().getName());
                }
                catch (Throwable throwable) {
                    this.log.error((Object)"Error executing content discovery", throwable);
                }
            }
        }
        if ((serverService = this.contentManager.getContentServerService()) != null) {
            serverService.completeDeletePackageRequest(response);
        }
    }
}

