/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.plugin;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.metadata.PluginDependencyGraph;
import org.rhq.core.domain.resource.ClassLoaderType;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.plugin.CanonicalResourceKey;
import org.rhq.core.pc.plugin.PluginClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderManager {
    private final Log log = LogFactory.getLog(ClassLoaderManager.class);
    private final File tmpDir;
    private final PluginDependencyGraph pluginDependencyGraph;
    private final Map<String, URL> pluginNamesUrls;
    private final ClassLoader rootClassLoader;
    private final Map<String, ClassLoader> pluginClassLoaders;
    private final Map<String, ClassLoader> discoveryClassLoaders;
    private final Map<CanonicalResourceKey, ClassLoader> resourceClassLoaders;
    private final boolean createResourceClassLoaders;

    public ClassLoaderManager(Map<String, URL> pluginNamesUrls, PluginDependencyGraph graph, ClassLoader rootClassLoader, File tmpDir, boolean createResourceClassLoaders) {
        this.rootClassLoader = rootClassLoader;
        this.pluginClassLoaders = new HashMap<String, ClassLoader>();
        this.resourceClassLoaders = new HashMap<CanonicalResourceKey, ClassLoader>();
        this.discoveryClassLoaders = new HashMap<String, ClassLoader>();
        this.pluginNamesUrls = pluginNamesUrls;
        this.pluginDependencyGraph = graph;
        this.tmpDir = tmpDir;
        this.createResourceClassLoaders = createResourceClassLoaders;
    }

    public void destroy() {
        for (ClassLoader doomedCL : this.getUniqueResourceClassLoaders()) {
            if (!(doomedCL instanceof PluginClassLoader)) continue;
            ((PluginClassLoader)doomedCL).destroy();
        }
        this.resourceClassLoaders.clear();
        for (ClassLoader doomedCL : this.getUniqueDiscoveryClassLoaders()) {
            if (!(doomedCL instanceof PluginClassLoader)) continue;
            ((PluginClassLoader)doomedCL).destroy();
        }
        this.discoveryClassLoaders.clear();
        for (ClassLoader doomedCL : this.getUniquePluginClassLoaders()) {
            if (!(doomedCL instanceof PluginClassLoader)) continue;
            ((PluginClassLoader)doomedCL).destroy();
        }
        this.pluginClassLoaders.clear();
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.getClass().getSimpleName());
        Set<ClassLoader> classLoaders = this.getUniquePluginClassLoaders();
        str.append(" [#plugin CLs=").append(classLoaders.size());
        classLoaders.clear();
        classLoaders = this.getUniqueDiscoveryClassLoaders();
        str.append(", #discovery CLs=").append(classLoaders.size());
        classLoaders.clear();
        classLoaders = this.getUniqueResourceClassLoaders();
        str.append(", #resource CLs=").append(classLoaders.size());
        classLoaders.clear();
        str.append(']');
        return str.toString();
    }

    public ClassLoader getRootClassLoader() {
        return this.rootClassLoader;
    }

    public PluginDependencyGraph getPluginDependencyGraph() {
        return this.pluginDependencyGraph;
    }

    public synchronized ClassLoader obtainPluginClassLoader(String pluginName) throws PluginContainerException {
        ClassLoader cl = this.pluginClassLoaders.get(pluginName);
        if (cl == null) {
            ClassLoader parentClassLoader;
            URL pluginJarUrl = this.pluginNamesUrls.get(pluginName);
            String useClassesDep = this.pluginDependencyGraph.getUseClassesDependency(pluginName);
            if (useClassesDep != null) {
                parentClassLoader = this.obtainPluginClassLoader(useClassesDep);
                if (this.log.isDebugEnabled()) {
                    List dependencies = this.pluginDependencyGraph.getPluginDependencies(pluginName);
                    this.log.debug((Object)("Creating classloader for dependent plugin [" + pluginName + "] from URL [" + pluginJarUrl + "] that has the following dependencies: " + dependencies));
                }
            } else {
                parentClassLoader = this.rootClassLoader;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Creating classloader for independent plugin [" + pluginName + "] from URL [" + pluginJarUrl + ']'));
                }
            }
            cl = this.createClassLoader(pluginJarUrl, null, parentClassLoader);
            this.pluginClassLoaders.put(pluginName, cl);
        }
        return cl;
    }

    public synchronized ClassLoader obtainDiscoveryClassLoader(String pluginName, ClassLoader parentClassLoader) throws PluginContainerException {
        String hash = pluginName + '-' + Integer.toHexString(parentClassLoader.hashCode());
        ClassLoader cl = this.discoveryClassLoaders.get(hash);
        if (cl == null) {
            URL pluginJarUrl = this.pluginNamesUrls.get(pluginName);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Creating discovery classloader [" + hash + "] from URL [" + pluginJarUrl + ']'));
            }
            cl = this.createClassLoader(pluginJarUrl, null, parentClassLoader);
            this.discoveryClassLoaders.put(hash, cl);
        }
        return cl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized ClassLoader obtainResourceClassLoader(Resource resource, ResourceContainer parent, List<URL> additionalJars) throws PluginContainerException {
        if (resource == null) {
            throw new PluginContainerException("resource must not be null");
        }
        if (parent == null) {
            throw new PluginContainerException("parent must not be null");
        }
        CanonicalResourceKey mapKey = new CanonicalResourceKey(resource, parent.getResource());
        ClassLoader resourceCL = this.resourceClassLoaders.get(mapKey);
        if (resourceCL != null) return resourceCL;
        if (this.createResourceClassLoaders) {
            ResourceType resourceType = resource.getResourceType();
            String resourcePlugin = resourceType.getPlugin();
            ClassLoaderType resourceClassLoaderType = resourceType.getClassLoaderType();
            ResourceType parentResourceType = parent.getResource().getResourceType();
            String parentPlugin = parentResourceType.getPlugin();
            ClassLoaderType parentClassLoaderType = parentResourceType.getClassLoaderType();
            if (resourcePlugin.equals(parentPlugin)) {
                resourceCL = parent.getResourceClassLoader();
            } else {
                URL resourcePluginUrl;
                boolean isParentTopPlatform = false;
                if (parentClassLoaderType == ClassLoaderType.SHARED) {
                    InventoryManager inventoryMgr = PluginContainer.getInstance().getInventoryManager();
                    isParentTopPlatform = parent.getResource().equals((Object)inventoryMgr.getPlatform());
                }
                if (resourceClassLoaderType == ClassLoaderType.SHARED && parentClassLoaderType == ClassLoaderType.SHARED) {
                    resourceCL = isParentTopPlatform ? this.obtainPluginClassLoader(resourcePlugin) : this.obtainPluginClassLoader(resourcePlugin);
                } else if (resourceClassLoaderType == ClassLoaderType.INSTANCE && parentClassLoaderType == ClassLoaderType.SHARED) {
                    resourceCL = isParentTopPlatform ? this.createClassLoader(this.pluginNamesUrls.get(resourcePlugin), additionalJars, this.obtainPluginClassLoader(resourcePlugin).getParent()) : this.createClassLoader(this.pluginNamesUrls.get(resourcePlugin), additionalJars, this.obtainPluginClassLoader(parentPlugin));
                } else if (resourceClassLoaderType == ClassLoaderType.SHARED && parentClassLoaderType == ClassLoaderType.INSTANCE) {
                    resourcePluginUrl = this.pluginNamesUrls.get(resourcePlugin);
                    ClassLoader parentClassLoader = parent.getResourceClassLoader();
                    resourceCL = this.createClassLoader(resourcePluginUrl, additionalJars, parentClassLoader);
                } else {
                    if (resourceClassLoaderType != ClassLoaderType.INSTANCE || parentClassLoaderType != ClassLoaderType.INSTANCE) throw new IllegalStateException("Classloader type was never set. rclt=[" + resourceClassLoaderType + "], pclt=[" + parentClassLoaderType + "]");
                    resourcePluginUrl = this.pluginNamesUrls.get(resourcePlugin);
                    ClassLoader parentClassLoader = parent.getResourceClassLoader();
                    resourceCL = this.createClassLoader(resourcePluginUrl, additionalJars, parentClassLoader);
                }
            }
        } else {
            ResourceType resourceType = resource.getResourceType();
            String resourcePlugin = resourceType.getPlugin();
            resourceCL = this.obtainPluginClassLoader(resourcePlugin);
        }
        this.resourceClassLoaders.put(mapKey, resourceCL);
        return resourceCL;
    }

    public synchronized int getNumberOfPluginClassLoaders() {
        return this.pluginClassLoaders.size();
    }

    public synchronized int getNumberOfDiscoveryClassLoaders() {
        return this.discoveryClassLoaders.size();
    }

    public synchronized int getNumberOfResourceClassLoaders() {
        Set<ClassLoader> uniqueClassLoaders = this.getUniqueResourceClassLoaders();
        int size = uniqueClassLoaders.size();
        uniqueClassLoaders.clear();
        return size;
    }

    public synchronized Map<String, ClassLoader> getPluginClassLoaders() {
        return new HashMap<String, ClassLoader>(this.pluginClassLoaders);
    }

    public synchronized Map<String, ClassLoader> getDiscoveryClassLoaders() {
        return new HashMap<String, ClassLoader>(this.discoveryClassLoaders);
    }

    public synchronized Map<CanonicalResourceKey, ClassLoader> getResourceClassLoaders() {
        return new HashMap<CanonicalResourceKey, ClassLoader>(this.resourceClassLoaders);
    }

    private Set<ClassLoader> getUniquePluginClassLoaders() {
        HashSet<ClassLoader> uniqueClassLoaders = new HashSet<ClassLoader>(this.pluginClassLoaders.values());
        return uniqueClassLoaders;
    }

    private Set<ClassLoader> getUniqueDiscoveryClassLoaders() {
        HashSet<ClassLoader> uniqueClassLoaders = new HashSet<ClassLoader>(this.discoveryClassLoaders.values());
        return uniqueClassLoaders;
    }

    private Set<ClassLoader> getUniqueResourceClassLoaders() {
        HashSet<ClassLoader> uniqueClassLoaders = new HashSet<ClassLoader>(this.resourceClassLoaders.values());
        return uniqueClassLoaders;
    }

    private ClassLoader createClassLoader(URL mainJarUrl, List<URL> additionalJars, ClassLoader parentClassLoader) throws PluginContainerException {
        ClassLoader classLoader;
        if (parentClassLoader == null) {
            parentClassLoader = this.getClass().getClassLoader();
        }
        if (mainJarUrl != null) {
            String pluginJarName = new File(mainJarUrl.getPath()).getName();
            if (additionalJars == null || additionalJars.size() == 0) {
                classLoader = PluginClassLoader.create(pluginJarName, mainJarUrl, true, parentClassLoader, this.tmpDir);
            } else {
                ArrayList<URL> allJars = new ArrayList<URL>(additionalJars.size() + 1);
                allJars.add(mainJarUrl);
                allJars.addAll(additionalJars);
                classLoader = PluginClassLoader.create(pluginJarName, allJars.toArray(new URL[allJars.size()]), true, parentClassLoader, this.tmpDir);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Created classloader for plugin jar [" + mainJarUrl + "] with additional jars [" + additionalJars + "]"));
            }
        } else {
            classLoader = parentClassLoader;
        }
        return classLoader;
    }
}

