/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.util;

import java.io.File;
import java.io.FileInputStream;

public class DumpBytes {
    public static final int BASE_HEX = 16;
    public static final int BASE_DEC = 10;
    public static final int BASE_OCT = 8;
    public static final int BASE_BIN = 2;

    public static String dumpData(byte[] bytes, int cols, int format) {
        int char_col_width;
        int num_col_width;
        StringBuffer result = new StringBuffer(1024);
        String nums = "";
        String chars = "";
        if (format < 2 || format > 16) {
            throw new IllegalArgumentException("format=" + format);
        }
        if (format < 3) {
            num_col_width = 9;
            char_col_width = 1;
        } else if (format < 8) {
            num_col_width = 6;
            char_col_width = 1;
        } else if (format < 10) {
            num_col_width = 5;
            char_col_width = 1;
        } else if (format < 16) {
            num_col_width = 4;
            char_col_width = 1;
        } else {
            num_col_width = 3;
            char_col_width = 1;
        }
        for (int i = 0; i < bytes.length; ++i) {
            if (i % cols == 0 && i != 0) {
                result.append(nums);
                result.append("   ");
                result.append(chars);
                result.append('\n');
                nums = "";
                chars = "";
            }
            String byte_str = Integer.toString(bytes[i] & 0xFF, format);
            nums = nums + DumpBytes.padFront(byte_str, num_col_width);
            chars = chars + DumpBytes.padFront(DumpBytes.toCharString(bytes[i]), char_col_width);
        }
        result.append(DumpBytes.padBack(nums, cols * num_col_width));
        result.append("   ");
        result.append(DumpBytes.padBack(chars, cols * char_col_width));
        result.append('\n');
        return result.toString();
    }

    public static String dumpData(String data, int cols, int format) {
        return DumpBytes.dumpData(data.getBytes(), cols, format);
    }

    public static String dumpData(File file, int cols, int format) {
        try {
            FileInputStream fis = new FileInputStream(file);
            byte[] file_contents = new byte[(int)file.length()];
            int num_bytes = fis.read(file_contents);
            if (num_bytes != file_contents.length) {
                throw new IllegalStateException(num_bytes + "!=" + file_contents.length);
            }
            return DumpBytes.dumpData(file_contents, cols, format);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String dumpBinData(File f) {
        return DumpBytes.dumpData(f, 7, 2);
    }

    public static String dumpBinData(byte[] data) {
        return DumpBytes.dumpData(data, 7, 2);
    }

    public static String dumpBinData(String data) {
        return DumpBytes.dumpData(data, 7, 2);
    }

    public static String dumpOctData(File f) {
        return DumpBytes.dumpData(f, 9, 8);
    }

    public static String dumpOctData(byte[] data) {
        return DumpBytes.dumpData(data, 9, 8);
    }

    public static String dumpOctData(String data) {
        return DumpBytes.dumpData(data, 9, 8);
    }

    public static String dumpDecData(File f) {
        return DumpBytes.dumpData(f, 12, 10);
    }

    public static String dumpDecData(byte[] data) {
        return DumpBytes.dumpData(data, 12, 10);
    }

    public static String dumpDecData(String data) {
        return DumpBytes.dumpData(data, 12, 10);
    }

    public static String dumpHexData(File f) {
        return DumpBytes.dumpData(f, 15, 16);
    }

    public static String dumpHexData(byte[] data) {
        return DumpBytes.dumpData(data, 15, 16);
    }

    public static String dumpHexData(String data) {
        return DumpBytes.dumpData(data, 15, 16);
    }

    private static String padBack(String s, int len) {
        String spaces = "";
        for (int i = 0; i < len - s.length(); ++i) {
            spaces = spaces + " ";
        }
        return s + spaces;
    }

    private static String padFront(String s, int len) {
        String spaces = "";
        for (int i = 0; i < len - s.length(); ++i) {
            spaces = spaces + " ";
        }
        return spaces + s;
    }

    private static String toCharString(byte b) {
        if (Character.isWhitespace((char)b)) {
            return " ";
        }
        if (Character.isISOControl((char)b)) {
            return ".";
        }
        return "" + (char)b;
    }
}

