/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.configuration.propset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rhq.core.domain.configuration.AbstractPropertyMap;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.gui.configuration.ConfigurationMaskingUtility;
import org.rhq.core.gui.configuration.propset.ConfigurationSetMember;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationSet {
    private ConfigurationDefinition configurationDefinition;
    private List<ConfigurationSetMember> members;
    private Configuration groupConfiguration;

    public ConfigurationSet(ConfigurationDefinition configurationDefinition, List<ConfigurationSetMember> members) {
        if (configurationDefinition == null) {
            throw new IllegalArgumentException("configurationDefinition parameter is null.");
        }
        this.configurationDefinition = configurationDefinition;
        if (members == null) {
            throw new IllegalArgumentException("members parameter is null.");
        }
        this.members = members;
        this.groupConfiguration = new Configuration();
        this.calculateGroupConfiguration();
    }

    public void calculateGroupConfiguration() {
        this.groupConfiguration.getMap().clear();
        if (this.members.isEmpty()) {
            return;
        }
        Map childPropertyDefinitions = this.configurationDefinition.getPropertyDefinitions();
        ArrayList<AbstractPropertyMap> sourceParentPropertyMaps = new ArrayList<AbstractPropertyMap>();
        for (ConfigurationSetMember member : this.members) {
            sourceParentPropertyMaps.add((AbstractPropertyMap)member.getConfiguration());
        }
        for (PropertyDefinition childPropertyDefinition : childPropertyDefinitions.values()) {
            ConfigurationSet.calculateGroupProperty(childPropertyDefinition, sourceParentPropertyMaps, (AbstractPropertyMap)this.groupConfiguration);
        }
    }

    public void applyGroupConfiguration() {
        if (this.members.isEmpty()) {
            return;
        }
        Map childPropertyDefinitions = this.configurationDefinition.getPropertyDefinitions();
        ArrayList<AbstractPropertyMap> sourceParentPropertyMaps = new ArrayList<AbstractPropertyMap>();
        for (ConfigurationSetMember member : this.members) {
            sourceParentPropertyMaps.add((AbstractPropertyMap)member.getConfiguration());
        }
        for (PropertyDefinition childPropertyDefinition : childPropertyDefinitions.values()) {
            ConfigurationSet.mergeProperty(childPropertyDefinition, sourceParentPropertyMaps, (AbstractPropertyMap)this.groupConfiguration);
        }
    }

    public ConfigurationDefinition getConfigurationDefinition() {
        return this.configurationDefinition;
    }

    public List<ConfigurationSetMember> getMembers() {
        return this.members;
    }

    public Configuration getGroupConfiguration() {
        return this.groupConfiguration;
    }

    public void mask() {
        for (ConfigurationSetMember member : this.members) {
            ConfigurationMaskingUtility.maskConfiguration(member.getConfiguration(), this.configurationDefinition);
        }
        ConfigurationMaskingUtility.maskConfiguration(this.groupConfiguration, this.configurationDefinition);
    }

    public void unmask() {
        for (ConfigurationSetMember member : this.members) {
            ConfigurationMaskingUtility.unmaskConfiguration(member.getConfiguration(), this.configurationDefinition);
        }
        ConfigurationMaskingUtility.unmaskConfiguration(this.groupConfiguration, this.configurationDefinition);
    }

    private static void calculateGroupProperty(PropertyDefinition propertyDefinition, List<AbstractPropertyMap> sourceParentPropertyMaps, AbstractPropertyMap targetParentPropertyMap) {
        if (propertyDefinition instanceof PropertyDefinitionSimple) {
            String sampleValue = ConfigurationSet.getSimpleValue(sourceParentPropertyMaps.get(0), propertyDefinition.getName());
            boolean valuesHomogenous = true;
            for (int i = 1; i < sourceParentPropertyMaps.size(); ++i) {
                String value = ConfigurationSet.getSimpleValue(sourceParentPropertyMaps.get(i), propertyDefinition.getName());
                if ((value != null || sampleValue == null) && (value == null || value.equals(sampleValue))) continue;
                valuesHomogenous = false;
                break;
            }
            PropertySimple propertySimple = new PropertySimple(propertyDefinition.getName(), (Object)(valuesHomogenous ? sampleValue : null));
            targetParentPropertyMap.put((Property)propertySimple);
            if (valuesHomogenous) {
                propertySimple.setOverride(Boolean.valueOf(true));
            }
        } else if (propertyDefinition instanceof PropertyDefinitionMap) {
            ArrayList<AbstractPropertyMap> nestedSourceParentPropertyMaps = new ArrayList<AbstractPropertyMap>();
            for (AbstractPropertyMap sourceParentPropertyMap : sourceParentPropertyMaps) {
                PropertyMap nestedSourceParentPropertyMap = sourceParentPropertyMap.getMap(propertyDefinition.getName());
                nestedSourceParentPropertyMaps.add((AbstractPropertyMap)(nestedSourceParentPropertyMap != null ? nestedSourceParentPropertyMap : new PropertyMap(propertyDefinition.getName())));
            }
            PropertyMap targetPropertyMap = new PropertyMap(propertyDefinition.getName());
            targetParentPropertyMap.put((Property)targetPropertyMap);
            ConfigurationSet.calculateGroupPropertyMap((PropertyDefinitionMap)propertyDefinition, nestedSourceParentPropertyMaps, (AbstractPropertyMap)targetPropertyMap);
        } else if (propertyDefinition instanceof PropertyDefinitionList) {
            PropertyDefinitionList propertyDefinitionList = (PropertyDefinitionList)propertyDefinition;
            PropertyDefinition listMemberPropertyDefinition = propertyDefinitionList.getMemberDefinition();
            PropertyList targetPropertyList = new PropertyList(propertyDefinition.getName());
            targetParentPropertyMap.put((Property)targetPropertyList);
            if (listMemberPropertyDefinition instanceof PropertyDefinitionMap) {
                PropertyDefinitionMap propertyDefinitionMap = (PropertyDefinitionMap)listMemberPropertyDefinition;
            }
        }
    }

    private static void calculateGroupPropertyMap(PropertyDefinitionMap propertyDefinitionMap, List<AbstractPropertyMap> sourceParentPropertyMaps, AbstractPropertyMap targetParentPropertyMap) {
        Map childPropertyDefinitions = propertyDefinitionMap.getPropertyDefinitions();
        if (!childPropertyDefinitions.isEmpty()) {
            for (PropertyDefinition childPropertyDefinition : childPropertyDefinitions.values()) {
                ConfigurationSet.calculateGroupProperty(childPropertyDefinition, sourceParentPropertyMaps, targetParentPropertyMap);
            }
        } else {
            ConfigurationSet.calculateGroupOpenPropertyMap(sourceParentPropertyMaps, targetParentPropertyMap);
        }
    }

    private static void calculateGroupOpenPropertyMap(List<AbstractPropertyMap> sourceParentPropertyMaps, AbstractPropertyMap targetParentPropertyMap) {
        Map<String, Map<String, Integer>> memberNameValueFrequenciesMap = ConfigurationSet.createMemberNameValueFrequenciesMap(sourceParentPropertyMaps);
        for (String memberName : memberNameValueFrequenciesMap.keySet()) {
            PropertySimple member = new PropertySimple(memberName, null);
            targetParentPropertyMap.put((Property)member);
            for (AbstractPropertyMap map : sourceParentPropertyMaps) {
                if (map.get(memberName) != null) continue;
                map.put((Property)new PropertySimple(memberName, null));
            }
            Map<String, Integer> valueFrequencies = memberNameValueFrequenciesMap.get(memberName);
            if (valueFrequencies.size() != 1 || valueFrequencies.values().iterator().next().intValue() != sourceParentPropertyMaps.size()) continue;
            member.setOverride(Boolean.valueOf(true));
            member.setStringValue(valueFrequencies.keySet().iterator().next());
        }
    }

    private static void mergeProperty(PropertyDefinition propertyDefinition, List<AbstractPropertyMap> memberParentPropertyMaps, AbstractPropertyMap groupParentPropertyMap) {
        if (propertyDefinition instanceof PropertyDefinitionSimple) {
            PropertySimple propertySimple = groupParentPropertyMap.getSimple(propertyDefinition.getName());
            if (propertySimple != null && propertySimple.getOverride() != null && propertySimple.getOverride().booleanValue()) {
                for (AbstractPropertyMap sourceParentPropertyMap : memberParentPropertyMaps) {
                    PropertySimple sourcePropertySimple = sourceParentPropertyMap.getSimple(propertyDefinition.getName());
                    if (sourcePropertySimple == null) {
                        sourcePropertySimple = new PropertySimple(propertyDefinition.getName(), (Object)propertySimple.getStringValue());
                        sourceParentPropertyMap.put((Property)sourcePropertySimple);
                        continue;
                    }
                    sourcePropertySimple.setStringValue(propertySimple.getStringValue());
                }
            }
        } else if (propertyDefinition instanceof PropertyDefinitionMap) {
            ArrayList<AbstractPropertyMap> nestedSourceParentPropertyMaps = new ArrayList<AbstractPropertyMap>();
            for (AbstractPropertyMap sourceParentPropertyMap : memberParentPropertyMaps) {
                nestedSourceParentPropertyMaps.add((AbstractPropertyMap)sourceParentPropertyMap.getMap(propertyDefinition.getName()));
            }
            PropertyMap groupPropertyMap = groupParentPropertyMap.getMap(propertyDefinition.getName());
            groupParentPropertyMap.put((Property)groupPropertyMap);
            ConfigurationSet.mergePropertyMap((PropertyDefinitionMap)propertyDefinition, nestedSourceParentPropertyMaps, (AbstractPropertyMap)groupPropertyMap);
        } else if (propertyDefinition instanceof PropertyDefinitionList) {
            PropertyDefinitionList propertyDefinitionList = (PropertyDefinitionList)propertyDefinition;
            PropertyDefinition listMemberPropertyDefinition = propertyDefinitionList.getMemberDefinition();
            PropertyList groupPropertyList = groupParentPropertyMap.getList(propertyDefinition.getName());
            if (listMemberPropertyDefinition instanceof PropertyDefinitionMap) {
                PropertyDefinitionMap propertyDefinitionMap = (PropertyDefinitionMap)listMemberPropertyDefinition;
            }
        }
    }

    private static void mergePropertyMap(PropertyDefinitionMap propertyDefinitionMap, List<AbstractPropertyMap> memberParentPropertyMaps, AbstractPropertyMap groupParentPropertyMap) {
        Map childPropertyDefinitions = propertyDefinitionMap.getPropertyDefinitions();
        if (!childPropertyDefinitions.isEmpty()) {
            for (PropertyDefinition childPropertyDefinition : childPropertyDefinitions.values()) {
                ConfigurationSet.mergeProperty(childPropertyDefinition, memberParentPropertyMaps, groupParentPropertyMap);
            }
        } else {
            ConfigurationSet.mergeOpenPropertyMap(memberParentPropertyMaps, groupParentPropertyMap);
        }
    }

    private static void mergeOpenPropertyMap(List<AbstractPropertyMap> memberParentPropertyMaps, AbstractPropertyMap groupParentPropertyMap) {
        for (String groupMemberPropertyName : groupParentPropertyMap.getMap().keySet()) {
            PropertySimple groupMemberProperty = groupParentPropertyMap.getSimple(groupMemberPropertyName);
            if (groupMemberProperty == null || groupMemberProperty.getOverride() == null || !groupMemberProperty.getOverride().booleanValue()) continue;
            for (AbstractPropertyMap sourceParentPropertyMap : memberParentPropertyMaps) {
                PropertySimple sourcePropertySimple = sourceParentPropertyMap.getSimple(groupMemberPropertyName);
                if (sourcePropertySimple == null) {
                    sourcePropertySimple = new PropertySimple(groupMemberPropertyName, (Object)groupMemberProperty.getStringValue());
                    sourceParentPropertyMap.put((Property)sourcePropertySimple);
                    continue;
                }
                sourcePropertySimple.setStringValue(groupMemberProperty.getStringValue());
            }
        }
    }

    private static Map<String, Map<String, Integer>> createMemberNameValueFrequenciesMap(List<AbstractPropertyMap> sourceParentPropertyMaps) {
        HashMap<String, Map<String, Integer>> nameValueFrequenciesMap = new HashMap<String, Map<String, Integer>>();
        for (AbstractPropertyMap map : sourceParentPropertyMaps) {
            for (String propertyName : map.getMap().keySet()) {
                PropertySimple propertySimple = map.getSimple(propertyName);
                String propertyValue = propertySimple != null ? propertySimple.getStringValue() : null;
                HashMap<String, Integer> valueFrequencies = (HashMap<String, Integer>)nameValueFrequenciesMap.get(propertyName);
                if (valueFrequencies == null) {
                    valueFrequencies = new HashMap<String, Integer>();
                    nameValueFrequenciesMap.put(propertyName, valueFrequencies);
                }
                Integer valueFrequency = valueFrequencies.containsKey(propertyValue) ? (Integer)valueFrequencies.get(propertyValue) + 1 : 1;
                valueFrequencies.put(propertyValue, valueFrequency);
            }
        }
        return nameValueFrequenciesMap;
    }

    private static String getSimpleValue(AbstractPropertyMap parentPropertyMap, String propertyName) {
        PropertySimple samplePropertySimple = parentPropertyMap.getSimple(propertyName);
        return samplePropertySimple != null ? samplePropertySimple.getStringValue() : null;
    }
}

