/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.system;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Locale;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.NetConnection;
import org.hyperic.sigar.Swap;
import org.rhq.core.system.CpuInformation;
import org.rhq.core.system.FileSystemInfo;
import org.rhq.core.system.NetworkAdapterInfo;
import org.rhq.core.system.NetworkAdapterStats;
import org.rhq.core.system.NetworkStats;
import org.rhq.core.system.OperatingSystemType;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.system.ServiceInfo;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.system.SystemInfoException;
import org.rhq.core.util.exec.ProcessExecutor;
import org.rhq.core.util.exec.ProcessExecutorResults;
import org.rhq.core.util.exec.ProcessToStart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSystemInfo
implements SystemInfo {
    @Override
    public boolean isNative() {
        return false;
    }

    @Override
    public OperatingSystemType getOperatingSystemType() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        if (osName.indexOf("windows") > -1) {
            return OperatingSystemType.WINDOWS;
        }
        if (osName.indexOf("linux") > -1) {
            return OperatingSystemType.LINUX;
        }
        if (osName.indexOf("solaris") > -1 || osName.indexOf("sunos") > -1) {
            return OperatingSystemType.SOLARIS;
        }
        if (osName.indexOf("bsd") > -1) {
            return OperatingSystemType.BSD;
        }
        if (osName.indexOf("aix") > -1) {
            return OperatingSystemType.AIX;
        }
        if (osName.indexOf("hp-ux") > -1) {
            return OperatingSystemType.HPUX;
        }
        if (osName.indexOf("mac") > -1) {
            return OperatingSystemType.OSX;
        }
        return OperatingSystemType.JAVA;
    }

    @Override
    public String getOperatingSystemName() {
        return System.getProperty("os.name");
    }

    @Override
    public String getOperatingSystemVersion() {
        return System.getProperty("os.version");
    }

    @Override
    public String getHostname() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            throw this.getUnsupportedException(e);
        }
    }

    @Override
    public List<NetworkAdapterInfo> getAllNetworkAdapters() throws SystemInfoException {
        throw this.getUnsupportedException("Cannot get list of network adaptors without native support");
    }

    @Override
    public List<ServiceInfo> getAllServices() throws UnsupportedOperationException {
        throw this.getUnsupportedException("Cannot get list of installed services without native support");
    }

    @Override
    public List<ProcessInfo> getAllProcesses() throws UnsupportedOperationException {
        throw this.getUnsupportedException("Cannot get the process table information without native support");
    }

    @Override
    public List<ProcessInfo> getProcesses(String processInfoQuery) {
        throw this.getUnsupportedException("Cannot get the process table information without native support");
    }

    @Override
    public ProcessInfo getThisProcess() {
        throw this.getUnsupportedException("Cannot get information on this process without native support");
    }

    @Override
    public ProcessExecutionResults executeProcess(ProcessExecution processExecution) {
        ProcessToStart process = new ProcessToStart();
        ProcessExecutionResults executionResults = new ProcessExecutionResults();
        process.setProgramExecutable(processExecution.getExecutable());
        process.setCheckExecutableExists(Boolean.valueOf(processExecution.isCheckExecutableExists()));
        process.setArguments(processExecution.getArgumentsAsArray());
        process.setEnvironment(processExecution.getEnvironmentVariablesAsArray());
        process.setWorkingDirectory(processExecution.getWorkingDirectory());
        process.setWaitForExit(Long.valueOf(processExecution.getWaitForCompletion()));
        process.setCaptureOutput(Boolean.valueOf(processExecution.isCaptureOutput()));
        process.setKillOnTimeout(Boolean.valueOf(processExecution.isKillOnTimeout()));
        if (processExecution.isCaptureOutput()) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            process.setOutputStream((OutputStream)outputStream);
            executionResults.setCapturedOutputStream(outputStream);
        }
        ProcessExecutor javaExec = new ProcessExecutor();
        ProcessExecutorResults javaExecResults = javaExec.execute(process);
        executionResults.setExitCode(javaExecResults.getExitCode());
        executionResults.setError(javaExecResults.getError());
        return executionResults;
    }

    @Override
    public int getNumberOfCpus() {
        throw this.getUnsupportedException("Cannot get the number of CPUs without native support");
    }

    @Override
    public Mem getMemoryInfo() {
        throw this.getUnsupportedException("Cannot get any information about memory without native support");
    }

    @Override
    public Swap getSwapInfo() {
        throw this.getUnsupportedException("Cannot get any information about swap without native support");
    }

    @Override
    public String readLineFromConsole(boolean noEcho) throws IOException {
        return new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    @Override
    public void writeLineToConsole(String line) throws IOException {
        System.out.print(line);
    }

    @Override
    public CpuInformation getCpu(int cpuIndex) {
        throw this.getUnsupportedException("Cannot get CPU information without native support");
    }

    @Override
    public List<FileSystemInfo> getFileSystems() {
        throw this.getUnsupportedException("Cannot get file systems information");
    }

    @Override
    public FileSystemInfo getFileSystem(String directory) {
        throw this.getUnsupportedException("Cannot get file system information");
    }

    @Override
    public NetworkAdapterStats getNetworkAdapterStats(String interfaceName) {
        throw this.getUnsupportedException("Cannot get network adapter stats");
    }

    @Override
    public NetworkStats getNetworkStats(String addressName, int port) {
        throw this.getUnsupportedException("Cannot get network stats");
    }

    @Override
    public List<NetConnection> getNetworkConnections(String addressName, int port) {
        throw this.getUnsupportedException("Cannot get network connections");
    }

    JavaSystemInfo() {
    }

    private UnsupportedOperationException getUnsupportedException(Exception e) {
        return new UnsupportedOperationException("No native library available - " + e, e);
    }

    private UnsupportedOperationException getUnsupportedException(String err) {
        return new UnsupportedOperationException("No native library available - " + err);
    }

    @Override
    public String getSystemArchitecture() {
        return System.getProperty("os.arch");
    }
}

