/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.WeakHashMap;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javax.naming.InitialContext;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityDomain;
import org.jboss.security.ssl.Context;
import org.jboss.security.ssl.DomainServerSocket;

public class DomainServerSocketFactory
extends SSLServerSocketFactory {
    private static Logger log = Logger.getLogger(DomainServerSocketFactory.class);
    private static WeakHashMap sessionMap = new WeakHashMap();
    private transient SecurityDomain securityDomain;
    private transient InetAddress bindAddress;
    private transient SSLContext sslCtx = null;
    private boolean wantsClientAuth = true;
    private boolean needsClientAuth = false;
    private String[] cipherSuites;
    private String[] protocols;

    public static ServerSocketFactory getDefault() {
        DomainServerSocketFactory ssf = null;
        try {
            InitialContext iniCtx = new InitialContext();
            SecurityDomain sd = (SecurityDomain)iniCtx.lookup("java:/jaas/other");
            ssf = new DomainServerSocketFactory(sd);
        }
        catch (Exception e) {
            log.error((Object)"Failed to create default ServerSocketFactory", (Throwable)e);
        }
        return ssf;
    }

    public static synchronized SSLSession getSSLSession(String sessionID) {
        SSLSession session = (SSLSession)sessionMap.get(sessionID);
        return session;
    }

    static synchronized SSLSession putSSLSession(String sessionID, SSLSession session) {
        SSLSession prevSession = sessionMap.put(sessionID, session);
        return prevSession;
    }

    static synchronized SSLSession removeSSLSession(String sessionID) {
        SSLSession session = (SSLSession)sessionMap.remove(sessionID);
        return session;
    }

    public DomainServerSocketFactory() {
    }

    public DomainServerSocketFactory(SecurityDomain securityDomain) throws IOException {
        if (securityDomain == null) {
            throw new IOException("The securityDomain may not be null");
        }
        this.securityDomain = securityDomain;
    }

    public String getBindAddress() {
        String address = null;
        if (this.bindAddress != null) {
            address = this.bindAddress.getHostAddress();
        }
        return address;
    }

    public void setBindAddress(String host) throws UnknownHostException {
        this.bindAddress = InetAddress.getByName(host);
    }

    public SecurityDomain getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(SecurityDomain securityDomain) {
        this.securityDomain = securityDomain;
    }

    public boolean isWantsClientAuth() {
        return this.wantsClientAuth;
    }

    public void setWantsClientAuth(boolean wantsClientAuth) {
        this.wantsClientAuth = wantsClientAuth;
    }

    public boolean isNeedsClientAuth() {
        return this.needsClientAuth;
    }

    public void setNeedsClientAuth(boolean needsClientAuth) {
        this.needsClientAuth = needsClientAuth;
    }

    public String[] getCipherSuites() {
        return this.cipherSuites;
    }

    public void setCipherSuites(String[] cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    public String[] getCiperSuites() {
        return this.cipherSuites;
    }

    public void setCiperSuites(String[] cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    public String[] getProtocols() {
        return this.protocols;
    }

    public void setProtocols(String[] protocols) {
        this.protocols = protocols;
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        return this.createServerSocket(port, 50, this.bindAddress);
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        return this.createServerSocket(port, backlog, this.bindAddress);
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        this.initSSLContext();
        SSLServerSocketFactory factory = this.sslCtx.getServerSocketFactory();
        SSLServerSocket socket = (SSLServerSocket)factory.createServerSocket(port, backlog, ifAddress);
        SSLSessionContext ctx = this.sslCtx.getServerSessionContext();
        System.out.println(ctx);
        if (log.isTraceEnabled()) {
            String[] supportedProtocols = socket.getSupportedProtocols();
            log.debug((Object)("Supported protocols: " + Arrays.asList(supportedProtocols)));
            String[] supportedCipherSuites = socket.getSupportedCipherSuites();
            log.debug((Object)("Supported CipherSuites: " + Arrays.asList(supportedCipherSuites)));
        }
        socket.setNeedClientAuth(this.needsClientAuth);
        socket.setWantClientAuth(this.wantsClientAuth);
        if (this.protocols != null) {
            socket.setEnabledProtocols(this.protocols);
        }
        if (this.cipherSuites != null) {
            socket.setEnabledCipherSuites(this.cipherSuites);
        }
        DomainServerSocket handler = new DomainServerSocket(socket);
        ProxyFactory pf = new ProxyFactory();
        pf.setHandler((MethodHandler)handler);
        pf.setSuperclass(SSLServerSocket.class);
        Class[] sig = new Class[]{};
        Object[] args = new Object[]{};
        SSLServerSocket proxy = null;
        try {
            proxy = (SSLServerSocket)pf.create(sig, args);
        }
        catch (Exception e) {
            IOException ioe = new IOException("Failed to create SSLServerSocket proxy");
            ioe.initCause(e);
            throw ioe;
        }
        return proxy;
    }

    public String[] getDefaultCipherSuites() {
        String[] cipherSuites = new String[]{};
        try {
            this.initSSLContext();
            SSLServerSocketFactory factory = this.sslCtx.getServerSocketFactory();
            cipherSuites = factory.getDefaultCipherSuites();
        }
        catch (IOException e) {
            log.error((Object)"Failed to get default SSLServerSocketFactory", (Throwable)e);
        }
        return cipherSuites;
    }

    public String[] getSupportedCipherSuites() {
        String[] cipherSuites = new String[]{};
        try {
            this.initSSLContext();
            SSLServerSocketFactory factory = this.sslCtx.getServerSocketFactory();
            cipherSuites = factory.getSupportedCipherSuites();
        }
        catch (IOException e) {
            log.error((Object)"Failed to get default SSLServerSocketFactory", (Throwable)e);
        }
        return cipherSuites;
    }

    private void initSSLContext() throws IOException {
        if (this.sslCtx != null) {
            return;
        }
        this.sslCtx = Context.forDomain(this.securityDomain);
    }
}

