/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.protocols.pbcast.Digest;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.Promise;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class STATE_TRANSFER
extends Protocol {
    Address local_addr = null;
    final Vector members = new Vector();
    long state_id = 1L;
    final Map state_requesters = new HashMap();
    boolean waiting_for_state_response = false;
    Digest digest = null;
    final HashMap map = new HashMap();
    long start;
    long stop;
    int num_state_reqs = 0;
    long num_bytes_sent = 0L;
    double avg_state_size = 0.0;
    static final String name = "STATE_TRANSFER";
    boolean use_flush = false;
    long flush_timeout = 4000L;
    Promise flush_promise;
    boolean flushProtocolInStack = false;
    static /* synthetic */ Class class$org$jgroups$protocols$pbcast$Digest;

    public String getName() {
        return name;
    }

    public int getNumberOfStateRequests() {
        return this.num_state_reqs;
    }

    public long getNumberOfStateBytesSent() {
        return this.num_bytes_sent;
    }

    public double getAverageStateSize() {
        return this.avg_state_size;
    }

    public Vector requiredDownServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(new Integer(42));
        retval.addElement(new Integer(41));
        return retval;
    }

    public void resetStats() {
        super.resetStats();
        this.num_state_reqs = 0;
        this.num_bytes_sent = 0L;
        this.avg_state_size = 0.0;
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        this.use_flush = Util.parseBoolean(props, "use_flush", false);
        this.flush_promise = new Promise();
        this.flush_timeout = Util.parseLong(props, "flush_timeout", this.flush_timeout);
        if (props.size() > 0) {
            this.log.error((Object)("the following properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    public void init() throws Exception {
        this.map.put("state_transfer", Boolean.TRUE);
        this.map.put("protocol_class", this.getClass().getName());
    }

    public void start() throws Exception {
        this.passUp(new Event(56, this.map));
        if (!this.flushProtocolInStack && this.use_flush) {
            this.log.warn((Object)"use_flush property is true, however, FLUSH protocol not found in stack");
            this.use_flush = false;
        }
    }

    public void stop() {
        super.stop();
        this.waiting_for_state_response = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void up(Event evt) {
        switch (evt.getType()) {
            case 16: {
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 6: 
            case 15: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 43: {
                Map map = this.state_requesters;
                synchronized (map) {
                    this.digest = (Digest)evt.getArg();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("GET_DIGEST_STATE_OK: digest is " + this.digest + "\npassUp(GET_APPLSTATE)"));
                    }
                    this.requestApplicationStates();
                }
                return;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                if (!(msg.getHeader(name) instanceof StateHeader)) break;
                StateHeader hdr = (StateHeader)msg.removeHeader(name);
                switch (hdr.type) {
                    case 1: {
                        this.handleStateReq(hdr);
                        break;
                    }
                    case 2: {
                        this.handleStateRsp(hdr, msg.getBuffer());
                        if (!this.use_flush) break;
                        this.stopFlush();
                        break;
                    }
                    default: {
                        if (!this.log.isErrorEnabled()) break;
                        this.log.error((Object)("type " + hdr.type + " not known in StateHeader"));
                    }
                }
                return;
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 19: {
                Address target;
                StateTransferInfo info = (StateTransferInfo)evt.getArg();
                if (info.target == null) {
                    target = this.determineCoordinator();
                } else {
                    target = info.target;
                    if (target.equals(this.local_addr)) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)"GET_STATE: cannot fetch state from myself !");
                        }
                        target = null;
                    }
                }
                if (target == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"GET_STATE: first member (no state)");
                    }
                    this.passUp(new Event(20, new StateTransferInfo()));
                } else {
                    boolean successfulFlush = false;
                    if (this.use_flush) {
                        successfulFlush = this.startFlush(this.flush_timeout, 5);
                    }
                    if (successfulFlush) {
                        this.log.info((Object)("Successful flush at " + this.local_addr));
                    }
                    Message state_req = new Message(target, null, null);
                    state_req.putHeader(name, new StateHeader(1, this.local_addr, this.state_id++, null, info.state_id));
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("GET_STATE: asking " + target + " for state"));
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"passing down a SUSPEND_STABLE event");
                    }
                    this.passDown(new Event(65, new Long(info.timeout)));
                    this.waiting_for_state_response = true;
                    this.start = System.currentTimeMillis();
                    this.passDown(new Event(1, state_req));
                }
                return;
            }
            case 18: {
                StateTransferInfo info = (StateTransferInfo)evt.getArg();
                byte[] state = info.state;
                String id = info.state_id;
                Map state_req = this.state_requesters;
                synchronized (state_req) {
                    Set requesters;
                    if (this.state_requesters.size() == 0) {
                        if (this.log.isWarnEnabled()) {
                            this.log.warn((Object)"GET_APPLSTATE_OK: received application state, but there are no requesters !");
                        }
                        return;
                    }
                    if (this.isDigestNeeded()) {
                        if (this.digest == null) {
                            if (this.log.isWarnEnabled()) {
                                this.log.warn((Object)"GET_APPLSTATE_OK: received application state, but there is no digest !");
                            }
                        } else {
                            this.digest = this.digest.copy();
                        }
                    }
                    if (this.stats) {
                        ++this.num_state_reqs;
                        if (state != null) {
                            this.num_bytes_sent += (long)state.length;
                        }
                        this.avg_state_size = this.num_bytes_sent / (long)this.num_state_reqs;
                    }
                    if ((requesters = (Set)this.state_requesters.get(id)) == null || requesters.size() == 0) {
                        this.log.warn((Object)("received state for id=" + id + ", but there are no requesters for this ID"));
                    } else {
                        Iterator it = requesters.iterator();
                        while (it.hasNext()) {
                            Address requester = (Address)it.next();
                            final Message state_rsp = new Message(requester, null, state);
                            StateHeader hdr = new StateHeader(2, this.local_addr, 0L, this.digest, id);
                            state_rsp.putHeader(name, hdr);
                            if (this.log.isTraceEnabled()) {
                                this.log.trace((Object)("sending state for ID=" + id + " to " + requester + " (" + state.length + " bytes)"));
                            }
                            new Thread(){

                                public void run() {
                                    STATE_TRANSFER.this.passDown(new Event(1, state_rsp));
                                }
                            }.start();
                        }
                        this.state_requesters.remove(id);
                    }
                }
                return;
            }
            case 69: {
                if (!this.use_flush) break;
                this.flush_promise.setResult(Boolean.TRUE);
                break;
            }
            case 76: {
                if (!this.use_flush) break;
                this.flush_promise.setResult(Boolean.FALSE);
                break;
            }
            case 56: {
                Map config = (Map)evt.getArg();
                if (config != null && config.containsKey("flush_timeout")) {
                    Long ftimeout = (Long)config.get("flush_timeout");
                    this.use_flush = true;
                    this.flush_timeout = ftimeout;
                }
                if (config == null || config.containsKey("flush_suported")) break;
                this.flushProtocolInStack = true;
            }
        }
        this.passDown(evt);
    }

    private boolean isDigestNeeded() {
        return !this.use_flush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestApplicationStates() {
        Map map = this.state_requesters;
        synchronized (map) {
            HashSet appl_ids = new HashSet(this.state_requesters.keySet());
            Iterator it = appl_ids.iterator();
            while (it.hasNext()) {
                String id = (String)it.next();
                StateTransferInfo info = new StateTransferInfo(null, id, 0L, null);
                this.passUp(new Event(17, info));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Address determineCoordinator() {
        Address ret = null;
        Vector vector = this.members;
        synchronized (vector) {
            if (this.members != null && this.members.size() > 1) {
                for (int i = 0; i < this.members.size(); ++i) {
                    if (this.local_addr.equals(this.members.elementAt(i))) continue;
                    return (Address)this.members.elementAt(i);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleViewChange(View v) {
        Address old_coord;
        Vector new_members = v.getMembers();
        boolean send_up_null_state_rsp = false;
        Vector vector = this.members;
        synchronized (vector) {
            old_coord = this.members.size() > 0 ? this.members.firstElement() : null;
            this.members.clear();
            this.members.addAll(new_members);
            if (this.waiting_for_state_response && old_coord != null && !this.members.contains(old_coord)) {
                send_up_null_state_rsp = true;
            }
        }
        if (send_up_null_state_rsp) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("discovered that the state provider (" + old_coord + ") crashed; will return null state to application"));
            }
            StateHeader hdr = new StateHeader(2, this.local_addr, 0L, null, null);
            this.handleStateRsp(hdr, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStateReq(StateHeader hdr) {
        Address sender = hdr.sender;
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"sender is null !");
            }
            return;
        }
        String id = hdr.state_id;
        Map map = this.state_requesters;
        synchronized (map) {
            boolean empty = this.state_requesters.size() == 0;
            HashSet<Address> requesters = (HashSet<Address>)this.state_requesters.get(id);
            if (requesters == null) {
                requesters = new HashSet<Address>();
                this.state_requesters.put(id, requesters);
            }
            requesters.add(sender);
            if (!this.isDigestNeeded()) {
                this.requestApplicationStates();
            } else if (empty) {
                this.digest = null;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"passing down GET_DIGEST_STATE");
                }
                this.passDown(new Event(42));
            }
        }
    }

    void handleStateRsp(StateHeader hdr, byte[] state) {
        Address sender = hdr.sender;
        Digest tmp_digest = hdr.my_digest;
        String id = hdr.state_id;
        this.waiting_for_state_response = false;
        if (this.isDigestNeeded()) {
            if (tmp_digest == null) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("digest received from " + sender + " is null, skipping setting digest !"));
                }
            } else {
                this.passDown(new Event(41, tmp_digest));
            }
        }
        this.stop = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"passing down a RESUME_STABLE event");
        }
        this.passDown(new Event(66));
        if (state == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("state received from " + sender + " is null, will return null state to application"));
            }
        } else {
            this.log.debug((Object)("received state, size=" + state.length + " bytes. Time=" + (this.stop - this.start) + " milliseconds"));
        }
        StateTransferInfo info = new StateTransferInfo(null, id, 0L, state);
        this.passUp(new Event(20, info));
    }

    private boolean startFlush(long timeout, int numberOfAttempts) {
        boolean successfulFlush = false;
        this.flush_promise.reset();
        this.passUp(new Event(68));
        try {
            Boolean r = (Boolean)this.flush_promise.getResultWithTimeout(timeout);
            successfulFlush = r;
        }
        catch (TimeoutException e) {
            this.log.warn((Object)("Initiator of flush and state requesting member " + this.local_addr + " timed out waiting for flush responses after " + this.flush_timeout + " msec"));
        }
        if (!successfulFlush && numberOfAttempts > 0) {
            long backOffSleepTime = Util.random(5000L);
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Flush in progress detected at " + this.local_addr + ". Backing off for " + backOffSleepTime + " ms. Attempts left " + numberOfAttempts));
            }
            Util.sleepRandom(backOffSleepTime);
            successfulFlush = this.startFlush(this.flush_timeout, --numberOfAttempts);
        }
        return successfulFlush;
    }

    private void stopFlush() {
        this.passUp(new Event(70));
    }

    public static class StateHeader
    extends Header
    implements Streamable {
        public static final byte STATE_REQ = 1;
        public static final byte STATE_RSP = 2;
        long id = 0L;
        byte type = 0;
        Address sender;
        Digest my_digest = null;
        String state_id = null;

        public StateHeader() {
        }

        public StateHeader(byte type, Address sender, long id, Digest digest) {
            this.type = type;
            this.sender = sender;
            this.id = id;
            this.my_digest = digest;
        }

        public StateHeader(byte type, Address sender, long id, Digest digest, String state_id) {
            this.type = type;
            this.sender = sender;
            this.id = id;
            this.my_digest = digest;
            this.state_id = state_id;
        }

        public int getType() {
            return this.type;
        }

        public Digest getDigest() {
            return this.my_digest;
        }

        public String getStateId() {
            return this.state_id;
        }

        public boolean equals(Object o) {
            if (this.sender != null && o != null) {
                if (!(o instanceof StateHeader)) {
                    return false;
                }
                StateHeader other = (StateHeader)o;
                return this.sender.equals(other.sender) && this.id == other.id;
            }
            return false;
        }

        public int hashCode() {
            if (this.sender != null) {
                return this.sender.hashCode() + (int)this.id;
            }
            return (int)this.id;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("type=").append(StateHeader.type2Str(this.type));
            if (this.sender != null) {
                sb.append(", sender=").append(this.sender).append(" id=").append(this.id);
            }
            if (this.my_digest != null) {
                sb.append(", digest=").append(this.my_digest);
            }
            if (this.state_id != null) {
                sb.append(", state_id=").append(this.state_id);
            }
            return sb.toString();
        }

        static String type2Str(int t) {
            switch (t) {
                case 1: {
                    return "STATE_REQ";
                }
                case 2: {
                    return "STATE_RSP";
                }
            }
            return "<unknown>";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.sender);
            out.writeLong(this.id);
            out.writeByte(this.type);
            out.writeObject(this.my_digest);
            if (this.state_id == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(this.state_id);
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.sender = (Address)in.readObject();
            this.id = in.readLong();
            this.type = in.readByte();
            this.my_digest = (Digest)in.readObject();
            if (in.readBoolean()) {
                this.state_id = in.readUTF();
            }
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.id);
            Util.writeAddress(this.sender, out);
            Util.writeStreamable(this.my_digest, out);
            Util.writeString(this.state_id, out);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.id = in.readLong();
            this.sender = Util.readAddress(in);
            this.my_digest = (Digest)Util.readStreamable(class$org$jgroups$protocols$pbcast$Digest == null ? (class$org$jgroups$protocols$pbcast$Digest = STATE_TRANSFER.class$("org.jgroups.protocols.pbcast.Digest")) : class$org$jgroups$protocols$pbcast$Digest, in);
            this.state_id = Util.readString(in);
        }

        public long size() {
            long retval = 9L;
            retval += (long)Util.size(this.sender);
            ++retval;
            if (this.my_digest != null) {
                retval += this.my_digest.serializedSize();
            }
            ++retval;
            if (this.state_id != null) {
                retval += (long)(this.state_id.length() + 2);
            }
            return retval;
        }
    }
}

