/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.mysql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Set;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.plugins.database.DatabaseComponent;
import org.rhq.plugins.mysql.MySqlDiscoveryComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySqlComponent
implements DatabaseComponent,
ResourceComponent,
MeasurementFacet {
    private ResourceContext resourceContext;
    private Connection connection;

    public void start(ResourceContext resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = resourceContext;
        this.getConnection();
    }

    public void stop() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public AvailabilityType getAvailability() {
        try {
            this.getConnection().createStatement().executeQuery("select 1");
            return AvailabilityType.UP;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return AvailabilityType.DOWN;
        }
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        ResultSet rs = this.getConnection().createStatement().executeQuery("SHOW /*!50002 GLOBAL */ STATUS");
        HashMap<String, String> values = new HashMap<String, String>();
        while (rs.next()) {
            values.put(rs.getString(1), rs.getString(2));
        }
        for (MeasurementScheduleRequest request : metrics) {
            if (request.getName().startsWith("Process") || request.getDataType() != DataType.MEASUREMENT) continue;
            try {
                String strVal = (String)values.get(request.getName());
                double val = Double.parseDouble(strVal);
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(val)));
            }
            catch (Exception e) {}
        }
    }

    public Connection getConnection() {
        try {
            this.connection = MySqlDiscoveryComponent.buildConnection(this.resourceContext.getPluginConfiguration());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this.connection;
    }

    public void removeConnection() {
        this.connection = null;
    }

    public static void main(String[] args) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        try {
            int i;
            Class.forName("com.mysql.jdbc.Driver").newInstance();
            Connection conn = DriverManager.getConnection("jdbc:mysql://192.168.1.5?user=rhqadmin&password=rhqadmin");
            DatabaseMetaData dmd = conn.getMetaData();
            System.out.println("Version: " + dmd.getDatabaseProductVersion());
            System.out.println("Product: " + dmd.getDatabaseProductName());
            ResultSet rs = conn.createStatement().executeQuery("SHOW TABLE STATUS FROM mysql");
            ResultSetMetaData md = rs.getMetaData();
            for (i = 1; i <= md.getColumnCount(); ++i) {
                System.out.print(md.getColumnName(i) + "    ");
            }
            System.out.println("");
            while (rs.next()) {
                for (i = 1; i <= md.getColumnCount(); ++i) {
                    System.out.print(rs.getObject(i) + "    ");
                }
                System.out.println("");
            }
        }
        catch (SQLException ex) {
            System.out.println("SQLException: " + ex.getMessage());
            System.out.println("SQLState: " + ex.getSQLState());
            System.out.println("VendorError: " + ex.getErrorCode());
        }
    }
}

