/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.configuration.AbstractObjectInfo;
import org.jbpm.configuration.BeanInfo;
import org.jbpm.configuration.ConfigurationException;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.configuration.ObjectInfo;
import org.jbpm.svc.Services;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class JbpmContextInfo
extends AbstractObjectInfo {
    private static final long serialVersionUID = 1L;
    Map serviceFactoryObjectInfos = null;
    Map serviceFactories = null;
    List serviceNames = null;
    ObjectInfo[] saveOperationObjectInfos = null;
    List saveOperations = null;
    private static Log log = LogFactory.getLog((Class)JbpmContextInfo.class);

    public JbpmContextInfo(Element jbpmContextElement, ObjectFactoryParser objectFactoryParser) {
        super(JbpmContextInfo.verifyDefaultName(jbpmContextElement), objectFactoryParser);
        if (jbpmContextElement.hasAttribute("singleton")) {
            throw new ConfigurationException("attribute 'singleton' is not allowed in element 'jbpm-context'");
        }
        this.serviceFactoryObjectInfos = new HashMap();
        List serviceElements = XmlUtil.elements(jbpmContextElement, "service");
        this.serviceNames = new ArrayList();
        Iterator iter = serviceElements.iterator();
        while (iter.hasNext()) {
            Element serviceElement = (Element)iter.next();
            if (!serviceElement.hasAttribute("name")) {
                throw new ConfigurationException("name is required in service element " + XmlUtil.toString(serviceElement));
            }
            String serviceName = serviceElement.getAttribute("name");
            this.serviceNames.add(serviceName);
            ObjectInfo serviceFactoryObjectInfo = null;
            if (serviceElement.hasAttribute("factory")) {
                String factoryClassName = serviceElement.getAttribute("factory");
                BeanInfo beanInfo = new BeanInfo();
                beanInfo.setClassName(factoryClassName);
                serviceFactoryObjectInfo = beanInfo;
            } else {
                Element factoryElement = XmlUtil.element(serviceElement, "factory");
                if (factoryElement == null) {
                    throw new ConfigurationException("element 'service' requires either a factory attribute or a factory element");
                }
                Element factoryBeanElement = XmlUtil.element(factoryElement);
                if (factoryBeanElement == null) {
                    throw new ConfigurationException("element 'factory' requires either a bean or ref element");
                }
                serviceFactoryObjectInfo = objectFactoryParser.parse(factoryBeanElement);
            }
            this.serviceFactoryObjectInfos.put(serviceName, serviceFactoryObjectInfo);
        }
        Element saveOperationsElement = XmlUtil.element(jbpmContextElement, "save-operations");
        if (saveOperationsElement != null) {
            List saveOperationElements = XmlUtil.elements(saveOperationsElement, "save-operation");
            this.saveOperationObjectInfos = new ObjectInfo[saveOperationElements.size()];
            for (int i = 0; i < saveOperationElements.size(); ++i) {
                Element saveOperationElement = (Element)saveOperationElements.get(i);
                if (saveOperationElement.hasAttribute("class")) {
                    String saveOperationClassName = saveOperationElement.getAttribute("class");
                    BeanInfo beanInfo = new BeanInfo();
                    beanInfo.setClassName(saveOperationClassName);
                    this.saveOperationObjectInfos[i] = beanInfo;
                    continue;
                }
                Element saveOperationBeanElement = XmlUtil.element(saveOperationElement);
                if (saveOperationBeanElement == null) {
                    throw new ConfigurationException("element 'save-operation' requires either a class attribute or an element of type 'bean' or 'ref'");
                }
                this.saveOperationObjectInfos[i] = objectFactoryParser.parse(saveOperationBeanElement);
            }
        }
    }

    static Element verifyDefaultName(Element jbpmContextElement) {
        if (!jbpmContextElement.hasAttribute("name")) {
            jbpmContextElement.setAttribute("name", "default.jbpm.context");
        }
        return jbpmContextElement;
    }

    public synchronized Object createObject(ObjectFactoryImpl objectFactory) {
        if (this.serviceFactories == null) {
            this.serviceFactories = new HashMap();
            Iterator iter = this.serviceFactoryObjectInfos.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String serviceName = (String)entry.getKey();
                ObjectInfo serviceFactoryObjectInfo = (ObjectInfo)entry.getValue();
                this.serviceFactories.put(serviceName, serviceFactoryObjectInfo.createObject(objectFactory));
            }
        }
        if (this.saveOperations == null && this.saveOperationObjectInfos != null) {
            this.saveOperations = new ArrayList();
            for (int i = 0; i < this.saveOperationObjectInfos.length; ++i) {
                Object saveOperation = this.saveOperationObjectInfos[i].createObject(objectFactory);
                this.saveOperations.add(saveOperation);
            }
        }
        Services services = new Services(this.serviceFactories, this.serviceNames, this.saveOperations);
        if (log.isDebugEnabled()) {
            log.debug((Object)("creating jbpm context with service factories '" + this.serviceFactories.keySet() + "'"));
        }
        return new JbpmContext(services, objectFactory);
    }
}

