/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.configuration;

import org.jbpm.configuration.AbstractObjectInfo;
import org.jbpm.configuration.ConfigurationException;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.configuration.ObjectInfo;
import org.jbpm.context.exe.Converter;
import org.jbpm.context.exe.JbpmType;
import org.jbpm.context.exe.JbpmTypeMatcher;
import org.jbpm.context.exe.VariableInstance;
import org.jbpm.db.hibernate.Converters;
import org.jbpm.util.ClassLoaderUtil;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class JbpmTypeObjectInfo
extends AbstractObjectInfo {
    private static final long serialVersionUID = 1L;
    ObjectInfo typeMatcherObjectInfo = null;
    Converter converter = null;
    Class variableInstanceClass = null;

    public JbpmTypeObjectInfo(Element jbpmTypeElement, ObjectFactoryParser objectFactoryParser) {
        super(jbpmTypeElement, objectFactoryParser);
        Element variableInstanceElement;
        Element typeMatcherElement = XmlUtil.element(jbpmTypeElement, "matcher");
        if (typeMatcherElement == null) {
            throw new ConfigurationException("matcher is a required element in a jbpm-type: " + XmlUtil.toString(jbpmTypeElement));
        }
        Element typeMatcherBeanElement = XmlUtil.element(typeMatcherElement);
        this.typeMatcherObjectInfo = objectFactoryParser.parse(typeMatcherBeanElement);
        Element converterElement = XmlUtil.element(jbpmTypeElement, "converter");
        if (converterElement != null) {
            if (!converterElement.hasAttribute("class")) {
                throw new ConfigurationException("class attribute is required in a converter element: " + XmlUtil.toString(jbpmTypeElement));
            }
            String converterClassName = converterElement.getAttribute("class");
            this.converter = Converters.getConverterByClassName(converterClassName);
        }
        if (!(variableInstanceElement = XmlUtil.element(jbpmTypeElement, "variable-instance")).hasAttribute("class")) {
            throw new ConfigurationException("class is a required attribute in element variable-instance: " + XmlUtil.toString(jbpmTypeElement));
        }
        String variableInstanceClassName = variableInstanceElement.getAttribute("class");
        try {
            this.variableInstanceClass = ClassLoaderUtil.loadClass(variableInstanceClassName);
            if (!VariableInstance.class.isAssignableFrom(this.variableInstanceClass)) {
                throw new ConfigurationException("variable instance class '" + variableInstanceClassName + "' is not a VariableInstance");
            }
        }
        catch (Exception e) {
            this.variableInstanceClass = null;
            throw new ConfigurationException("invalid variable instance class name '" + variableInstanceClassName + "' : " + XmlUtil.toString(jbpmTypeElement));
        }
    }

    public Object createObject(ObjectFactoryImpl objectFactory) {
        JbpmTypeMatcher jbpmTypeMatcher = (JbpmTypeMatcher)objectFactory.createObject(this.typeMatcherObjectInfo);
        return new JbpmType(jbpmTypeMatcher, this.converter, this.variableInstanceClass);
    }
}

